/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMacroParameter;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.SystemMacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroImpl
extends OffsetableIdentifiableBase<CsmMacro>
implements CsmMacro {
    private final CharSequence name;
    private final CharSequence body;
    private final CsmMacro.Kind kind;
    private final List<CharSequence> params;

    public static SystemMacroImpl createSystemMacro(CharSequence charSequence, String string, CsmFile csmFile, CsmMacro.Kind kind) {
        return new SystemMacroImpl(charSequence, string, null, csmFile, kind);
    }

    public MacroImpl(CharSequence charSequence, List<CharSequence> list, String string, CsmFile csmFile, CsmOffsetable csmOffsetable, CsmMacro.Kind kind) {
        super(csmFile, csmOffsetable);
        CharSequence charSequence2 = charSequence = charSequence == null ? CharSequenceKey.empty() : charSequence;
        assert (string != null);
        this.name = NameCache.getManager().getString(charSequence);
        this.kind = kind;
        this.body = DefaultCache.getManager().getString((CharSequence)string);
        this.params = list != null ? Collections.unmodifiableList(list) : null;
    }

    public MacroImpl(CharSequence charSequence, List<CharSequence> list, String string, CsmFile csmFile, CsmOffsetable csmOffsetable) {
        this(charSequence, list, string, csmFile, csmOffsetable, CsmMacro.Kind.DEFINED);
    }

    public List<CharSequence> getParameters() {
        return this.params;
    }

    public CharSequence getBody() {
        return this.body;
    }

    public CsmMacro.Kind getKind() {
        return this.kind;
    }

    public CharSequence getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#define '");
        stringBuilder.append(this.getName());
        if (this.getParameters() != null) {
            stringBuilder.append("[");
            Iterator<CharSequence> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = iterator.next();
                stringBuilder.append(charSequence);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        }
        if (this.getBody().length() > 0) {
            stringBuilder.append("'='");
            stringBuilder.append(this.getBody());
        }
        stringBuilder.append("' [");
        stringBuilder.append(this.getStartPosition()).append("-").append(this.getEndPosition());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof MacroImpl)) {
            bl = false;
        } else {
            MacroImpl macroImpl = (MacroImpl)object;
            bl = MacroImpl.equals(this, macroImpl);
        }
        return bl;
    }

    private static final boolean equals(MacroImpl macroImpl, MacroImpl macroImpl2) {
        return macroImpl.getStartOffset() == macroImpl2.getStartOffset() && CharSequenceKey.Comparator.compare(macroImpl.getName(), macroImpl2.getName()) == 0;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.getStartOffset();
        n = 31 * n + this.getName().hashCode();
        return n;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        assert (this.body != null);
        PersistentUtils.writeUTF(this.body, dataOutput);
        dataOutput.writeByte((byte)this.kind.ordinal());
        CharSequence[] charSequenceArray = this.params == null ? null : this.params.toArray(new CharSequence[this.params.size()]);
        PersistentUtils.writeStrings(charSequenceArray, dataOutput);
    }

    public MacroImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.body = PersistentUtils.readUTF(dataInput, DefaultCache.getManager());
        assert (this.body != null);
        this.kind = CsmMacro.Kind.values()[dataInput.readByte()];
        CharSequence[] charSequenceArray = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.params = charSequenceArray == null ? null : Collections.unmodifiableList(Arrays.asList(charSequenceArray));
    }

    @Override
    protected CsmUID<CsmMacro> createUID() {
        return UIDUtilities.createMacroUID(this);
    }

    public CsmParameterList<CsmMacroParameter> getParameterList() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

