/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver3;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsingDeclarationImpl
extends OffsetableDeclarationBase<CsmUsingDeclaration>
implements CsmUsingDeclaration,
RawNamable,
Disposable {
    private final CharSequence name;
    private final int startOffset;
    private final CharSequence[] rawName;
    private CsmUID<CsmDeclaration> referencedDeclarationUID = null;
    private WeakReference<CsmDeclaration> refDeclaration;
    private boolean lastResolveFalure;
    private final CsmUID<CsmScope> scopeUID;

    public UsingDeclarationImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) {
        super(aST, csmFile);
        this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        this.startOffset = ((CsmAST)aST.getFirstChild()).getOffset();
        this.rawName = AstUtil.getRawNameInChildren(aST);
        if (!bl) {
            Utils.setSelfUID(this);
        }
    }

    public CsmDeclaration getReferencedDeclaration() {
        return this.getReferencedDeclaration(null);
    }

    public CsmDeclaration getReferencedDeclaration(Resolver resolver) {
        CsmDeclaration csmDeclaration = this._getReferencedDeclaration();
        if (csmDeclaration == null && !this.lastResolveFalure) {
            this._setReferencedDeclaration(null);
            if (this.rawName != null) {
                CsmObject csmObject;
                CharSequence[] charSequenceArray;
                ProjectBase projectBase = (ProjectBase)this.getProject();
                CsmNamespace csmNamespace = null;
                if (this.rawName.length == 1) {
                    csmNamespace = projectBase.getGlobalNamespace();
                } else if (this.rawName.length > 1) {
                    charSequenceArray = new CharSequence[this.rawName.length - 1];
                    System.arraycopy(this.rawName, 0, charSequenceArray, 0, this.rawName.length - 1);
                    csmObject = ResolverFactory.createResolver(this.getContainingFile(), this.startOffset, resolver).resolve(charSequenceArray, 1);
                    if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                        csmNamespace = (CsmNamespace)csmObject;
                    }
                }
                if (csmNamespace != null) {
                    Object object;
                    charSequenceArray = this.rawName[this.rawName.length - 1];
                    csmObject = null;
                    CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)charSequenceArray, true, true, false);
                    LinkedHashSet<CsmNamespace> linkedHashSet = new LinkedHashSet<CsmNamespace>();
                    linkedHashSet.add(csmNamespace);
                    CharSequence charSequence = csmNamespace.getQualifiedName();
                    Collection<CsmProject> collection = resolver != null ? resolver.getLibraries() : Resolver3.getSearchLibraries(projectBase);
                    for (CsmProject object3 : collection) {
                        CsmNamespace csmNamespace2 = object3.findNamespace(charSequence);
                        if (csmNamespace2 == null) continue;
                        linkedHashSet.add(csmNamespace2);
                    }
                    block1: for (CsmNamespace csmNamespace3 : linkedHashSet) {
                        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace3, (CsmSelect.CsmFilter)csmFilter);
                        while (iterator.hasNext()) {
                            object = (CsmDeclaration)iterator.next();
                            if (CharSequenceKey.Comparator.compare(charSequenceArray, object.getName()) != 0) continue;
                            if (!CsmKindUtilities.isExternVariable((CsmDeclaration)object)) {
                                csmDeclaration = object;
                                break block1;
                            }
                            csmObject = object;
                        }
                    }
                    if (csmDeclaration == null && csmObject == null) {
                        Iterator<Object> iterator = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM});
                        block3: for (CsmNamespace csmNamespace4 : linkedHashSet) {
                            object = CsmSelect.getDeclarations((CsmNamespace)csmNamespace4, iterator);
                            while (object.hasNext()) {
                                CsmDeclaration csmDeclaration2 = (CsmDeclaration)object.next();
                                if (!CsmKindUtilities.isEnum((CsmObject)csmDeclaration2)) continue;
                                CsmEnum csmEnum = (CsmEnum)csmDeclaration2;
                                for (CsmEnumerator csmEnumerator : csmEnum.getEnumerators()) {
                                    if (!charSequenceArray.toString().equals(((Object)csmEnumerator.getName()).toString())) continue;
                                    csmDeclaration = csmEnumerator;
                                    break block3;
                                }
                            }
                        }
                    }
                    csmDeclaration = csmDeclaration == null ? csmObject : csmDeclaration;
                }
            }
            this._setReferencedDeclaration(csmDeclaration);
            this.lastResolveFalure = csmDeclaration == null;
        }
        return csmDeclaration;
    }

    private CsmDeclaration _getReferencedDeclaration() {
        CsmDeclaration csmDeclaration = null;
        WeakReference<CsmDeclaration> weakReference = this.refDeclaration;
        if (weakReference != null) {
            csmDeclaration = (CsmDeclaration)weakReference.get();
        }
        if (csmDeclaration == null) {
            csmDeclaration = UIDCsmConverter.UIDtoDeclaration(this.referencedDeclarationUID);
            this.refDeclaration = new WeakReference<CsmDeclaration>(csmDeclaration);
        }
        return csmDeclaration;
    }

    private void _setReferencedDeclaration(CsmDeclaration csmDeclaration) {
        this.refDeclaration = csmDeclaration != null ? new WeakReference<CsmDeclaration>(csmDeclaration) : null;
        this.referencedDeclarationUID = UIDCsmConverter.declarationToUID(csmDeclaration);
        assert (this.referencedDeclarationUID != null || csmDeclaration == null);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.USING_DECLARATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return this.rawName;
    }

    public CsmScope getScope() {
        return UIDCsmConverter.UIDtoScope(this.scopeUID);
    }

    @Override
    public void dispose() {
        super.dispose();
        CsmScope csmScope = this.getScope();
        if (csmScope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)csmScope).removeDeclaration(this);
        }
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        dataOutput.writeInt(this.startOffset);
        PersistentUtils.writeStrings(this.rawName, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.referencedDeclarationUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public UsingDeclarationImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.startOffset = dataInput.readInt();
        this.rawName = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.referencedDeclarationUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

