/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.modelimpl.csm.core.AbstractFileBuffer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FileBufferFile
extends AbstractFileBuffer {
    private volatile SoftReference<String> cachedString;
    private volatile long lastModifiedWhenCachedString;

    public FileBufferFile(File file) {
        super(file);
    }

    public String getText() throws IOException {
        return this.asString();
    }

    public String getText(int n, int n2) {
        try {
            String string = this.asString();
            if (n2 > string.length()) {
                new IllegalArgumentException("").printStackTrace(System.err);
                n2 = string.length();
            }
            return string.substring(n, n2);
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    private String getEncoding() {
        File file = this.getFile();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        Charset charset = null;
        if (fileObject != null) {
            charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        }
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
        }
        return charset.name();
    }

    private synchronized String asString() throws IOException {
        String string;
        if (this.cachedString != null && (string = this.cachedString.get()) != null && this.lastModifiedWhenCachedString == this.lastModified()) {
            return string;
        }
        byte[] byArray = this.doGetBytes();
        string = new String(byArray, this.getEncoding());
        this.lastModifiedWhenCachedString = this.lastModified();
        this.cachedString = new SoftReference<String>(string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doGetBytes() throws IOException {
        File file = this.getFile();
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            new IllegalArgumentException("File is too large: " + file.getAbsolutePath()).printStackTrace(System.err);
        }
        byte[] byArray = new byte[(int)l];
        InputStream inputStream = this.getInputStream();
        try {
            int n = 0;
            for (int i = 0; i < byArray.length && (n = inputStream.read(byArray, i, byArray.length - i)) >= 0; i += n) {
            }
        }
        finally {
            inputStream.close();
        }
        FileBufferFile.convertLSToLF(byArray);
        return byArray;
    }

    private static int convertLSToLF(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == 13) {
                n4 = i + 1 < n2 && byArray[i + 1] == 10 ? 2 : 1;
            }
            if (n4 <= 0) continue;
            n = i - n5;
            if (n > 0) {
                if (n3 != n5) {
                    System.arraycopy(byArray, n5, byArray, n3, n);
                }
                n3 += n;
            }
            byArray[n3++] = 10;
            n5 += n + n4;
            i += n4 - 1;
            n4 = 0;
        }
        n = n2 - n5;
        if (n > 0) {
            if (n3 != n5) {
                System.arraycopy(byArray, n5, byArray, n3, n);
            }
            n3 += n;
        }
        return n3;
    }

    public InputStream getInputStream() throws IOException {
        File file = this.getFile();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        InputStream inputStream = fileObject != null ? fileObject.getInputStream() : new FileInputStream(file);
        return new BufferedInputStream(inputStream, TraceFlags.BUF_SIZE);
    }

    public int getLength() {
        return (int)this.getFile().length();
    }

    public boolean isFileBased() {
        return true;
    }

    public long lastModified() {
        return this.getFile().lastModified();
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
    }

    public FileBufferFile(DataInput dataInput) throws IOException {
        super(dataInput);
    }
}

