/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

class FileStateCache {
    private static final boolean TRACE = false;
    private static final boolean cacheStates = TraceFlags.CACHE_FILE_STATE;
    private static final int CACHE_SIZE = 10;
    private static final int MAX_KEY_SIZE = 100;
    private static int stateCacheAttempt = 0;
    private static int stateCacheSuccessAttempt = 0;
    private Map<String, Value> stateCache = new LinkedHashMap<String, Value>();
    private final ReadWriteLock stateCacheLock = new ReentrantReadWriteLock();
    private final FileImpl file;

    FileStateCache(FileImpl fileImpl) {
        this.file = fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheVisitedState(APTPreprocHandler.State state, APTPreprocHandler aPTPreprocHandler) {
        if (cacheStates && state.isCompileContext()) {
            this.stateCacheLock.writeLock().lock();
            try {
                if ((this.stateCache.isEmpty() || APTHandlersSupport.getIncludeStackDepth((APTPreprocHandler.State)state) == 1) && this.isCacheableState(state)) {
                    if (this.stateCache.size() == 10) {
                        int n = Integer.MAX_VALUE;
                        String string = null;
                        for (Map.Entry<String, Value> entry : this.stateCache.entrySet()) {
                            if (entry.getValue().value.get() == null) {
                                string = entry.getKey();
                                break;
                            }
                            if (entry.getValue().count >= n) continue;
                            string = entry.getKey();
                            n = entry.getValue().count;
                        }
                        this.stateCache.remove(string);
                    }
                    this.stateCache.put(FileStateCache.createKey(state), new Value(aPTPreprocHandler.getState()));
                }
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    APTPreprocHandler.State getCachedVisitedState(APTPreprocHandler.State state) {
        APTPreprocHandler.State state2 = null;
        if (cacheStates && state.isCompileContext()) {
            this.stateCacheLock.readLock().lock();
            String string = null;
            try {
                Value value;
                if (this.isCacheableState(state) && (value = this.stateCache.get(string = FileStateCache.createKey(state))) != null) {
                    state2 = (APTPreprocHandler.State)value.value.get();
                    value.count++;
                }
            }
            finally {
                this.stateCacheLock.readLock().unlock();
            }
        }
        return state2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStateCache() {
        if (cacheStates) {
            try {
                this.stateCacheLock.writeLock().lock();
                this.stateCache.clear();
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    private static String createKey(APTPreprocHandler.State state) {
        return APTHandlersSupport.getMacroMapID((APTPreprocHandler.State)state);
    }

    private boolean isCacheableState(APTPreprocHandler.State state) {
        return APTHandlersSupport.getMacroSize((APTPreprocHandler.State)state) < 100;
    }

    private static class Value {
        private final SoftReference<APTPreprocHandler.State> value;
        private int count;

        private Value(APTPreprocHandler.State state) {
            this.value = new SoftReference<APTPreprocHandler.State>(state);
        }
    }
}

