/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTDefinesCollectorWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.MacroInfo;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.TextCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTFindMacrosWalker
extends APTDefinesCollectorWalker {
    protected final Map<CharSequence, CsmFile> macro2file = new HashMap<CharSequence, CsmFile>();
    private final List<CsmReference> references = new ArrayList<CsmReference>();

    public APTFindMacrosWalker(APTFile aPTFile, CsmFile csmFile, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry) {
        super(aPTFile, csmFile, aPTPreprocHandler, null);
    }

    @Override
    protected void onDefine(APT aPT) {
        APTDefine aPTDefine = (APTDefine)aPT;
        APTToken aPTToken = aPTDefine.getName();
        if (aPTToken != null) {
            MacroInfo macroInfo = new MacroInfo(this.csmFile, aPTDefine.getOffset(), null);
            MacroReference macroReference = new MacroReference(this.csmFile, aPTToken, macroInfo);
            this.references.add(macroReference);
        }
        this.analyzeList(aPTDefine.getBody());
        super.onDefine(aPT);
    }

    protected boolean onIf(APT aPT) {
        this.analyzeStream(((APTIf)aPT).getCondition(), false);
        return super.onIf(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        this.analyzeStream(((APTElif)aPT).getCondition(), false);
        return super.onElif(aPT, bl);
    }

    protected boolean onIfndef(APT aPT) {
        this.analyzeToken(((APTIfndef)aPT).getMacroName(), false);
        return super.onIfndef(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        this.analyzeToken(((APTIfdef)aPT).getMacroName(), false);
        return super.onIfdef(aPT);
    }

    @Override
    protected void onUndef(APT aPT) {
        this.analyzeToken(((APTUndefine)aPT).getName(), false);
        super.onUndef(aPT);
    }

    protected void onInclude(APT aPT) {
        this.analyzeStream(((APTInclude)aPT).getInclude(), true);
        super.onInclude(aPT);
    }

    protected void onIncludeNext(APT aPT) {
        this.analyzeStream(((APTIncludeNext)aPT).getInclude(), true);
        super.onIncludeNext(aPT);
    }

    public List<CsmReference> getCollectedData() {
        return this.references;
    }

    public TokenStream getTokenStream() {
        TokenStream tokenStream = super.getTokenStream();
        this.analyzeStream(tokenStream, true);
        return null;
    }

    private CsmReference analyzeToken(APTToken aPTToken, boolean bl) {
        APTMacro aPTMacro;
        OffsetableBase offsetableBase = null;
        boolean bl2 = false;
        if (aPTToken != null && !APTUtils.isEOF((Token)aPTToken) && (aPTMacro = this.getMacroMap().getMacro(aPTToken)) != null) {
            bl2 = aPTMacro.isFunctionLike();
            switch (aPTMacro.getKind()) {
                case DEFINED: {
                    CsmFile csmFile;
                    MacroInfo macroInfo = this.getMacroInfo(aPTToken);
                    if (macroInfo == null && (csmFile = this.getMacroFile(aPTMacro)) != null) {
                        macroInfo = new MacroInfo(csmFile, aPTMacro.getDefineNode().getOffset(), aPTMacro.getFile());
                    }
                    if (macroInfo != null) {
                        offsetableBase = new MacroReference(this.csmFile, aPTToken, macroInfo);
                        break;
                    }
                    offsetableBase = new SysMacroReference(this.csmFile, aPTToken, aPTMacro);
                    break;
                }
                default: {
                    offsetableBase = new SysMacroReference(this.csmFile, aPTToken, aPTMacro);
                }
            }
        }
        if (!(offsetableBase == null || bl2 && bl)) {
            this.references.add((CsmReference)offsetableBase);
            offsetableBase = null;
        }
        return offsetableBase;
    }

    private void analyzeList(List<APTToken> list) {
        if (list != null) {
            for (APTToken aPTToken : list) {
                this.analyzeToken(aPTToken, false);
            }
        }
    }

    private void analyzeStream(TokenStream tokenStream, boolean bl) {
        if (tokenStream != null) {
            try {
                APTToken aPTToken = (APTToken)tokenStream.nextToken();
                while (!APTUtils.isEOF((Token)aPTToken)) {
                    CsmReference csmReference = this.analyzeToken(aPTToken, bl);
                    aPTToken = (APTToken)tokenStream.nextToken();
                    if (csmReference == null) continue;
                    assert (bl);
                    if (aPTToken.getType() != 138) continue;
                    this.references.add(csmReference);
                }
            }
            catch (TokenStreamException tokenStreamException) {
                DiagnosticExceptoins.register(tokenStreamException);
            }
        }
    }

    private CsmFile getMacroFile(APTMacro aPTMacro) {
        CsmFile csmFile = null;
        CharSequence charSequence = aPTMacro.getFile();
        if (charSequence.length() > 0 && (csmFile = this.macro2file.get(charSequence)) == null) {
            ProjectBase projectBase = ((ProjectBase)this.csmFile.getProject()).findFileProject(charSequence);
            if (projectBase != null) {
                csmFile = projectBase.getFile(new File(((Object)charSequence).toString()), false);
            }
            if (csmFile != null) {
                this.macro2file.put(charSequence, csmFile);
            }
        }
        return csmFile;
    }

    private static class MacroReference
    extends OffsetableBase
    implements CsmReference {
        private CsmObject ref;
        private final CharSequence macroName;
        private final MacroInfo mi;

        public MacroReference(CsmFile csmFile, APTToken aPTToken, MacroInfo macroInfo) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            this.macroName = aPTToken.getTextID();
            assert (this.macroName != null);
            this.mi = macroInfo;
        }

        public CsmObject getReferencedObject() {
            CsmFile csmFile;
            if (this.ref == null && this.mi != null && (csmFile = this.getTargetFile()) != null) {
                CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.macroName, true, true, false);
                Iterator iterator = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
                while (iterator.hasNext()) {
                    CsmMacro csmMacro = (CsmMacro)iterator.next();
                    if (csmMacro == null || this.mi.startOffset != csmMacro.getStartOffset()) continue;
                    this.ref = csmMacro;
                }
                if (this.ref == null) {
                    if (csmFile instanceof Unresolved.UnresolvedFile) {
                        this.ref = MacroImpl.createSystemMacro(this.macroName, "", csmFile, CsmMacro.Kind.USER_SPECIFIED);
                    } else {
                        this.ref = new MacroImpl(this.macroName, null, "", csmFile, new OffsetableBase(csmFile, this.mi.startOffset, this.mi.startOffset + this.macroName.length()), CsmMacro.Kind.DEFINED);
                        Utils.setSelfUID(this.ref);
                    }
                }
            }
            return this.ref;
        }

        private CsmFile getTargetFile() {
            CsmFile csmFile = UIDCsmConverter.UIDtoFile(this.mi.targetFile);
            if (csmFile != null && this.mi.includePath != null && this.mi.includePath.length() > 0) {
                File file = new File(((Object)this.mi.includePath).toString());
                ProjectBase projectBase = ((ProjectBase)csmFile.getProject()).findFileProject(file.getAbsolutePath());
                if (projectBase == null) {
                    file = CndFileUtils.normalizeFile((File)file);
                    projectBase = ((ProjectBase)csmFile.getProject()).findFileProject(file.getAbsolutePath());
                }
                if (projectBase != null) {
                    csmFile = projectBase.getFile(file, false);
                }
            }
            return csmFile;
        }

        public CsmObject getOwner() {
            return this.getTargetFile();
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DECLARATION;
        }

        public CharSequence getText() {
            return DefaultCache.getManager().getString(super.getText());
        }
    }

    private static class SysMacroReference
    extends OffsetableBase
    implements CsmReference {
        private final CsmObject ref;

        public SysMacroReference(CsmFile csmFile, APTToken aPTToken, APTMacro aPTMacro) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            CsmMacro.Kind kind;
            switch (aPTMacro.getKind()) {
                case COMPILER_PREDEFINED: {
                    kind = CsmMacro.Kind.COMPILER_PREDEFINED;
                    break;
                }
                case POSITION_PREDEFINED: {
                    kind = CsmMacro.Kind.POSITION_PREDEFINED;
                    break;
                }
                case DEFINED: {
                    kind = CsmMacro.Kind.DEFINED;
                    break;
                }
                case USER_SPECIFIED: {
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                    break;
                }
                default: {
                    System.err.println("unexpected kind in macro " + aPTMacro);
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                }
            }
            this.ref = MacroImpl.createSystemMacro(aPTToken.getTextID(), APTUtils.stringize((TokenStream)aPTMacro.getBody(), (boolean)false), ((ProjectBase)csmFile.getProject()).getUnresolvedFile(), kind);
        }

        public CsmObject getReferencedObject() {
            return this.ref;
        }

        public CsmObject getOwner() {
            return null;
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DECLARATION;
        }

        public CharSequence getText() {
            return TextCache.getManager().getString(super.getText());
        }
    }
}

