/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.model.CsmBuiltIn;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDUtilities {
    private static AtomicInteger UnnamedID = new AtomicInteger(0);

    private UIDUtilities() {
    }

    public static CsmUID<CsmProject> createProjectUID(ProjectBase projectBase) {
        return UIDManager.instance().getSharedUID(new ProjectUID(projectBase));
    }

    public static CsmUID<CsmFile> createFileUID(FileImpl fileImpl) {
        return UIDManager.instance().getSharedUID(new FileUID(fileImpl));
    }

    public static CsmUID<CsmNamespace> createNamespaceUID(CsmNamespace csmNamespace) {
        return UIDManager.instance().getSharedUID(new NamespaceUID(csmNamespace));
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> createDeclarationUID(T t) {
        assert (!(t instanceof CsmBuiltIn)) : "built-in have own UIDs";
        KeyBasedUID keyBasedUID = !UIDUtilities.namedDeclaration(t) ? UIDUtilities.handleUnnamedDeclaration(t) : (t instanceof CsmTypedef ? new TypedefUID((CsmTypedef)t) : (t instanceof CsmClassifier ? new ClassifierUID<T>(t) : new DeclarationUID<T>(t)));
        return UIDManager.instance().getSharedUID(keyBasedUID);
    }

    private static <T extends CsmOffsetableDeclaration> boolean namedDeclaration(T t) {
        assert (t != null);
        assert (t.getName() != null);
        return t.getName().length() > 0;
    }

    public static CsmUID<CsmMacro> createMacroUID(CsmMacro csmMacro) {
        return UIDManager.instance().getSharedUID(new MacroUID(csmMacro));
    }

    public static CsmUID<CsmInclude> createIncludeUID(CsmInclude csmInclude) {
        return UIDManager.instance().getSharedUID(new IncludeUID(csmInclude));
    }

    public static <T extends CsmNamedElement> CsmUID<CsmParameterList<T>> createParamListUID(CsmParameterList<T> csmParameterList) {
        return UIDManager.instance().getSharedUID(new ParamListUID<T>(csmParameterList));
    }

    public static CsmUID<CsmClass> createUnresolvedClassUID(String string, CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedClassUID(string, csmProject));
    }

    public static CsmUID<CsmFile> createUnresolvedFileUID(CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedFileUID(csmProject));
    }

    public static CsmUID<CsmNamespace> createUnresolvedNamespaceUID(CsmProject csmProject) {
        return UIDManager.instance().getSharedUID(new UnresolvedNamespaceUID(csmProject));
    }

    public static int getProjectID(CsmUID<CsmFile> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            return KeyUtilities.getProjectIndex(((KeyBasedUID)csmUID).getKey());
        }
        return -1;
    }

    public static boolean isProjectFile(CsmUID<CsmProject> csmUID, CsmUID<CsmFile> csmUID2) {
        if (csmUID instanceof KeyBasedUID && csmUID2 instanceof KeyBasedUID) {
            int n = KeyUtilities.getProjectIndex(((KeyBasedUID)csmUID).getKey());
            int n2 = KeyUtilities.getProjectIndex(((KeyBasedUID)csmUID2).getKey());
            if (n >= 0 && n2 >= 0) {
                return n == n2;
            }
        }
        return false;
    }

    public static boolean isSameProject(CsmUID<CsmFile> csmUID, CsmUID<CsmFile> csmUID2) {
        if (csmUID instanceof KeyBasedUID && csmUID2 instanceof KeyBasedUID) {
            int n = KeyUtilities.getProjectIndex(((KeyBasedUID)csmUID).getKey());
            int n2 = KeyUtilities.getProjectIndex(((KeyBasedUID)csmUID2).getKey());
            if (n >= 0 && n2 >= 0) {
                return n == n2;
            }
        }
        return false;
    }

    public static boolean isSameFile(CsmUID<CsmOffsetableDeclaration> csmUID, CsmUID<CsmOffsetableDeclaration> csmUID2) {
        if (csmUID instanceof KeyBasedUID && csmUID2 instanceof KeyBasedUID) {
            int n = KeyUtilities.getProjectFileIndex(((KeyBasedUID)csmUID).getKey());
            int n2 = KeyUtilities.getProjectFileIndex(((KeyBasedUID)csmUID2).getKey());
            if (n >= 0 && n2 >= 0) {
                return n == n2;
            }
        }
        return UIDUtilities.isSameFile((CsmOffsetableDeclaration)csmUID.getObject(), (CsmOffsetableDeclaration)csmUID2.getObject());
    }

    private static boolean isSameFile(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmOffsetableDeclaration csmOffsetableDeclaration2) {
        if (csmOffsetableDeclaration != null && csmOffsetableDeclaration2 != null) {
            CsmFile csmFile = csmOffsetableDeclaration.getContainingFile();
            CsmFile csmFile2 = csmOffsetableDeclaration2.getContainingFile();
            if (csmFile != null && csmFile2 != null) {
                return csmFile.equals(csmFile2);
            }
        }
        return false;
    }

    public static CsmDeclaration.Kind getKind(CsmUID<?> csmUID) {
        CsmObject csmObject;
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyKind(key);
        }
        if (UIDProviderIml.isSelfUID(csmUID) && CsmKindUtilities.isDeclaration((CsmObject)(csmObject = (CsmObject)csmUID.getObject()))) {
            return ((CsmDeclaration)csmObject).getKind();
        }
        return null;
    }

    public static CharSequence getFileName(CsmUID<CsmFile> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyName(key);
        }
        return null;
    }

    public static CharSequence getProjectName(CsmUID<CsmProject> csmUID) {
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyName(key);
        }
        return null;
    }

    public static CharSequence getName(CsmUID<?> csmUID) {
        Object object;
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyName(key);
        }
        if (UIDProviderIml.isSelfUID(csmUID) && CsmKindUtilities.isNamedElement((Object)(object = csmUID.getObject()))) {
            return ((CsmNamedElement)object).getName();
        }
        return null;
    }

    public static int getStartOffset(CsmUID<?> csmUID) {
        Object object;
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyStartOffset(key);
        }
        if (UIDProviderIml.isSelfUID(csmUID) && CsmKindUtilities.isOffsetable((Object)(object = csmUID.getObject()))) {
            return ((CsmOffsetable)object).getStartOffset();
        }
        return -1;
    }

    public static int getEndOffset(CsmUID<?> csmUID) {
        Object object;
        if (csmUID instanceof KeyBasedUID) {
            Key key = ((KeyBasedUID)csmUID).getKey();
            return KeyUtilities.getKeyEndOffset(key);
        }
        if (UIDProviderIml.isSelfUID(csmUID) && CsmKindUtilities.isOffsetable((Object)(object = csmUID.getObject()))) {
            return ((CsmOffsetable)object).getEndOffset();
        }
        return -1;
    }

    public static <T extends CsmOffsetable> int compareWithinFile(CsmUID<T> csmUID, CsmUID<T> csmUID2) {
        int n;
        int n2 = UIDUtilities.getStartOffset(csmUID);
        if (n2 != (n = UIDUtilities.getStartOffset(csmUID2))) {
            return n2 - n;
        }
        n2 = UIDUtilities.getEndOffset(csmUID);
        if (n2 != (n = UIDUtilities.getEndOffset(csmUID2))) {
            return n2 - n;
        }
        CharSequence charSequence = UIDUtilities.getName(csmUID);
        CharSequence charSequence2 = UIDUtilities.getName(csmUID2);
        if (charSequence instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)charSequence);
            return comparable.compareTo(charSequence2);
        }
        if (charSequence != null) {
            return charSequence2 == null ? 1 : 0;
        }
        return charSequence2 == null ? 0 : -1;
    }

    public static <T extends CsmOffsetableDeclaration> CsmUID<T> findExistingUIDInList(List<CsmUID<T>> list, int n, int n2, CharSequence charSequence) {
        CsmUID<T> csmUID = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            CsmUID<T> csmUID2 = list.get(i);
            int n3 = UIDUtilities.getStartOffset(csmUID2);
            if (n3 == n && n2 == UIDUtilities.getEndOffset(csmUID2) && charSequence.equals(UIDUtilities.getName(csmUID2))) {
                csmUID = csmUID2;
                break;
            }
            if (n3 < n) break;
        }
        return csmUID;
    }

    public static <T extends CsmOffsetable> void insertIntoSortedUIDList(CsmUID<T> csmUID, List<CsmUID<T>> list) {
        int n = UIDUtilities.getStartOffset(csmUID);
        boolean bl = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            CsmUID<T> csmUID2 = list.get(i);
            int n2 = UIDUtilities.compareWithinFile(csmUID2, csmUID);
            if (n2 <= 0) {
                if (n2 == 0) {
                    list.set(i, csmUID);
                } else {
                    list.add(i + 1, csmUID);
                }
                return;
            }
            if (UIDUtilities.getStartOffset(csmUID2) < n) break;
            bl = true;
        }
        if (!list.isEmpty() && bl) {
            list.add(0, csmUID);
        } else {
            list.add(csmUID);
        }
    }

    private static <T extends CsmOffsetableDeclaration> CsmUID<T> handleUnnamedDeclaration(T t) {
        if (TraceFlags.TRACE_UNNAMED_DECLARATIONS) {
            System.err.print("\n\ndeclaration with empty name '" + t.getUniqueName() + "'");
            new CsmTracer().dumpModel(t);
        }
        if (t instanceof CsmClassifier) {
            return new UnnamedClassifierUID<T>(t, UnnamedID.incrementAndGet());
        }
        return new UnnamedOffsetableDeclarationUID<T>(t, UnnamedID.incrementAndGet());
    }

    public static void disposeUnresolved(CsmUID<?> csmUID) {
        if (csmUID instanceof UnresolvedFileUID) {
            UnresolvedFileUID unresolvedFileUID = (UnresolvedFileUID)csmUID;
            unresolvedFileUID.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedFileUID
    extends UnresolvedUIDBase<CsmFile>
    implements Disposable {
        private ProjectBase prjRef = null;

        public UnresolvedFileUID(CsmProject csmProject) {
            super(csmProject);
            this.prjRef = (ProjectBase)csmProject;
        }

        public UnresolvedFileUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public CsmFile getObject() {
            return this.getProject().getUnresolvedFile();
        }

        @Override
        protected ProjectBase getProject() {
            ProjectBase projectBase = this.prjRef;
            if (projectBase == null) {
                projectBase = super.getProject();
            }
            return projectBase;
        }

        @Override
        public void dispose() {
            this.prjRef = this.getProject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedNamespaceUID
    extends UnresolvedUIDBase<CsmNamespace> {
        public UnresolvedNamespaceUID(CsmProject csmProject) {
            super(csmProject);
        }

        public UnresolvedNamespaceUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public CsmNamespace getObject() {
            return this.getProject().getUnresolvedNamespace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnresolvedClassUID
    extends UnresolvedUIDBase<CsmClass> {
        private CharSequence name;

        public UnresolvedClassUID(String string, CsmProject csmProject) {
            super(csmProject);
            this.name = NameCache.getManager().getString((CharSequence)string);
        }

        @Override
        public CsmClass getObject() {
            return this.getProject().getDummyForUnresolved(this.name);
        }

        public UnresolvedClassUID(DataInput dataInput) throws IOException {
            super(dataInput);
            this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            super.write(dataOutput);
            PersistentUtils.writeUTF(this.name, dataOutput);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            UnresolvedClassUID unresolvedClassUID = (UnresolvedClassUID)object;
            return !(this.name == null ? unresolvedClassUID.name != null : !this.name.equals(unresolvedClassUID.name));
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 53 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class UnresolvedUIDBase<T>
    implements CsmUID<T>,
    SelfPersistent {
        private CsmUID<CsmProject> projectUID;

        public UnresolvedUIDBase(CsmProject csmProject) {
            assert (csmProject != null) : "how to create UID without project?";
            this.projectUID = UIDs.get((Object)csmProject);
        }

        protected ProjectBase getProject() {
            return (ProjectBase)this.projectUID.getObject();
        }

        UnresolvedUIDBase(DataInput dataInput) throws IOException {
            this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        }

        public abstract T getObject();

        public void write(DataOutput dataOutput) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, dataOutput);
        }

        protected String getToStringPrefix() {
            return "<UNRESOLVED UID>";
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            UnresolvedUIDBase unresolvedUIDBase = (UnresolvedUIDBase)object;
            return this.projectUID == unresolvedUIDBase.projectUID || this.projectUID != null && this.projectUID.equals(unresolvedUIDBase.projectUID);
        }

        public int hashCode() {
            int n = 3;
            n = 43 * n + (this.projectUID != null ? this.projectUID.hashCode() : 0);
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnnamedOffsetableDeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedOffsetableDeclarationUID(T t, int n) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)t, n));
        }

        UnnamedOffsetableDeclarationUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED OFFS-DECL UID>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnnamedClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public UnnamedClassifierUID(T t, int n) {
            super(KeyUtilities.createUnnamedOffsetableDeclarationKey((OffsetableDeclarationBase)t, n));
        }

        UnnamedClassifierUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "<UNNAMED CLASSIFIER UID>";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClassifierUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBaseCached<T> {
        public ClassifierUID(T t) {
            super(t);
        }

        ClassifierUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "ClassifierUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DeclarationUID<T extends CsmOffsetableDeclaration>
    extends OffsetableDeclarationUIDBase<T> {
        public DeclarationUID(T t) {
            super(t);
        }

        DeclarationUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "DeclarationUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParamListUID<T extends CsmNamedElement>
    extends KeyBasedUID<CsmParameterList<T>> {
        public ParamListUID(CsmParameterList<T> csmParameterList) {
            super(KeyUtilities.createParamListKey(csmParameterList));
        }

        ParamListUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IncludeUID
    extends KeyBasedUID<CsmInclude> {
        public IncludeUID(CsmInclude csmInclude) {
            super(KeyUtilities.createIncludeKey(csmInclude));
        }

        IncludeUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MacroUID
    extends KeyBasedUID<CsmMacro> {
        public MacroUID(CsmMacro csmMacro) {
            super(KeyUtilities.createMacroKey(csmMacro));
        }

        MacroUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TypedefUID
    extends OffsetableDeclarationUIDBase<CsmTypedef> {
        public TypedefUID(CsmTypedef csmTypedef) {
            super(csmTypedef);
        }

        TypedefUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        protected String getToStringPrefix() {
            return "TypedefUID";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OffsetableDeclarationUIDBaseCached<T extends CsmOffsetableDeclaration>
    extends CachedUID<T> {
        public OffsetableDeclarationUIDBaseCached(T t) {
            this(KeyUtilities.createOffsetableDeclarationKey((OffsetableDeclarationBase)t));
        }

        protected OffsetableDeclarationUIDBaseCached(Key key) {
            super(key);
        }

        OffsetableDeclarationUIDBaseCached(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public String toString() {
            String string = this.getToStringPrefix() + ":" + super.toString();
            return string;
        }

        protected String getToStringPrefix() {
            return "UID for OffsDecl";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OffsetableDeclarationUIDBase<T extends CsmOffsetableDeclaration>
    extends KeyBasedUID<T> {
        public OffsetableDeclarationUIDBase(T t) {
            this(KeyUtilities.createOffsetableDeclarationKey((OffsetableDeclarationBase)t));
        }

        protected OffsetableDeclarationUIDBase(Key key) {
            super(key);
        }

        OffsetableDeclarationUIDBase(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public String toString() {
            String string = this.getToStringPrefix() + ":" + super.toString();
            return string;
        }

        protected String getToStringPrefix() {
            return "UID for OffsDecl";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FileUID
    extends CachedUID<CsmFile> {
        public FileUID(FileImpl fileImpl) {
            super(KeyUtilities.createFileKey(fileImpl));
        }

        FileUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NamespaceUID
    extends CachedUID<CsmNamespace> {
        public NamespaceUID(CsmNamespace csmNamespace) {
            super(KeyUtilities.createNamespaceKey(csmNamespace));
        }

        NamespaceUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ProjectUID
    extends CachedUID<CsmProject> {
        public ProjectUID(ProjectBase projectBase) {
            super(KeyUtilities.createProjectKey(projectBase));
        }

        ProjectUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedUID<T>
    extends KeyBasedUID<T>
    implements Disposable {
        private WeakReference<T> weakT = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;

        protected CachedUID(Key key) {
            super(key);
        }

        CachedUID(DataInput dataInput) throws IOException {
            super(dataInput);
        }

        @Override
        public T getObject() {
            Object t = null;
            WeakReference<T> weakReference = null;
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && (weakReference = this.weakT) != null && (t = (Object)weakReference.get()) != null) {
                return t;
            }
            t = RepositoryUtils.get(this);
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && t != null && weakReference != null) {
                this.weakT = new WeakReference<Object>(t);
            }
            return t;
        }

        @Override
        public void dispose() {
            this.weakT = null;
        }
    }
}

