/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.DefaultArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.netbeans.modules.maven.embedder.NbWagonManager;

public class NbArtifactResolver
extends DefaultArtifactResolver {
    private ResolutionListener listener;
    protected Field wagonMan;

    public NbArtifactResolver() {
        try {
            this.wagonMan = DefaultArtifactResolver.class.getDeclaredField("wagonManager");
            this.wagonMan.setAccessible(true);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
    }

    public void resolve(Artifact artifact, List list, ArtifactRepository artifactRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (NbArtifactResolver.isParentPomArtifact(artifact)) {
            try {
                this.letArtifactGo(artifact);
                super.resolve(artifact, list, artifactRepository);
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                if (artifactResolutionException.getCause() instanceof IOException) {
                    System.out.println("exc=" + artifactResolutionException.getCause().getMessage());
                    return;
                }
                throw artifactResolutionException;
            }
            finally {
                this.cleanLetGone(artifact);
            }
        } else {
            super.resolve(artifact, list, artifactRepository);
        }
    }

    public void resolveAlways(Artifact artifact, List list, ArtifactRepository artifactRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (NbArtifactResolver.isParentPomArtifact(artifact)) {
            try {
                this.letArtifactGo(artifact);
                super.resolveAlways(artifact, list, artifactRepository);
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                if (artifactResolutionException.getCause() instanceof IOException) {
                    System.out.println("exc=" + artifactResolutionException.getCause().getMessage());
                    return;
                }
                throw artifactResolutionException;
            }
            finally {
                this.cleanLetGone(artifact);
            }
        } else {
            super.resolveAlways(artifact, list, artifactRepository);
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set set, Artifact artifact, Map map, ArtifactRepository artifactRepository, List list, ArtifactMetadataSource artifactMetadataSource, ArtifactFilter artifactFilter, List list2) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<ResolutionListener> arrayList = new ArrayList<ResolutionListener>();
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if (this.listener != null) {
            arrayList.add(this.listener);
        }
        return super.resolveTransitively(set, artifact, map, artifactRepository, list, artifactMetadataSource, artifactFilter, arrayList);
    }

    private void cleanLetGone(Artifact artifact) {
        if (this.wagonMan != null) {
            try {
                Object object = this.wagonMan.get(this);
                if (object instanceof NbWagonManager) {
                    NbWagonManager nbWagonManager = (NbWagonManager)object;
                    nbWagonManager.cleanLetGone(artifact);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private void letArtifactGo(Artifact artifact) {
        if (this.wagonMan != null) {
            try {
                Object object = this.wagonMan.get(this);
                if (object instanceof NbWagonManager) {
                    NbWagonManager nbWagonManager = (NbWagonManager)object;
                    nbWagonManager.letGoThrough(artifact);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    static boolean isParentPomArtifact(Artifact artifact) {
        return artifact.getScope() == null && "pom".equals(artifact.getType());
    }
}

