/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.NameCache;
import org.netbeans.modules.cnd.classview.PersistentKey;
import org.netbeans.modules.cnd.classview.SmartChangeEvent;
import org.netbeans.modules.cnd.classview.UpdatebleHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildrenUpdater {
    private static final boolean traceEvents = Boolean.getBoolean("cnd.classview.key-events");
    private Map<CsmProject, Map<PersistentKey, UpdatebleHost>> map = new HashMap<CsmProject, Map<PersistentKey, UpdatebleHost>>();

    public Object getLock(CsmProject csmProject) {
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map == null) {
            return this;
        }
        return map;
    }

    public void register(CsmProject csmProject, PersistentKey persistentKey, UpdatebleHost updatebleHost) {
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map == null) {
            map = new HashMap<PersistentKey, UpdatebleHost>();
            this.map.put(csmProject, map);
        }
        map.put(persistentKey, updatebleHost);
        if (traceEvents) {
            System.out.println("Register Children Updater on key " + persistentKey.toString());
        }
    }

    public void unregister() {
        if (traceEvents) {
            System.out.println("Clean Children Updater");
        }
        this.map.clear();
        NameCache.getManager().dispose();
    }

    public void unregister(CsmProject csmProject) {
        if (traceEvents) {
            System.out.println("Clean Children Updater on project " + csmProject.getName());
        }
        this.map.remove(csmProject);
    }

    public void unregister(CsmProject csmProject, PersistentKey persistentKey) {
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map != null) {
            if (traceEvents) {
                System.out.println("Clean Children Updater on key " + persistentKey.toString());
            }
            map.remove(persistentKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SmartChangeEvent smartChangeEvent) {
        if (this.map.size() == 0) {
            return;
        }
        for (Map.Entry<CsmProject, SmartChangeEvent.Storage> entry : smartChangeEvent.getChangedProjects().entrySet()) {
            CsmProject csmProject = entry.getKey();
            try {
                if (!this.map.containsKey(csmProject) || !csmProject.isValid()) continue;
                Object object = this.getLock(csmProject);
                synchronized (object) {
                    SmartChangeEvent.Storage storage = entry.getValue();
                    this.update(csmProject, storage);
                }
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void update(CsmProject csmProject, SmartChangeEvent.Storage storage) {
        Object object;
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (CsmNamespace object42 : storage.getNewNamespaces()) {
            object2 = this.findHost(csmProject, object42);
            if (object2 == null || !object2.newNamespsce(object42)) continue;
            hashSet.add(object2);
        }
        for (CsmNamespace csmNamespace : storage.getRemovedNamespaces()) {
            object2 = this.findHost(csmProject, csmNamespace);
            if (object2 == null || !object2.removeNamespsce(csmNamespace)) continue;
            hashSet.add(object2);
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : storage.getNewDeclarations()) {
            for (UpdatebleHost updatebleHost : this.findHost(csmProject, csmOffsetableDeclaration)) {
                if (!updatebleHost.newDeclaration(csmOffsetableDeclaration)) continue;
                hashSet.add(updatebleHost);
            }
        }
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : storage.getRemovedDeclarations()) {
            for (UpdatebleHost updatebleHost : this.findHost(csmProject, csmOffsetableDeclaration)) {
                if (!updatebleHost.removeDeclaration(csmOffsetableDeclaration)) continue;
                hashSet.add(updatebleHost);
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> arrayList2 = new ArrayList<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>>(this.packChangedDeclarations(storage.getChangedDeclarations()));
        for (Map.Entry entry : arrayList2) {
            for (UpdatebleHost updatebleHost : this.findHost(csmProject, (CsmOffsetableDeclaration)entry.getKey())) {
                if (!updatebleHost.changeDeclaration((CsmOffsetableDeclaration)entry.getKey(), (CsmOffsetableDeclaration)entry.getValue())) continue;
                hashSet.add(updatebleHost);
            }
            object = this.findNode(csmProject, (CsmOffsetableDeclaration)entry.getValue());
            if (object == null || !object.reset((CsmOffsetableDeclaration)entry.getValue(), arrayList)) continue;
            hashSet.add(object);
        }
        while (arrayList.size() > 0) {
            object2 = new ArrayList(arrayList);
            arrayList.clear();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                UpdatebleHost updatebleHost;
                object = (CsmOffsetableDeclaration)iterator.next();
                updatebleHost = this.findNode(csmProject, (CsmOffsetableDeclaration)object);
                if (updatebleHost == null || !updatebleHost.reset((CsmOffsetableDeclaration)object, arrayList)) continue;
                hashSet.add(updatebleHost);
            }
        }
        if (hashSet.size() > 0) {
            for (UpdatebleHost updatebleHost : hashSet) {
                updatebleHost.flush();
            }
        }
    }

    private Collection<Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> packChangedDeclarations(Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> map) {
        HashMap<PersistentKey, Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>> hashMap = new HashMap<PersistentKey, Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration>>();
        for (Map.Entry<CsmOffsetableDeclaration, CsmOffsetableDeclaration> entry : map.entrySet()) {
            hashMap.put(PersistentKey.createKey(entry.getKey()), entry);
        }
        return hashMap.values();
    }

    private UpdatebleHost findHost(CsmProject csmProject, CsmNamespace csmNamespace) {
        if (!csmProject.isValid()) {
            return null;
        }
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map == null) {
            return null;
        }
        CsmNamespace csmNamespace2 = csmNamespace.getParent();
        if (csmNamespace2 != null) {
            return map.get(PersistentKey.createKey(csmNamespace2));
        }
        return null;
    }

    private UpdatebleHost findNode(CsmProject csmProject, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFile csmFile;
        CsmCompoundClassifier csmCompoundClassifier;
        CsmClassifier csmClassifier;
        CsmTypedef csmTypedef;
        if (!csmProject.isValid()) {
            return null;
        }
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map == null) {
            return null;
        }
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            CsmFile csmFile2;
            CsmClass csmClass = (CsmClass)csmOffsetableDeclaration;
            if (csmClass.isValid() && (csmFile2 = csmClass.getContainingFile()) != null && csmFile2.isValid()) {
                return map.get(PersistentKey.createKey(csmClass));
            }
        } else if (CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) {
            CsmFile csmFile3;
            CsmEnum csmEnum = (CsmEnum)csmOffsetableDeclaration;
            if (csmEnum.isValid() && (csmFile3 = csmEnum.getContainingFile()) != null && csmFile3.isValid()) {
                return map.get(PersistentKey.createKey(csmEnum));
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)csmOffsetableDeclaration) && (csmTypedef = (CsmTypedef)csmOffsetableDeclaration).isTypeUnnamed() && (csmClassifier = csmTypedef.getType().getClassifier()) instanceof CsmCompoundClassifier && (csmCompoundClassifier = (CsmCompoundClassifier)csmClassifier).isValid() && csmCompoundClassifier.getName().length() == 0 && (csmFile = csmCompoundClassifier.getContainingFile()) != null && csmFile.isValid()) {
            return map.get(PersistentKey.createKey(csmTypedef));
        }
        return null;
    }

    private List<UpdatebleHost> findHost(CsmProject csmProject, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CsmClass csmClass;
        CsmScope csmScope;
        ArrayList<UpdatebleHost> arrayList = new ArrayList<UpdatebleHost>();
        if (!csmProject.isValid()) {
            return arrayList;
        }
        Map<PersistentKey, UpdatebleHost> map = this.map.get(csmProject);
        if (map == null) {
            return arrayList;
        }
        if (CsmKindUtilities.isFriendMethod((CsmObject)csmOffsetableDeclaration) && (csmScope = ((CsmFriendFunction)csmOffsetableDeclaration).getContainingClass()) != null && csmScope.isValid() && (csmClass = csmScope.getContainingFile()) != null && csmClass.isValid() && (object = map.get(PersistentKey.createKey(csmScope))) != null) {
            arrayList.add((UpdatebleHost)object);
        }
        if (CsmKindUtilities.isClass((CsmObject)(csmScope = csmOffsetableDeclaration.getScope()))) {
            UpdatebleHost updatebleHost;
            csmClass = (CsmClass)csmScope;
            if (csmClass.isValid() && (object = csmClass.getContainingFile()) != null && object.isValid() && (updatebleHost = map.get(PersistentKey.createKey(csmClass))) != null) {
                arrayList.add(updatebleHost);
            }
        } else if (CsmKindUtilities.isEnum((CsmObject)csmScope)) {
            UpdatebleHost updatebleHost;
            csmClass = (CsmEnum)csmScope;
            if (csmClass.isValid() && (object = csmClass.getContainingFile()) != null && object.isValid() && (updatebleHost = map.get(PersistentKey.createKey(csmClass))) != null) {
                arrayList.add(updatebleHost);
            }
        } else if (CsmKindUtilities.isNamespace((Object)csmScope)) {
            csmClass = (CsmNamespace)csmScope;
            object = map.get(PersistentKey.createKey(csmClass));
            if (object != null) {
                arrayList.add((UpdatebleHost)object);
            }
        } else if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmScope)) {
            UpdatebleHost updatebleHost;
            csmClass = (CsmNamespaceDefinition)csmScope;
            object = csmClass.getContainingFile();
            if (object != null && object.isValid() && (updatebleHost = map.get(PersistentKey.createKey(csmClass.getNamespace()))) != null) {
                arrayList.add(updatebleHost);
            }
        } else if (CsmKindUtilities.isFile((CsmObject)csmScope) && (csmClass = (CsmFile)csmScope).isValid() && (object = map.get(PersistentKey.createKey(csmProject.getGlobalNamespace()))) != null) {
            arrayList.add((UpdatebleHost)object);
        }
        return arrayList;
    }
}

