/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.spi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public class GsfUtilities {
    private GsfUtilities() {
    }

    public static int getLineIndent(BaseDocument baseDocument, int n) {
        try {
            return IndentUtils.lineIndent((Document)baseDocument, (int)Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static void setLineIndentation(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        char c;
        int n3;
        int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n5 = 0;
        int n6 = -1;
        CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument);
        for (n3 = n4; n3 < charSequence.length() && (c = charSequence.charAt(n3)) != '\n'; ++n3) {
            if (c == '\t') {
                if (n6 == -1) {
                    n6 = IndentUtils.tabSize((Document)baseDocument);
                }
                n5 = (n5 + n6) / n6 * n6;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++n5;
        }
        String string = IndentUtils.createIndentString((Document)baseDocument, (int)n2);
        int n7 = n4;
        for (int i = 0; i < string.length() && n4 + i < n3; ++i) {
            if (string.charAt(i) == charSequence.charAt(n4 + i)) continue;
            n7 = n4 + i;
            string = string.substring(i);
            break;
        }
        if (n7 < n3) {
            baseDocument.remove(n7, n3 - n7);
        }
        if (string.length() > 0) {
            baseDocument.insertString(n7, string, null);
        }
    }

    public static JTextComponent getOpenPane() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        return jTextComponent;
    }

    public static JTextComponent getPaneFor(FileObject fileObject) {
        JTextComponent jTextComponent = GsfUtilities.getOpenPane();
        if (jTextComponent != null && GsfUtilities.findFileObject(jTextComponent) == fileObject) {
            return jTextComponent;
        }
        for (JTextComponent jTextComponent2 : EditorRegistry.componentList()) {
            if (GsfUtilities.findFileObject(jTextComponent2) != fileObject) continue;
            return jTextComponent2;
        }
        return null;
    }

    public static BaseDocument getDocument(FileObject fileObject, boolean bl) {
        return GsfUtilities.getDocument(fileObject, bl, false);
    }

    public static BaseDocument getDocument(FileObject fileObject, boolean bl, boolean bl2) {
        if (bl2 && fileObject.getSize() > 0x100000L) {
            return null;
        }
        try {
            DataObject dataObject;
            EditorCookie editorCookie;
            if (fileObject.isValid() && (editorCookie = (EditorCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(EditorCookie.class)) != null) {
                return (BaseDocument)(bl ? editorCookie.openDocument() : editorCookie.getDocument());
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    @Deprecated
    public static BaseDocument getBaseDocument(FileObject fileObject, boolean bl) {
        return GsfUtilities.getDocument(fileObject, bl);
    }

    public static FileObject findFileObject(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }

    public static FileObject findFileObject(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        return GsfUtilities.findFileObject(document);
    }

    public static boolean open(final FileObject fileObject, final int n, final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GsfUtilities.doOpen(fileObject, n, string);
                }
            });
            return true;
        }
        return GsfUtilities.doOpen(fileObject, n, string);
    }

    private static boolean doOpen(FileObject fileObject, int n, String string) {
        try {
            int n2;
            Object object;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (n == -1 && editorCookie.getDocument() != null && string == null) {
                editorCookie.open();
                return true;
            }
            if (editorCookie != null && string != null && n == -1) {
                object = editorCookie.openDocument();
                try {
                    String string2 = object.getText(0, object.getLength());
                    n2 = string.indexOf(94);
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                    } else {
                        n2 = 0;
                    }
                    n = string2.indexOf(string);
                    if (n != -1) {
                        n += n2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n3 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                n2 = NbDocument.findLineOffset((StyledDocument)object, (int)n3);
                int n4 = n - n2;
                if (n3 != -1 && (line = lineCookie.getLineSet().getCurrent(n3)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n4);
                    return true;
                }
            }
            if ((object = (OpenCookie)dataObject.getCookie(OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return false;
    }

    public static void extractZip(FileObject fileObject, FileObject fileObject2) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        GsfUtilities.extractZip(fileObject2, new BufferedInputStream(new FileInputStream(file)));
    }

    private static void extractZip(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                GsfUtilities.extractZipImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractZipImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (zipEntry.isDirectory()) {
                FileUtil.createFolder((FileObject)fileObject, (String)string);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
            FileLock fileLock = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                try {
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    public static boolean isCodeTemplateEditing(Document document) {
        String string = "processing-code-template";
        String string2 = "code-template-insert-handler";
        return document.getProperty(string) == Boolean.TRUE || document.getProperty(string2) != null;
    }

    public static boolean isRowWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n'; ++n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean isRowEmpty(String string, int n) throws BadLocationException {
        try {
            char c;
            if (n < string.length() && (c = string.charAt(n)) != '\n' && (c != '\r' || n != string.length() - 1 && string.charAt(n + 1) != '\n')) {
                return false;
            }
            return n == 0 || string.charAt(n - 1) == '\n';
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowLastNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n' && (c != '\r' || n2 != string.length() - 1 && string.charAt(n2 + 1) != '\n'); ++n2) {
            }
            --n2;
            while (n2 >= 0) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowFirstNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            if (n2 < string.length()) {
                for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                }
                ++n2;
            }
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static int getRowStart(String string, int n) throws BadLocationException {
        try {
            for (int i = n - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (Exception exception) {
            BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
            badLocationException.initCause(exception);
            throw badLocationException;
        }
    }

    public static boolean endsWith(StringBuilder stringBuilder, String string) {
        int n = string.length();
        if (stringBuilder.length() < n) {
            return false;
        }
        int n2 = stringBuilder.length() - n;
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.charAt(n2) != string.charAt(i)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String truncate(String string, int n) {
        assert (n > 3);
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n - 3) + "...";
    }
}

