/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutCell
extends JPanel
implements Comparable,
Popupable {
    private Popup popup;
    private final SpecialkeyPanel specialkeyList;
    PopupFactory factory = PopupFactory.getSharedInstance();
    private JButton changeButton;
    private JTextField scField;

    public ShortcutCell() {
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.scField);
        this.changeButton.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ShortcutCell.this.hidePopup();
            }
        });
        this.changeButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    JTable jTable = (JTable)ShortcutCell.this.scField.getParent().getParent();
                    int n = jTable.getEditingRow();
                    jTable.editCellAt(n, 1);
                    jTable.setRowSelectionInterval(n, n);
                    ShortcutCell.this.scField.requestFocus();
                }
            }
        });
        this.scField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ShortcutCell.this.changeButton.setText("");
                ShortcutCell.this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more.png")));
            }

            public void focusLost(FocusEvent focusEvent) {
                ShortcutCell.this.changeButton.setIcon(null);
                ShortcutCell.this.changeButton.setText("...");
            }
        });
    }

    public ShortcutCell(String string) {
        this();
        this.setText(string);
    }

    public void setText(String string) {
        this.scField.setText(string);
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    public String toString() {
        return this.scField.getText();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        int n = this.changeButton.getPreferredSize().width;
        this.scField.setPreferredSize(new Dimension(dimension.width - n, dimension.height));
        this.changeButton.setPreferredSize(new Dimension(n, dimension.height));
    }

    void setBgColor(Color color) {
        this.scField.setBackground(color);
        this.changeButton.setBackground(new Color(204, 204, 204));
    }

    void setFgCOlor(Color color) {
        this.scField.setForeground(color);
    }

    public JButton getButton() {
        return this.changeButton;
    }

    public JTextField getTextField() {
        return this.scField;
    }

    private void initComponents() {
        this.scField = new ShortcutTextField();
        this.changeButton = new JButton();
        this.setBackground(new Color(204, 204, 204));
        this.setPreferredSize(new Dimension(134, 15));
        this.scField.setText(NbBundle.getMessage(ShortcutCell.class, (String)"ShortcutCell.scField.text"));
        this.scField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.scField.setPreferredSize(new Dimension(0, 15));
        this.changeButton.setBackground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage(ShortcutCell.class, (String)"ShortcutCell.changeButton.text"));
        this.changeButton.setMaximumSize(new Dimension(20, 15));
        this.changeButton.setMinimumSize(new Dimension(20, 15));
        this.changeButton.setPreferredSize(new Dimension(20, 15));
        this.changeButton.setRolloverEnabled(true);
        this.changeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutCell.this.changeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((Component)this.scField, -1, 125, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.changeButton, -2, 15, -2)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.scField, -2, 15, -2).add((Component)this.changeButton, -2, 15, -2));
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Point point = new Point(jComponent.getX(), jComponent.getY());
        SwingUtilities.convertPointToScreen(point, this);
        if (this.popup == null) {
            this.popup = Utilities.isUnix() ? PopupFactory.getSharedInstance().getPopup(null, this.specialkeyList, point.x, point.y) : this.factory.getPopup(this, this.specialkeyList, point.x, point.y);
        }
        this.popup.show();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public Popup getPopup() {
        return this.popup;
    }

    void setButtontext(String string) {
        this.changeButton.setText(string);
    }
}

