/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class XMLCompletionProvider
implements CompletionProvider {
    private static final boolean ENABLED = true;

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        SyntaxSupport syntaxSupport = Utilities.getDocument((JTextComponent)jTextComponent).getSyntaxSupport();
        if (syntaxSupport == null || !(syntaxSupport instanceof XMLSyntaxSupport)) {
            return 0;
        }
        int n = ((XMLSyntaxSupport)syntaxSupport).checkCompletion(jTextComponent, string, false);
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (n == 1 || n == 9) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument baseDocument, int n) {
        XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)baseDocument.getSyntaxSupport().get(XMLSyntaxSupport.class);
        try {
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(n <= 0 ? 0 : n - 1, n);
            if (tokenItem != null && tokenItem.getTokenID() == XMLDefaultTokenContext.TEXT && !tokenItem.getImage().startsWith("<") && !tokenItem.getImage().startsWith("&")) {
                XMLCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
    }

    static class Query
    extends AsyncCompletionQuery {
        private static final XMLCompletionQuery QUERY = new XMLCompletionQuery();
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)this.component);
            if (xMLSyntaxSupport == null) {
                completionResultSet.finish();
                return;
            }
            List<CompletionItem> list = QUERY.query(this.component, n, (SyntaxSupport)xMLSyntaxSupport);
            if (list != null) {
                completionResultSet.addAllItems(list);
            }
            completionResultSet.finish();
        }
    }
}

