/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.spi.project.ActionProvider;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public abstract class RubyBaseActionProvider
implements ActionProvider,
ScriptDescProvider {
    private static final Logger LOGGER = Logger.getLogger(RubyBaseActionProvider.class.getName());
    public static final String COMMAND_RDOC = "rdoc";
    public static final String COMMAND_AUTOTEST = "autotest";
    public static final String COMMAND_AUTOSPEC = "autospec";
    public static final String COMMAND_RSPEC = "rspec";
    public static final String COMMAND_RSPEC_ALL = "rspec-all";
    protected static final String TEST_TASK_NAME = "test";
    protected static final String RSPEC_TASK_NAME = "spec";
    private final RubyBaseProject project;
    private final UpdateHelper updateHelper;

    protected RubyBaseActionProvider(RubyBaseProject rubyBaseProject, UpdateHelper updateHelper) {
        this.project = rubyBaseProject;
        this.updateHelper = updateHelper;
    }

    protected abstract FileObject[] getSourceRoots();

    protected abstract FileObject[] getTestSourceRoots();

    protected abstract String[] getMimeTypes();

    protected RubyPlatform getPlatform() {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        if (rubyPlatform == null) {
            rubyPlatform = RubyPlatformManager.getDefaultPlatform();
        }
        return rubyPlatform;
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected void saveFile(FileObject fileObject) {
        try {
            SaveCookie saveCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getLocalizedMessage(), dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    protected void runRubyScript(FileObject fileObject, String string, String string2, Lookup lookup, boolean bl, LineConvertor ... lineConvertorArray) {
        if (!this.getPlatform().showWarningIfInvalid()) {
            return;
        }
        RubyExecutionDescriptor rubyExecutionDescriptor = this.getScriptDescriptor(null, fileObject, string, string2, lookup, bl, lineConvertorArray);
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor, this.getSourceEncoding());
        if (rubyProcessCreator.isAbleToCreateProcess()) {
            ExecutionService executionService = ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)rubyExecutionDescriptor.toExecutionDescriptor(), (String)string2);
            executionService.run();
        }
    }

    protected String getSourceEncoding() {
        return this.project.evaluator().getProperty("source.encoding");
    }

    protected FileObject[] findSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.getSourceRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            for (String string : this.getMimeTypes()) {
                FileObject[] fileObjectArray2 = RubyBaseActionProvider.findSelectedFiles(lookup, fileObjectArray[i], string, true);
                if (fileObjectArray2 == null) continue;
                return fileObjectArray2;
            }
        }
        return null;
    }

    protected FileObject[] findTestSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.getTestSourceRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = RubyBaseActionProvider.findSelectedFiles(lookup, fileObjectArray[i], "text/x-ruby", true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    protected FileObject getCurrentFile(Lookup lookup) {
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray == null) {
            fileObjectArray = this.findTestSources(lookup);
        }
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!fileObject.getMIMEType().equals("text/x-ruby")) continue;
                return fileObject;
            }
            return null;
        }
        return fileObjectArray[0];
    }

    public static FileObject[] findSelectedFiles(Lookup lookup, FileObject fileObject, String string, boolean bl) {
        if (fileObject != null && !fileObject.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject);
        }
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            boolean bl2;
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = bl2 = FileUtil.toFile((FileObject)fileObject2) != null;
            if (fileObject != null) {
                bl2 &= FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || fileObject == fileObject2;
            }
            if (string != null) {
                bl2 &= fileObject2.getMIMEType().equals(string);
            }
            if (bl2) {
                linkedHashSet.add(fileObject2);
                continue;
            }
            if (!bl) continue;
            return null;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return linkedHashSet.toArray(new FileObject[linkedHashSet.size()]);
    }

    protected String[] getApplicationArguments() {
        String string = this.project.evaluator().getProperty("application.args");
        return string == null || string.trim().length() == 0 ? null : Utilities.parseParameters((String)string);
    }
}

