/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.ui.JavaSymbolDescriptor;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaSymbolProvider
implements SymbolProvider {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String UNKNOWN = "<unknown>";
    private volatile boolean canceled;

    public String name() {
        return "java symbols";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JavaTypeProvider.class, (String)"MSG_JavaSymbols");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeSymbolNames(SymbolProvider.Context context, final SymbolProvider.Result result) {
        try {
            boolean bl;
            ClassIndex.NameKind nameKind;
            SearchType searchType = context.getSearchType();
            String string = context.getText();
            switch (searchType) {
                case PREFIX: {
                    nameKind = ClassIndex.NameKind.PREFIX;
                    bl = true;
                    break;
                }
                case REGEXP: {
                    nameKind = ClassIndex.NameKind.REGEXP;
                    string = JavaSymbolProvider.removeNonJavaChars(string);
                    string = string.replace("*", ".*").replace('?', '.') + ".*";
                    bl = true;
                    break;
                }
                case CAMEL_CASE: {
                    nameKind = ClassIndex.NameKind.CAMEL_CASE;
                    bl = true;
                    break;
                }
                case EXACT_NAME: {
                    nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                    bl = true;
                    break;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                    bl = false;
                    break;
                }
                case CASE_INSENSITIVE_EXACT_NAME: {
                    nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                    bl = false;
                    break;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                    string = JavaSymbolProvider.removeNonJavaChars(string);
                    string = string.replace("*", ".*").replace('?', '.') + ".*";
                    bl = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            String string2 = string;
            ClassIndex.NameKind nameKind2 = nameKind;
            final boolean bl2 = bl;
            try {
                ClassIndexManager classIndexManager = ClassIndexManager.getDefault();
                HashSet hashSet = new HashSet();
                hashSet.addAll(PathRegistry.getDefault().getSources());
                hashSet.addAll(PathRegistry.getDefault().getLibraries());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    URL uRL = (URL)iterator.next();
                    if (this.canceled) {
                        return;
                    }
                    final FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject == null) continue;
                    final Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    ClassIndexImpl classIndexImpl = classIndexManager.getUsagesQuery(fileObject.getURL());
                    if (classIndexImpl == null) continue;
                    final HashMap hashMap = new HashMap();
                    classIndexImpl.getDeclaredElements(string2, nameKind2, ResultConvertor.elementHandleConvertor(), hashMap);
                    if (hashMap.isEmpty()) continue;
                    ClasspathInfo classpathInfo = ClasspathInfoAccessor.getINSTANCE().create(fileObject, null, true, true, false);
                    JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) {
                            for (Map.Entry entry : hashMap.entrySet()) {
                                ElementHandle elementHandle = (ElementHandle)entry.getKey();
                                TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                                Set set = (Set)entry.getValue();
                                if (typeElement == null) continue;
                                if (set.contains(this.getSimpleName(typeElement))) {
                                    result.addResult((SymbolDescriptor)new JavaSymbolDescriptor(typeElement.getSimpleName().toString(), typeElement.getKind(), typeElement.getModifiers(), (ElementHandle<TypeElement>)elementHandle, ElementHandle.create((Element)typeElement), project, fileObject));
                                }
                                for (Element element : typeElement.getEnclosedElements()) {
                                    if (!set.contains(this.getSimpleName(element))) continue;
                                    result.addResult((SymbolDescriptor)new JavaSymbolDescriptor(JavaSymbolProvider.getDisplayName(element), element.getKind(), element.getModifiers(), (ElementHandle<TypeElement>)elementHandle, ElementHandle.create((Element)element), project, fileObject));
                                }
                            }
                        }

                        private String getSimpleName(Element element) {
                            String string = element.getSimpleName().toString();
                            if (!bl2) {
                                string = string.toLowerCase();
                            }
                            return string;
                        }
                    }, true);
                }
                return;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            catch (InterruptedException interruptedException) {
                this.cleanup();
                return;
            }
        }
        finally {
            this.cleanup();
        }
    }

    private static String getDisplayName(Element element) {
        assert (element != null);
        if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(element.getSimpleName());
            stringBuilder.append('(');
            ExecutableElement executableElement = (ExecutableElement)element;
            List<? extends VariableElement> list = executableElement.getParameters();
            Iterator<? extends VariableElement> iterator = list.iterator();
            while (iterator.hasNext()) {
                VariableElement variableElement = iterator.next();
                TypeMirror typeMirror = variableElement.asType();
                stringBuilder.append(JavaSymbolProvider.getTypeName(typeMirror, false, true));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        return element.getSimpleName().toString();
    }

    private static CharSequence getTypeName(TypeMirror typeMirror, boolean bl, boolean bl2) {
        if (typeMirror == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(bl2).visit(typeMirror, bl);
    }

    private static String removeNonJavaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void cancel() {
        this.canceled = true;
    }

    public void cleanup() {
        this.canceled = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;
        private boolean insideCapturedWildcard = false;

        private TypeNameVisitor(boolean bl) {
            super(new StringBuilder());
            this.varArg = bl;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror typeMirror, Boolean bl) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(typeMirror);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType declaredType, Boolean bl) {
            Element element = declaredType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
                Iterator<? extends TypeMirror> iterator = declaredType.getTypeArguments().iterator();
                if (iterator.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (iterator.hasNext()) {
                        this.visit(iterator.next(), bl);
                        if (!iterator.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(JavaSymbolProvider.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType arrayType, Boolean bl) {
            boolean bl2 = this.varArg;
            this.varArg = false;
            this.visit(arrayType.getComponentType(), bl);
            return ((StringBuilder)this.DEFAULT_VALUE).append(bl2 ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable typeVariable, Boolean bl) {
            Object object;
            Element element = typeVariable.asElement();
            if (element != null && !JavaSymbolProvider.CAPTURED_WILDCARD.equals(object = element.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append((String)object);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            if (!this.insideCapturedWildcard) {
                this.insideCapturedWildcard = true;
                object = typeVariable.getLowerBound();
                if (object != null && object.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                    this.visit((TypeMirror)object, bl);
                } else {
                    object = typeVariable.getUpperBound();
                    if (object != null && object.getKind() != TypeKind.NULL) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        if (object.getKind() == TypeKind.TYPEVAR) {
                            object = ((TypeVariable)object).getLowerBound();
                        }
                        this.visit((TypeMirror)object, bl);
                    }
                }
                this.insideCapturedWildcard = false;
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType wildcardType, Boolean bl) {
            int n = ((StringBuilder)this.DEFAULT_VALUE).length();
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror typeMirror = wildcardType.getSuperBound();
            if (typeMirror == null) {
                typeMirror = wildcardType.getExtendsBound();
                if (typeMirror != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (typeMirror.getKind() == TypeKind.WILDCARD) {
                        typeMirror = ((WildcardType)typeMirror).getSuperBound();
                    }
                    this.visit(typeMirror, bl);
                } else if (!(n != 0 || (typeMirror = SourceUtils.getBound((WildcardType)wildcardType)) == null || typeMirror.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals("java.lang.Object"))) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    this.visit(typeMirror, bl);
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(typeMirror, bl);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType errorType, Boolean bl) {
            Element element = errorType.asElement();
            if (element instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)element;
                return ((StringBuilder)this.DEFAULT_VALUE).append((bl != false ? typeElement.getQualifiedName() : typeElement.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

