/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public final class ClassNameTextField
extends JTextField {
    public static final int STATUS_VALID = 0;
    public static final int STATUS_EMPTY = 1;
    public static final int STATUS_INVALID = 2;
    public static final int STATUS_VALID_NOT_DEFAULT = 3;
    public static final int STATUS_VALID_END_NOT_TEST = 4;
    static final int STATUS_BEFORE_PART = 3;
    private TextListener documentListener;
    private int externalStatus = 0;
    private boolean externalStatusValid = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private String defaultText;

    public ClassNameTextField() {
        this(null);
        this.setupDocumentListener();
    }

    public ClassNameTextField(String string) {
        super(string == null ? "" : string);
        this.setupDocumentListener();
    }

    protected Document createDefaultModel() {
        PlainDocument plainDocument = (PlainDocument)super.createDefaultModel();
        plainDocument.setDocumentFilter(new SpaceIgnoringDocumentFilter());
        return plainDocument;
    }

    public void setDefaultText(String string) {
        if (string == null && this.defaultText == null || string != null && string.equals(this.defaultText)) {
            return;
        }
        this.defaultText = string;
        if (string != null || this.externalStatusValid && this.externalStatus == 3) {
            this.statusMaybeChanged();
        }
    }

    private void setupDocumentListener() {
        this.documentListener = new TextListener();
        this.getDocument().addDocumentListener(this.documentListener);
    }

    int determineStatus() {
        String string = this.getText();
        int n = 3;
        char[] cArray = string.toCharArray();
        block4: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (n) {
                case 3: {
                    if (!Character.isJavaIdentifierStart(c)) {
                        return 2;
                    }
                    n = 0;
                    continue block4;
                }
                case 0: {
                    if (c == '.') {
                        n = 3;
                        continue block4;
                    }
                    if (Character.isJavaIdentifierPart(c)) {
                        n = 0;
                        continue block4;
                    }
                    return 2;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        return n;
    }

    public int getStatus() {
        if (!this.externalStatusValid) {
            this.updateExternalStatus();
        }
        return this.externalStatus;
    }

    private void updateExternalStatus() {
        assert (!this.externalStatusValid);
        int n = this.documentListener.status;
        switch (n) {
            case 0: {
                if (!this.getText().endsWith("Test")) {
                    this.externalStatus = 4;
                    break;
                }
                if (this.defaultText != null && !this.defaultText.equals(this.getText())) {
                    this.externalStatus = 3;
                    break;
                }
                this.externalStatus = 0;
                break;
            }
            case 3: {
                this.externalStatus = this.getText().length() == 0 ? 1 : 2;
                break;
            }
            case 2: {
                this.externalStatus = 2;
                break;
            }
            default: {
                assert (false);
                this.externalStatus = 2;
            }
        }
        this.externalStatusValid = true;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeEvent = new ChangeEvent(this);
        this.changeListener = changeListener;
    }

    private void statusMaybeChanged() {
        this.externalStatusValid = false;
        if (this.changeListener != null) {
            int n = this.externalStatus;
            this.externalStatus = this.getStatus();
            if (this.externalStatus != n) {
                this.changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    private static final class SpaceIgnoringDocumentFilter
    extends DocumentFilter {
        private SpaceIgnoringDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.removeSpaces(string);
            if (string2 != null) {
                super.insertString(filterBypass, n, string2, null);
            }
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = this.removeSpaces(string);
            if (string2 == null) {
                super.remove(filterBypass, n, n2);
            } else {
                super.replace(filterBypass, n, n2, string2, null);
            }
        }

        private String removeSpaces(String string) {
            int n = string.length();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return string.charAt(0) == ' ' ? null : string;
            }
            StringBuilder stringBuilder = null;
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) != ' ') {
                    if (stringBuilder == null) continue;
                    stringBuilder.append(string.charAt(i));
                    continue;
                }
                if (stringBuilder != null) continue;
                stringBuilder = new StringBuilder(string.length() - 1);
                stringBuilder.append(string.substring(0, i));
            }
            return stringBuilder == null ? string : (stringBuilder.length() != 0 ? stringBuilder.toString() : null);
        }
    }

    private final class TextListener
    implements DocumentListener {
        private int status;
        private int length;

        public TextListener() {
            this.status = ClassNameTextField.this.determineStatus();
            this.length = ClassNameTextField.this.getText().length();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.length = documentEvent.getDocument().getLength();
            int n = ClassNameTextField.this.determineStatus();
            if (n != this.status) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            boolean bl;
            boolean bl2 = bl = this.length == 0;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length) {
                this.length += documentEvent.getLength();
                n = ClassNameTextField.this.determineStatus();
            } else {
                try {
                    char c = documentEvent.getDocument().getText(this.length++, 1).charAt(0);
                    switch (this.status) {
                        case 0: {
                            n = c == '.' ? (n = 3) : (Character.isJavaIdentifierPart(c) ? 0 : 2);
                            break;
                        }
                        case 3: {
                            n = Character.isJavaIdentifierStart(c) ? 0 : 2;
                            break;
                        }
                        case 2: {
                            n = ClassNameTextField.this.determineStatus();
                            break;
                        }
                        default: {
                            assert (false);
                            n = ClassNameTextField.this.determineStatus();
                            break;
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    assert (false);
                    this.length = documentEvent.getDocument().getLength();
                    n = ClassNameTextField.this.determineStatus();
                }
            }
            if (n != this.status || bl) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            int n;
            if (documentEvent.getLength() != 1 || documentEvent.getOffset() != this.length - 1) {
                this.length -= documentEvent.getLength();
                n = ClassNameTextField.this.determineStatus();
            } else {
                --this.length;
                switch (this.status) {
                    case 0: {
                        try {
                            n = this.length == 0 || documentEvent.getDocument().getText(this.length - 1, 1).charAt(0) == '.' ? 3 : 0;
                        }
                        catch (BadLocationException badLocationException) {
                            assert (false);
                            n = ClassNameTextField.this.determineStatus();
                            this.length = documentEvent.getDocument().getLength();
                        }
                        break;
                    }
                    case 3: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = this.length == 0 ? 0 : ClassNameTextField.this.determineStatus();
                        break;
                    }
                    default: {
                        assert (false);
                        n = ClassNameTextField.this.determineStatus();
                    }
                }
            }
            if (n != this.status || this.length == 0) {
                this.status = n;
                ClassNameTextField.this.statusMaybeChanged();
            } else if (this.status == 0 && ClassNameTextField.this.defaultText != null) {
                ClassNameTextField.this.statusMaybeChanged();
            }
            assert (this.length == ClassNameTextField.this.getDocument().getLength());
        }
    }
}

