/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitExecutionManager
implements RerunHandler {
    private File scriptFile = null;
    private String[] targets = null;
    private Properties properties;
    private TestSession testSession;
    private Lookup lookup = Lookup.EMPTY;

    public JUnitExecutionManager(AntSession antSession, TestSession testSession, Properties properties) {
        this.testSession = testSession;
        this.properties = properties;
        try {
            Object object;
            this.scriptFile = antSession.getOriginatingScript();
            this.targets = antSession.getOriginatingTargets();
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i].equals("test-single")) {
                    this.targets[i] = "test.single";
                    continue;
                }
                if (!this.targets[i].equals("debug-test")) continue;
                this.targets[i] = "debug.test.single";
            }
            String string = this.properties.getProperty("javac.includes");
            if (string != null) {
                object = testSession.getFileLocator().find(string);
                this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)object)});
            }
            if (this.targets.length == 0) {
                object = this.properties.getProperty("classname");
                String string2 = this.properties.getProperty("methodname");
                if (object != null) {
                    FileObject fileObject = testSession.getFileLocator().find(((String)object).replace('.', '/') + ".java");
                    if (string2 != null) {
                        SingleMethod singleMethod = new SingleMethod(fileObject, string2);
                        this.lookup = Lookups.singleton((Object)singleMethod);
                    } else {
                        this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)fileObject)});
                    }
                }
                if (this.scriptFile.getName().equals("junit.xml")) {
                    this.targets = string2 != null ? new String[]{"run.single.method"} : new String[]{"test.single"};
                } else if (this.scriptFile.getName().equals("junit-debug.xml")) {
                    this.targets = string2 != null ? new String[]{"debug.single.method"} : new String[]{"debug.test.single"};
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rerun() {
        Project project = this.testSession.getProject();
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        actionProvider.invokeAction(this.targets[0], this.lookup);
    }

    public boolean enabled() {
        if (this.scriptFile == null || this.targets == null || this.targets.length == 0) {
            return false;
        }
        Project project = this.testSession.getProject();
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider != null) {
            boolean bl = false;
            for (String string : actionProvider.getSupportedActions()) {
                if (!string.equals(this.targets[0])) continue;
                bl = true;
                break;
            }
            if (bl && actionProvider.isActionEnabled(this.targets[0], this.lookup)) {
                return true;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

