/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output.antutils;

import java.io.File;
import java.util.Collection;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.netbeans.modules.junit.output.antutils.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileSet {
    private final AntProject project;
    private PatternSet implicitPatternSet;
    private File baseDir;
    private File file;
    private boolean defaultExcludes = true;
    private boolean caseSensitive = true;
    private boolean followSymlinks;

    FileSet(AntProject antProject) {
        this.project = antProject;
    }

    void handleChildrenAndAttrs(TaskStructure taskStructure) {
        this.setAttrs(taskStructure);
        this.implicitPatternSet = new PatternSet(this.project);
        this.implicitPatternSet.handleChildrenAndAttrs(taskStructure);
    }

    private void setAttrs(TaskStructure taskStructure) {
        String string = taskStructure.getAttribute("dir");
        String string2 = taskStructure.getAttribute("file");
        String string3 = taskStructure.getAttribute("defaultexcludes");
        String string4 = taskStructure.getAttribute("casesensitive");
        String string5 = taskStructure.getAttribute("followsymlinks");
        if (string != null) {
            string = this.project.replaceProperties(string);
            this.setBaseDir(this.project.resolveFile(string));
        }
        if (string2 != null) {
            string2 = this.project.replaceProperties(string2);
            this.setFile(this.project.resolveFile(string2));
        }
        if (string3 != null) {
            string3 = this.project.replaceProperties(string3);
            this.setDefaultExcludes(AntProject.toBoolean(string3));
        }
        if (string4 != null) {
            string4 = this.project.replaceProperties(string4);
            this.setCaseSensitive(AntProject.toBoolean(string4));
        }
        if (string5 != null) {
            string5 = this.project.replaceProperties(string5);
            this.setFollowSymlinks(AntProject.toBoolean(string5));
        }
    }

    private void setBaseDir(File file) {
        this.baseDir = file;
    }

    private void setFile(File file) {
        this.file = file;
    }

    private void setDefaultExcludes(boolean bl) {
        this.defaultExcludes = bl;
    }

    private void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    private void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    File getBaseDir() {
        return this.baseDir;
    }

    File getFile() {
        return this.file;
    }

    boolean isDefaultExcludes() {
        return this.defaultExcludes;
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    Collection<String> getIncludePatterns() {
        return this.implicitPatternSet.getIncludePatterns();
    }

    Collection<String> getExcludesPatterns() {
        return this.implicitPatternSet.getExcludePatterns();
    }
}

