/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.client.model_5_0.ApplicationClient;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbJarProxy;
import org.netbeans.modules.j2ee.dd.impl.ejb.model_2_0.EjbJar;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDUtils {
    public static EjbJarProxy createEjbJarProxy(InputStream inputStream) throws IOException {
        return DDUtils.createEjbJarProxy(new InputSource(inputStream));
    }

    public static EjbJarProxy createEjbJarProxy(Reader reader) throws IOException {
        return DDUtils.createEjbJarProxy(new InputSource(reader));
    }

    public static EjbJarProxy createEjbJarProxy(InputSource inputSource) throws IOException {
        try {
            return (EjbJarProxy)DDProvider.getDefault().getDDRoot(inputSource);
        }
        catch (SAXException sAXException) {
            EjbJar ejbJar = EjbJar.createGraph();
            EjbJarProxy ejbJarProxy = new EjbJarProxy(ejbJar, ejbJar.getVersion().toString());
            ejbJarProxy.setStatus(2);
            if (sAXException instanceof SAXParseException) {
                ejbJarProxy.setError((SAXParseException)sAXException);
            } else if (sAXException.getException() instanceof SAXParseException) {
                ejbJarProxy.setError((SAXParseException)sAXException.getException());
            }
            return ejbJarProxy;
        }
    }

    public static void merge(EjbJarProxy ejbJarProxy, Reader reader) {
        try {
            EjbJarProxy ejbJarProxy2 = DDUtils.createEjbJarProxy(reader);
            if (ejbJarProxy2.getStatus() == 2) {
                ejbJarProxy.setStatus(2);
                ejbJarProxy.setError(ejbJarProxy2.getError());
                return;
            }
            ejbJarProxy.merge(ejbJarProxy2, 3);
            ejbJarProxy.setStatus(ejbJarProxy2.getStatus());
            ejbJarProxy.setError(ejbJarProxy2.getError());
        }
        catch (IOException iOException) {
            ejbJarProxy.setStatus(2);
        }
        catch (Schema2BeansRuntimeException schema2BeansRuntimeException) {
            ejbJarProxy.setStatus(2);
            ejbJarProxy.setError(new SAXParseException(null, null, (Exception)((Object)schema2BeansRuntimeException)));
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof Schema2BeansException) {
                ejbJarProxy.setStatus(2);
                ejbJarProxy.setError(new SAXParseException(null, null, (Exception)((Object)((Schema2BeansException)runtimeException.getCause()))));
            }
            if (runtimeException instanceof IllegalArgumentException) {
                ejbJarProxy.setStatus(2);
                Logger.getLogger(DDUtils.class.getName()).log(Level.FINE, "IAE thrown during merge, see #104180.", runtimeException);
            }
            throw runtimeException;
        }
    }

    public static WebApp createWebApp(InputStream inputStream, String string) throws IOException, SAXException {
        try {
            if ("2.3".equals(string)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_2_3.WebApp.createGraph(inputStream);
            }
            if ("2.4".equals(string)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_2_4.WebApp.createGraph(inputStream);
            }
            return org.netbeans.modules.j2ee.dd.impl.web.model_2_5.WebApp.createGraph(inputStream);
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException(runtimeException);
        }
    }

    public static AppClient createAppClient(InputStream inputStream, String string) throws IOException, SAXException {
        try {
            if ("1.3".equals(string)) {
                return org.netbeans.modules.j2ee.dd.impl.client.model_1_3.ApplicationClient.createGraph(inputStream);
            }
            if ("1.4".equals(string)) {
                return org.netbeans.modules.j2ee.dd.impl.client.model_1_4.ApplicationClient.createGraph(inputStream);
            }
            if ("5".equals(string)) {
                return ApplicationClient.createGraph(inputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException(runtimeException);
        }
        return null;
    }
}

