/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.Collections;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CompletionContextFinder;
import org.openide.util.Exceptions;

public class PHPCodeTemplateFilter
extends UserTask
implements CodeTemplateFilter {
    private boolean accept = false;
    private int caretOffset;
    private CompletionContextFinder.CompletionContext context;

    public PHPCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.caretOffset = n;
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)jTextComponent.getDocument())), (UserTask)this);
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
    }

    public boolean accept(CodeTemplate codeTemplate) {
        if (codeTemplate.getContexts().contains("php-code")) {
            if (this.context == CompletionContextFinder.CompletionContext.CLASS_CONTEXT_KEYWORDS) {
                return codeTemplate.getAbbreviation().equals("fnc");
            }
            return this.accept;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ResultIterator resultIterator) throws Exception {
        ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
        BaseDocument baseDocument = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        if (baseDocument == null) return;
        baseDocument.readLock();
        try {
            this.context = CompletionContextFinder.findCompletionContext(parserResult, this.caretOffset);
            switch (this.context) {
                case EXPRESSION: {
                    this.accept = true;
                    return;
                }
                case CLASS_CONTEXT_KEYWORDS: {
                    this.accept = true;
                    return;
                }
            }
            return;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new PHPCodeTemplateFilter(jTextComponent, n);
        }
    }
}

