/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingBracketCompleter {
    static final String TYPE_PLACEHOLDER = "<type>";
    private static final SemiAttribute.AttributedType PRINT_NO_TYPE = new SemiAttribute.AttributedType(){

        public String getTypeName() {
            return null;
        }
    };

    static void generateDocTags(final BaseDocument baseDocument, final int n, final int n2) {
        FileObject fileObject = NavUtils.getFile((Document)baseDocument);
        if (fileObject == null) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)baseDocument)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    class Result
                    extends Error {
                        private ASTNode node;

                        public Result(ASTNode aSTNode) {
                            this.node = aSTNode;
                        }
                    }
                    SemiAttribute.AttributedElement attributedElement;
                    Assignment assignment;
                    final ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                    ASTNode aSTNode = null;
                    try {
                        new DefaultVisitor(){

                            public void scan(ASTNode aSTNode) {
                                Comment comment;
                                if (aSTNode != null && (comment = Utils.getCommentForNode(Utils.getRoot(parserResult), aSTNode)) != null && comment.getStartOffset() <= n && n <= comment.getEndOffset()) {
                                    throw new Result(aSTNode);
                                }
                                super.scan(aSTNode);
                            }
                        }.scan(Utils.getRoot(parserResult));
                    }
                    catch (Result result) {
                        aSTNode = result.node;
                    }
                    if (aSTNode == null) {
                        return;
                    }
                    if (aSTNode instanceof FunctionDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(baseDocument, n, n2, parserResult, (FunctionDeclaration)aSTNode);
                    }
                    if (aSTNode instanceof MethodDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(baseDocument, n, n2, parserResult, ((MethodDeclaration)aSTNode).getFunction());
                    }
                    if (aSTNode instanceof ExpressionStatement && ((ExpressionStatement)aSTNode).getExpression() instanceof Assignment && (assignment = (Assignment)((ExpressionStatement)aSTNode).getExpression()).getLeftHandSide() instanceof ArrayAccess && (attributedElement = SemiAttribute.semiAttribute(parserResult).getElement(assignment.getLeftHandSide())) != null && attributedElement.getKind() == SemiAttribute.AttributedElement.Kind.VARIABLE) {
                        GeneratingBracketCompleter.generateVariableDoc(baseDocument, n, n2, parserResult, attributedElement);
                    }
                    if (aSTNode instanceof FieldsDeclaration) {
                        GeneratingBracketCompleter.generateFieldDoc(baseDocument, n, n2, parserResult, (FieldsDeclaration)aSTNode);
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
    }

    private static void generateFunctionDoc(BaseDocument baseDocument, int n, int n2, ParserResult parserResult, FunctionDeclaration functionDeclaration) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        ScannerImpl scannerImpl = new ScannerImpl(parserResult, functionDeclaration);
        scannerImpl.scan(functionDeclaration);
        GeneratingBracketCompleter.addVariables(baseDocument, stringBuilder, "@global", n2, scannerImpl.globals);
        GeneratingBracketCompleter.addVariables(baseDocument, stringBuilder, "@staticvar", n2, scannerImpl.staticvars);
        for (FormalParameter formalParameter : functionDeclaration.getFormalParameters()) {
            Identifier identifier;
            Object object;
            String string = "";
            Expression expression = formalParameter.getParameterName();
            Variable variable = null;
            if (expression instanceof Variable) {
                variable = (Variable)expression;
            }
            if (expression instanceof Reference && ((Reference)(object = (Reference)expression)).getExpression() instanceof Variable) {
                variable = (Variable)((Reference)object).getExpression();
            }
            if (variable != null && variable.getName() instanceof Identifier) {
                string = ((Identifier)variable.getName()).getName();
            }
            object = null;
            if (formalParameter.getParameterType() != null && (identifier = formalParameter.getParameterType()) != null) {
                object = new SemiAttribute.AttributedType(){

                    public String getTypeName() {
                        return identifier.getName();
                    }
                };
            }
            GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, "@param", n2, "$" + string, (SemiAttribute.AttributedType)object);
        }
        if (scannerImpl.hasReturn) {
            GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, "@return", n2, null, scannerImpl.returnType);
        }
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    private static void addVariables(BaseDocument baseDocument, StringBuilder stringBuilder, String string, int n, List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> list) {
        for (Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType> pair : list) {
            GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, string, n, "$" + pair.getA().getName(), pair.getB());
        }
    }

    private static void generateDocEntry(BaseDocument baseDocument, StringBuilder stringBuilder, String string, int n, String string2, SemiAttribute.AttributedType attributedType) {
        stringBuilder.append("\n");
        stringBuilder.append(IndentUtils.createIndentString((Document)baseDocument, (int)n));
        stringBuilder.append(" * ");
        stringBuilder.append(string);
        if (attributedType != null) {
            if (attributedType != PRINT_NO_TYPE) {
                stringBuilder.append(" ");
                stringBuilder.append(attributedType.getTypeName());
            }
        } else {
            stringBuilder.append(" ");
            stringBuilder.append(TYPE_PLACEHOLDER);
        }
        if (string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
    }

    private static void generateVariableDoc(BaseDocument baseDocument, int n, int n2, ParserResult parserResult, SemiAttribute.AttributedElement attributedElement) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, "@global", n2, "$GLOBALS['" + attributedElement.getName() + "']", null);
        GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, "@name", n2, "$" + attributedElement.getName(), PRINT_NO_TYPE);
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    private static void generateFieldDoc(BaseDocument baseDocument, int n, int n2, ParserResult parserResult, FieldsDeclaration fieldsDeclaration) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(baseDocument, stringBuilder, "@var", n2, null, null);
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScannerImpl
    extends DefaultVisitor {
        private List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> globals = new LinkedList<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>>();
        private List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> staticvars = new LinkedList<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>>();
        private boolean hasReturn;
        private SemiAttribute.AttributedType returnType;
        private SemiAttribute sa;
        private FunctionDeclaration decl;

        public ScannerImpl(ParserResult parserResult, FunctionDeclaration functionDeclaration) {
            this.sa = SemiAttribute.semiAttribute(parserResult);
            this.decl = functionDeclaration;
        }

        @Override
        public void visit(GlobalStatement globalStatement) {
            for (Variable variable : globalStatement.getVariables()) {
                this.handleVariable(variable, this.globals);
            }
            super.visit(globalStatement);
        }

        @Override
        public void visit(ReturnStatement returnStatement) {
            ClassInstanceCreation classInstanceCreation;
            String string;
            this.hasReturn = true;
            Expression expression = returnStatement.getExpression();
            if (expression instanceof ClassInstanceCreation && (string = CodeUtils.extractClassName((classInstanceCreation = (ClassInstanceCreation)expression).getClassName())) != null) {
                this.returnType = new SemiAttribute.AttributedType(){

                    public String getTypeName() {
                        return string;
                    }
                };
            }
        }

        @Override
        public void visit(StaticStatement staticStatement) {
            for (Variable variable : staticStatement.getVariables()) {
                this.handleVariable(variable, this.staticvars);
            }
            super.visit(staticStatement);
        }

        private void handleVariable(Variable variable, List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> list) {
            SemiAttribute.AttributedElement attributedElement = this.sa.getElement(variable);
            if (attributedElement != null) {
                list.add(new Pair<SemiAttribute.AttributedElement, Object>(attributedElement, null));
            }
        }

        @Override
        public void visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration == this.decl) {
                super.visit(functionDeclaration);
            }
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
        }
    }
}

