/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentLevelCalculator
extends DefaultTreePathVisitor {
    private Map<Position, Integer> indentLevels;
    private int indentSize;
    private int continuationIndentSize;
    private BaseDocument doc;

    public IndentLevelCalculator(Document document, Map<Position, Integer> map) {
        this.indentLevels = map;
        this.doc = (BaseDocument)document;
        CodeStyle codeStyle = CodeStyle.get(document);
        this.indentSize = codeStyle.getIndentSize();
        this.continuationIndentSize = codeStyle.getContinuationIndentSize();
    }

    @Override
    public void visit(Block block) {
        this.indentListOfStatements(block.getStatements());
        super.visit(block);
    }

    @Override
    public void visit(IfStatement ifStatement) {
        this.indentNonBlockStatement(ifStatement.getFalseStatement());
        this.indentNonBlockStatement(ifStatement.getTrueStatement());
        super.visit(ifStatement);
    }

    @Override
    public void visit(DoStatement doStatement) {
        this.indentNonBlockStatement(doStatement.getBody());
        super.visit(doStatement);
    }

    @Override
    public void visit(ForEachStatement forEachStatement) {
        this.indentNonBlockStatement(forEachStatement.getStatement());
        super.visit(forEachStatement);
    }

    @Override
    public void visit(ForStatement forStatement) {
        this.indentNonBlockStatement(forStatement.getBody());
        super.visit(forStatement);
    }

    @Override
    public void visit(WhileStatement whileStatement) {
        this.indentNonBlockStatement(whileStatement.getBody());
        super.visit(whileStatement);
    }

    @Override
    public void visit(InfixExpression infixExpression) {
        this.indentContinuationWithinStatement(infixExpression);
    }

    @Override
    public void visit(ExpressionStatement expressionStatement) {
        this.indentContinuationWithinStatement(expressionStatement);
    }

    @Override
    public void visit(Program program) {
        for (Comment comment : program.getComments()) {
            if (!(comment instanceof PHPDocBlock)) continue;
            try {
                int n = Utilities.getRowEnd((BaseDocument)this.doc, (int)comment.getStartOffset());
                if (n >= comment.getEndOffset()) continue;
                this.addIndentLevel(n, 1);
                this.addIndentLevel(comment.getEndOffset(), -1);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        super.visit(program);
    }

    @Override
    public void visit(SwitchCase switchCase) {
        this.indentListOfStatements(switchCase.getActions());
        super.visit(switchCase);
    }

    private void indentContinuationWithinStatement(ASTNode aSTNode) {
        try {
            int n = Utilities.getRowEnd((BaseDocument)this.doc, (int)aSTNode.getStartOffset());
            if (n < aSTNode.getEndOffset()) {
                this.addIndentLevel(n + 1, this.continuationIndentSize);
                TokenSequence<PHPTokenId> tokenSequence = LexUtilities.getPHPTokenSequence((Document)this.doc, aSTNode.getEndOffset());
                int n2 = aSTNode.getEndOffset();
                if (tokenSequence != null) {
                    tokenSequence.move(aSTNode.getEndOffset());
                    do {
                        tokenSequence.movePrevious();
                    } while (IndentLevelCalculator.indentContinuationWithinStatement_skipToken(tokenSequence.token()));
                    n2 = tokenSequence.offset() + tokenSequence.token().length();
                }
                this.addIndentLevel(n2, -1 * this.continuationIndentSize);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static boolean indentContinuationWithinStatement_skipToken(Token token) {
        TokenId tokenId = token.id();
        if (tokenId == PHPTokenId.PHP_SEMICOLON) {
            return true;
        }
        return tokenId == PHPTokenId.PHP_TOKEN && ")".equals(((Object)token.text()).toString());
    }

    private void indentListOfStatements(List<Statement> list) {
        if (list.size() > 0) {
            ASTNode aSTNode = list.get(0);
            ASTNode aSTNode2 = list.get(list.size() - 1);
            int n = IndentLevelCalculator.firstNonWSBwd(this.doc, aSTNode.getStartOffset()) + 1;
            int n2 = IndentLevelCalculator.firstNonWSFwd(this.doc, aSTNode2.getEndOffset()) - 1;
            this.addIndentLevel(n, this.indentSize);
            this.addIndentLevel(n2, -1 * this.indentSize);
        }
    }

    @Override
    public void visit(FunctionDeclaration functionDeclaration) {
        int n = functionDeclaration.getFormalParameters().size();
        if (n > 0) {
            FormalParameter formalParameter = functionDeclaration.getFormalParameters().get(0);
            FormalParameter formalParameter2 = functionDeclaration.getFormalParameters().get(n - 1);
            this.addIndentLevel(formalParameter.getStartOffset(), this.continuationIndentSize);
            this.addIndentLevel(formalParameter2.getEndOffset(), -1 * this.continuationIndentSize);
        }
        super.visit(functionDeclaration);
    }

    private void indentNonBlockStatement(ASTNode aSTNode) {
        if (aSTNode == null || aSTNode instanceof Block) {
            return;
        }
        if (aSTNode instanceof IfStatement) {
            String string = "elseif";
            try {
                if (this.doc.getLength() > aSTNode.getStartOffset() + string.length() && string.equals(this.doc.getText(aSTNode.getStartOffset(), string.length()))) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        int n = IndentLevelCalculator.firstNonWSBwd(this.doc, aSTNode.getStartOffset()) + 1;
        int n2 = IndentLevelCalculator.firstNonWSFwd(this.doc, aSTNode.getEndOffset()) - 1;
        this.addIndentLevel(n, this.indentSize);
        this.addIndentLevel(n2, -1 * this.indentSize);
    }

    private static int firstNonWSBwd(BaseDocument baseDocument, int n) {
        int n2 = n;
        try {
            int n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)baseDocument, (int)n);
            if (n3 >= 0) {
                n2 = n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return n2;
    }

    private static int firstNonWSFwd(BaseDocument baseDocument, int n) {
        int n2 = n;
        try {
            int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n);
            if (n3 >= 0) {
                n2 = n3;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return n2;
    }

    private void addIndentLevel(int n, int n2) {
        Integer n3 = this.indentLevels.get(n);
        int n4 = n3 == null ? n2 : n2 + n3;
        try {
            this.indentLevels.put(this.doc.createPosition(n), n4);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }
}

