/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.PhpKind;
import org.netbeans.modules.php.editor.model.PhpModifiers;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachingSupport {
    private FileScopeImpl fileScope;
    private List<ClassScope> classScopes = new ArrayList<ClassScope>();
    private List<InterfaceScope> ifaceScopes = new ArrayList<InterfaceScope>();
    private List<ConstantElement> constantScopes = new ArrayList<ConstantElement>();
    private List<FunctionScope> fncScopes = new ArrayList<FunctionScope>();
    private Map<TypeScope, List<MethodScope>> methodScopes = new LinkedHashMap<TypeScope, List<MethodScope>>();
    private Map<TypeScope, List<FieldElement>> fldElems = new LinkedHashMap<TypeScope, List<FieldElement>>();
    private Map<TypeScope, List<ClassConstantElement>> clzConstantElems = new LinkedHashMap<TypeScope, List<ClassConstantElement>>();

    @CheckForNull
    static CachingSupport getInstance(ModelElement modelElement) {
        FileScopeImpl fileScopeImpl = (FileScopeImpl)ModelUtils.getFileScope(modelElement);
        return fileScopeImpl != null ? fileScopeImpl.getCachingSupport() : null;
    }

    CachingSupport(FileScopeImpl fileScopeImpl) {
        this.fileScope = fileScopeImpl;
    }

    static Collection<? extends ClassConstantElement> getInheritedConstants(ClassScope classScope, String string, ModelElement modelElement) {
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        Collection<? extends ClassConstantElement> collection = cachingSupport != null ? cachingSupport.getInheritedMergedConstants((ClassScopeImpl)classScope, string) : classScope.findInheritedConstants(string);
        return collection;
    }

    static Collection<? extends FieldElement> getInheritedFields(ClassScope classScope, String string, ModelElement modelElement, int ... nArray) {
        assert (string.startsWith("$"));
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        Collection<? extends FieldElement> collection = cachingSupport != null ? cachingSupport.getInheritedMergedFields((ClassScopeImpl)classScope, string) : classScope.findInheritedFields(string);
        return collection;
    }

    static Collection<? extends MethodScope> getMethods(ClassScope classScope, String string, ModelElement modelElement, int ... nArray) {
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        Collection<? extends MethodScope> collection = cachingSupport != null ? cachingSupport.getMergedMethods((ClassScopeImpl)classScope, string, new int[0]) : classScope.findDeclaredMethods(string, nArray);
        return collection;
    }

    static Collection<? extends MethodScope> getInheritedMethods(TypeScope typeScope, String string, ModelElement modelElement, int ... nArray) {
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        Collection<? extends MethodScope> collection = cachingSupport != null ? cachingSupport.getInheritedMergedMethods((TypeScopeImpl)typeScope, string) : typeScope.findInheritedMethods(string);
        return collection;
    }

    static Collection<? extends TypeScope> getTypes(String string, ModelElement modelElement) {
        IndexScope indexScope = ModelUtils.getIndexScope(modelElement);
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        Collection<? extends TypeScope> collection = cachingSupport != null ? cachingSupport.getMergedTypes(string) : indexScope.findTypes(string);
        return collection;
    }

    static List<? extends ClassScope> getClasses(String string, ModelElement modelElement) {
        IndexScope indexScope = ModelUtils.getIndexScope(modelElement);
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        List<? extends ClassScope> list = cachingSupport != null ? cachingSupport.getMergedClasses(string) : indexScope.findClasses(string);
        return list;
    }

    static List<? extends InterfaceScope> getInterfaces(String string, ModelElement modelElement) {
        IndexScope indexScope = ModelUtils.getIndexScope(modelElement);
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        List<? extends InterfaceScope> list = cachingSupport != null ? cachingSupport.getMergedIfaces(string) : ModelUtils.filter(indexScope.findInterfaces(string), new String[0]);
        return list;
    }

    static List<? extends ConstantElement> getConstants(String string, Scope scope) {
        IndexScope indexScope = ModelUtils.getIndexScope(scope);
        CachingSupport cachingSupport = CachingSupport.getInstance(scope);
        List<? extends ConstantElement> list = cachingSupport != null ? cachingSupport.getMergedConstants(string) : ModelUtils.filter(indexScope.findConstants(string), new String[0]);
        return list;
    }

    static Collection<? extends FunctionScope> getFunctions(String string, ModelElement modelElement) {
        IndexScope indexScope = ModelUtils.getIndexScope(modelElement);
        CachingSupport cachingSupport = CachingSupport.getInstance(modelElement);
        List<? extends FunctionScope> list = cachingSupport != null ? cachingSupport.getMergedFunctions(string) : ModelUtils.filter(indexScope.findFunctions(string), new String[0]);
        return list;
    }

    private Collection<? extends ClassConstantElement> getInheritedMergedConstants(ClassScopeImpl classScopeImpl, String string) {
        List<ClassConstantElement> list = this.getCachedClassConstants(classScopeImpl, string);
        if (list.isEmpty()) {
            Object object;
            classScopeImpl.findInheritedConstants(string);
            Collection<Object> collection = list = classScopeImpl != null ? classScopeImpl.findInheritedConstants(string) : Collections.emptyList();
            if (list.isEmpty()) {
                object = this.fileScope.getIndexScope();
                List<Object> list2 = list = classScopeImpl != null ? object.findInheritedClassConstants(classScopeImpl, string) : Collections.emptyList();
            }
            if (!list.isEmpty() && (object = this.clzConstantElems.get(classScopeImpl)) != null) {
                object.add(ModelUtils.getFirst(list));
            }
        }
        return list;
    }

    private List<? extends FieldElement> getInheritedMergedFields(ClassScopeImpl classScopeImpl, String string) {
        List<FieldElement> list = this.getCachedFields(classScopeImpl, string, new int[0]);
        if (list.isEmpty()) {
            Object object;
            Collection<Object> collection = list = classScopeImpl != null ? classScopeImpl.findInheritedFields(string) : Collections.emptyList();
            if (list.isEmpty()) {
                object = this.fileScope.getIndexScope();
                List<Object> list2 = list = classScopeImpl != null ? object.findInheritedFields(classScopeImpl, string) : Collections.emptyList();
            }
            if (!list.isEmpty() && (object = this.fldElems.get(classScopeImpl)) != null) {
                object.add(ModelUtils.getFirst(list));
            }
        }
        return list;
    }

    private List<? extends MethodScope> getInheritedMergedMethods(TypeScopeImpl typeScopeImpl, String string) {
        List<MethodScope> list = this.getCachedMethods(typeScopeImpl, string, new int[0]);
        if (list.isEmpty()) {
            List<MethodScope> list2;
            Collection<Object> collection = list = typeScopeImpl != null ? typeScopeImpl.findInheritedMethods(string) : Collections.emptyList();
            if (list.isEmpty()) {
                list2 = this.fileScope.getIndexScope();
                List<Object> list3 = list = typeScopeImpl != null ? list2.findInheritedMethods(typeScopeImpl, string) : Collections.emptyList();
            }
            if (!list.isEmpty()) {
                list2 = this.methodScopes.get(typeScopeImpl);
                if (list2 == null) {
                    list2 = new ArrayList<MethodScope>();
                    this.methodScopes.put(typeScopeImpl, list2);
                }
                list2.add(ModelUtils.getFirst(list));
            }
        }
        return list;
    }

    private Collection<? extends MethodScope> getMergedMethods(ClassScopeImpl classScopeImpl, String string, int ... nArray) {
        List<MethodScope> list = this.getCachedMethods(classScopeImpl, string, new int[0]);
        if (list.isEmpty()) {
            Object object;
            Collection<Object> collection = list = classScopeImpl != null ? classScopeImpl.findDeclaredMethods(string, nArray) : Collections.emptyList();
            if (list.isEmpty()) {
                object = this.fileScope.getIndexScope();
                List<Object> list2 = list = classScopeImpl != null ? object.findMethods((TypeScope)classScopeImpl, string, nArray) : Collections.emptyList();
            }
            if (!list.isEmpty() && (object = this.methodScopes.get(classScopeImpl)) != null) {
                object.add(ModelUtils.getFirst(list));
            }
        }
        return list;
    }

    private List<? extends InterfaceScope> getMergedIfaces(String string) {
        List<InterfaceScope> list = this.getCachedInterfaces(string);
        if (list.isEmpty()) {
            List<Object> list2 = list = string != null ? ModelUtils.filter(this.fileScope.getDeclaredInterfaces(), string) : Collections.emptyList();
            if (list.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                list = string != null ? indexScope.findInterfaces(string) : Collections.emptyList();
                InterfaceScope interfaceScope = ModelUtils.getFirst(list);
                if (interfaceScope != null) {
                    this.ifaceScopes.add(interfaceScope);
                    this.methodScopes.put(interfaceScope, new ArrayList());
                    this.fldElems.put(interfaceScope, new ArrayList());
                    this.clzConstantElems.put(interfaceScope, new ArrayList());
                }
            }
        }
        return list;
    }

    private List<? extends ClassScope> getMergedClasses(String string) {
        List<ClassScope> list = this.getCachedClasses(string);
        if (list.isEmpty()) {
            List<Object> list2 = list = string != null ? ModelUtils.filter(this.fileScope.getDeclaredClasses(), string) : Collections.emptyList();
            if (list.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                list = string != null ? indexScope.findClasses(string) : Collections.emptyList();
                ClassScope classScope = ModelUtils.getFirst(list);
                if (classScope != null) {
                    this.classScopes.add(classScope);
                    this.methodScopes.put(classScope, new ArrayList());
                    this.fldElems.put(classScope, new ArrayList());
                    this.clzConstantElems.put(classScope, new ArrayList());
                }
            }
        }
        return list;
    }

    private Collection<? extends TypeScope> getMergedTypes(String string) {
        Collection<? extends TypeScope> collection = this.getCachedTypes(string);
        if (collection.isEmpty()) {
            Collection<Object> collection2 = collection = string != null ? ModelUtils.filter(this.fileScope.getDeclaredTypes(), string) : Collections.emptyList();
            if (collection.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                collection = string != null ? indexScope.findTypes(string) : Collections.emptyList();
                for (TypeScope typeScope : collection) {
                    if (typeScope instanceof ClassScopeImpl) {
                        this.classScopes.add((ClassScopeImpl)typeScope);
                        continue;
                    }
                    if (!(typeScope instanceof InterfaceScopeImpl)) continue;
                    this.ifaceScopes.add((InterfaceScopeImpl)typeScope);
                }
            }
        }
        return collection;
    }

    private List<? extends ConstantElement> getMergedConstants(String string) {
        List<ConstantElement> list = this.getCachedConstants(string);
        if (list.isEmpty()) {
            List<Object> list2 = list = string != null ? ModelUtils.filter(this.fileScope.getDeclaredConstants(), string) : Collections.emptyList();
            if (list.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                list = string != null ? indexScope.findConstants(string) : Collections.emptyList();
                this.constantScopes.addAll(list);
            }
        }
        return list;
    }

    private List<? extends FunctionScope> getMergedFunctions(String string) {
        List<FunctionScope> list = this.getCachedFunctions(string);
        if (list.isEmpty()) {
            List<Object> list2 = list = string != null ? ModelUtils.filter(this.fileScope.getDeclaredFunctions(), string) : Collections.emptyList();
            if (list.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                list = string != null ? indexScope.findFunctions(string) : Collections.emptyList();
                this.fncScopes.addAll(list);
            }
        }
        return list;
    }

    private List<? extends InterfaceScope> getCachedInterfaces(String ... stringArray) {
        return this.getCachedInterfaces(QuerySupport.Kind.EXACT, stringArray);
    }

    private List<? extends InterfaceScope> getCachedInterfaces(final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(this.ifaceScopes, new ModelUtils.ElementFilter<InterfaceScope>(){

            @Override
            public boolean isAccepted(InterfaceScope interfaceScope) {
                return interfaceScope.getPhpKind().equals((Object)PhpKind.IFACE) && (stringArray.length == 0 || ModelElementImpl.nameKindMatch(interfaceScope.getName(), kind, stringArray));
            }
        });
    }

    private List<? extends ClassScope> getCachedClasses(String ... stringArray) {
        return this.getCachedClasses(QuerySupport.Kind.EXACT, stringArray);
    }

    private List<? extends ClassScope> getCachedClasses(final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(this.classScopes, new ModelUtils.ElementFilter<ClassScope>(){

            @Override
            public boolean isAccepted(ClassScope classScope) {
                return classScope.getPhpKind().equals((Object)PhpKind.CLASS) && (stringArray.length == 0 || ModelElementImpl.nameKindMatch(classScope.getName(), kind, stringArray));
            }
        });
    }

    private List<? extends FieldElement> getCachedFields(ClassScope classScope, String string, int ... nArray) {
        return this.getCachedFields(QuerySupport.Kind.EXACT, classScope, string, nArray);
    }

    private List<? extends FieldElement> getCachedFields(final QuerySupport.Kind kind, ClassScope classScope, final String string, final int ... nArray) {
        List<FieldElement> list = this.fldElems.get(classScope);
        if (list == null) {
            return Collections.emptyList();
        }
        return ModelUtils.filter(list, new ModelUtils.ElementFilter<FieldElement>(){

            @Override
            public boolean isAccepted(FieldElement fieldElement) {
                return fieldElement.getPhpKind().equals((Object)PhpKind.FIELD) && ModelElementImpl.nameKindMatch(fieldElement.getName(), kind, string) && (nArray.length == 0 || (fieldElement.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
    }

    private List<? extends ClassConstantElement> getCachedClassConstants(ClassScopeImpl classScopeImpl, String string) {
        return this.getCachedClassConstants(QuerySupport.Kind.EXACT, classScopeImpl, string);
    }

    private List<? extends ClassConstantElement> getCachedClassConstants(final QuerySupport.Kind kind, ClassScopeImpl classScopeImpl, final String string) {
        List<ClassConstantElement> list = this.clzConstantElems.get(classScopeImpl);
        if (list == null) {
            return Collections.emptyList();
        }
        return ModelUtils.filter(list, new ModelUtils.ElementFilter<ClassConstantElement>(){

            @Override
            public boolean isAccepted(ClassConstantElement classConstantElement) {
                return classConstantElement.getPhpKind().equals((Object)PhpKind.CLASS_CONSTANT) && ModelElementImpl.nameKindMatch(classConstantElement.getName(), kind, string);
            }
        });
    }

    private List<? extends MethodScope> getCachedMethods(TypeScopeImpl typeScopeImpl, String string, int ... nArray) {
        return this.getCachedMethods(QuerySupport.Kind.EXACT, typeScopeImpl, string, nArray);
    }

    private List<? extends MethodScope> getCachedMethods(final QuerySupport.Kind kind, TypeScopeImpl typeScopeImpl, final String string, final int ... nArray) {
        List<MethodScope> list = this.methodScopes.get(typeScopeImpl);
        if (list == null) {
            return Collections.emptyList();
        }
        List<MethodScope> list2 = ModelUtils.filter(list, new ModelUtils.ElementFilter<MethodScope>(){

            @Override
            public boolean isAccepted(MethodScope methodScope) {
                return methodScope.getPhpKind().equals((Object)PhpKind.METHOD) && ModelElementImpl.nameKindMatch(methodScope.getName(), kind, string) && (nArray.length == 0 || (methodScope.getPhpModifiers().toBitmask() & new PhpModifiers(nArray).toBitmask()) != 0);
            }
        });
        return list2;
    }

    private Collection<? extends InterfaceScope> getCachedIfaces(String ... stringArray) {
        return this.getCachedIfaces(QuerySupport.Kind.EXACT, stringArray);
    }

    private Collection<? extends InterfaceScope> getCachedIfaces(final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(this.ifaceScopes, new ModelUtils.ElementFilter<InterfaceScope>(){

            @Override
            public boolean isAccepted(InterfaceScope interfaceScope) {
                return stringArray.length == 0 || ScopeImpl.nameKindMatch(interfaceScope.getName(), kind, stringArray);
            }
        });
    }

    private Collection<? extends TypeScope> getCachedTypes(String ... stringArray) {
        return this.getCachedTypes(QuerySupport.Kind.EXACT, stringArray);
    }

    private Collection<? extends TypeScope> getCachedTypes(QuerySupport.Kind kind, String ... stringArray) {
        return ModelUtils.merge(this.getCachedClasses(kind, stringArray), this.getCachedIfaces(kind, stringArray));
    }

    public List<? extends FunctionScope> getCachedFunctions(String ... stringArray) {
        return this.getCachedFunctions(QuerySupport.Kind.EXACT, stringArray);
    }

    public List<? extends FunctionScope> getCachedFunctions(final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(this.fncScopes, new ModelUtils.ElementFilter<FunctionScope>(){

            @Override
            public boolean isAccepted(FunctionScope functionScope) {
                return functionScope.getPhpKind().equals((Object)PhpKind.FUNCTION) && (stringArray.length == 0 || ModelElementImpl.nameKindMatch(functionScope.getName(), kind, stringArray));
            }
        });
    }

    public List<? extends ConstantElement> getCachedConstants(String ... stringArray) {
        return this.getCachedConstants(QuerySupport.Kind.EXACT, stringArray);
    }

    private List<? extends ConstantElement> getCachedConstants(final QuerySupport.Kind kind, final String ... stringArray) {
        return ModelUtils.filter(this.constantScopes, new ModelUtils.ElementFilter<ConstantElement>(){

            @Override
            public boolean isAccepted(ConstantElement constantElement) {
                return constantElement.getPhpKind().equals((Object)PhpKind.CONSTANT) && (stringArray.length == 0 || ModelElementImpl.nameKindMatch(constantElement.getName(), kind, stringArray));
            }
        });
    }
}

