/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IncludeElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Parameter;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IncludeElementImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.OccurenceImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.IncludeInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OccurenceBuilder {
    private Map<ASTNodeInfo<Scalar>, ConstantElement> constDeclarations;
    private Map<ASTNodeInfo<Scalar>, Scope> constInvocations;
    private Map<ASTNodeInfo<FunctionDeclaration>, FunctionScope> fncDeclarations;
    private Map<ASTNodeInfo<MethodDeclaration>, MethodScope> methodDeclarations;
    private Map<ASTNodeInfo<MethodInvocation>, Scope> methodInvocations;
    private Map<ASTNodeInfo<Identifier>, ClassConstantElement> classConstantDeclarations;
    private Map<ASTNodeInfo<FunctionInvocation>, Scope> fncInvocations;
    private Map<ASTNodeInfo<StaticMethodInvocation>, Scope> staticMethodInvocations;
    private Map<ASTNodeInfo<StaticFieldAccess>, Scope> staticFieldInvocations;
    private Map<ASTNodeInfo<StaticConstantAccess>, Scope> staticConstantInvocations;
    private Map<ClassDeclarationInfo, ClassScope> clasDeclarations;
    private Map<InterfaceDeclarationInfo, InterfaceScope> ifaceDeclarations;
    private HashMap<PhpDocTypeTagInfo, Scope> docTags;
    private Map<ASTNodeInfo<ClassName>, Scope> clasNames;
    private Map<ASTNodeInfo<ClassInstanceCreation>, Scope> clasInstanceCreations;
    private Map<ASTNodeInfo<Identifier>, Scope> clasIDs;
    private Map<ASTNodeInfo<Identifier>, Scope> ifaceIDs;
    private Map<ASTNodeInfo<Variable>, Scope> variables;
    private HashMap<IncludeInfo, IncludeElement> includes;
    private HashMap<SingleFieldDeclarationInfo, FieldElementImpl> fldDeclarations;
    private HashMap<ASTNodeInfo<FieldAccess>, Scope> fieldInvocations;
    private int offset;
    private ASTNodeInfo currentNodeInfo;
    private ModelElement element;

    OccurenceBuilder(ModelElement modelElement) {
        this(-1);
        this.element = modelElement;
    }

    OccurenceBuilder(int n) {
        this.offset = n;
        this.constInvocations = new HashMap<ASTNodeInfo<Scalar>, Scope>();
        this.constDeclarations = new HashMap<ASTNodeInfo<Scalar>, ConstantElement>();
        this.includes = new HashMap();
        this.fncInvocations = new HashMap<ASTNodeInfo<FunctionInvocation>, Scope>();
        this.fncDeclarations = new HashMap<ASTNodeInfo<FunctionDeclaration>, FunctionScope>();
        this.staticMethodInvocations = new HashMap<ASTNodeInfo<StaticMethodInvocation>, Scope>();
        this.methodDeclarations = new HashMap<ASTNodeInfo<MethodDeclaration>, MethodScope>();
        this.methodInvocations = new HashMap<ASTNodeInfo<MethodInvocation>, Scope>();
        this.fieldInvocations = new HashMap();
        this.staticFieldInvocations = new HashMap<ASTNodeInfo<StaticFieldAccess>, Scope>();
        this.staticConstantInvocations = new HashMap<ASTNodeInfo<StaticConstantAccess>, Scope>();
        this.clasDeclarations = new HashMap<ClassDeclarationInfo, ClassScope>();
        this.ifaceDeclarations = new HashMap<InterfaceDeclarationInfo, InterfaceScope>();
        this.clasNames = new HashMap<ASTNodeInfo<ClassName>, Scope>();
        this.clasInstanceCreations = new HashMap<ASTNodeInfo<ClassInstanceCreation>, Scope>();
        this.clasIDs = new HashMap<ASTNodeInfo<Identifier>, Scope>();
        this.ifaceIDs = new HashMap<ASTNodeInfo<Identifier>, Scope>();
        this.classConstantDeclarations = new HashMap<ASTNodeInfo<Identifier>, ClassConstantElement>();
        this.variables = new HashMap<ASTNodeInfo<Variable>, Scope>();
        this.fldDeclarations = new HashMap();
        this.docTags = new HashMap();
    }

    void prepare(FieldAccess fieldAccess, Scope scope) {
        if (this.canBePrepared(fieldAccess, scope)) {
            ASTNodeInfo<FieldAccess> aSTNodeInfo = ASTNodeInfo.create(fieldAccess);
            this.fieldInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(Include include, IncludeElementImpl includeElementImpl) {
        if (this.canBePrepared(include, includeElementImpl)) {
            IncludeInfo includeInfo = IncludeInfo.create(include);
            this.includes.put(includeInfo, includeElementImpl);
            this.setOccurenceAsCurrent(includeInfo);
        }
    }

    void prepare(MethodInvocation methodInvocation, Scope scope) {
        if (this.canBePrepared(methodInvocation, scope)) {
            ASTNodeInfo<MethodInvocation> aSTNodeInfo = ASTNodeInfo.create(methodInvocation);
            this.methodInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(SingleFieldDeclarationInfo singleFieldDeclarationInfo, FieldElementImpl fieldElementImpl) {
        SingleFieldDeclaration singleFieldDeclaration = (SingleFieldDeclaration)singleFieldDeclarationInfo.getOriginalNode();
        if (this.canBePrepared(singleFieldDeclaration, fieldElementImpl)) {
            this.fldDeclarations.put(singleFieldDeclarationInfo, fieldElementImpl);
            this.setOccurenceAsCurrent(singleFieldDeclarationInfo);
        }
    }

    void prepare(Variable variable, Scope scope) {
        if (this.canBePrepared(variable, scope)) {
            ASTNodeInfo<Variable> aSTNodeInfo = ASTNodeInfo.create(variable);
            this.variables.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(FunctionInvocation functionInvocation, Scope scope) {
        if (this.canBePrepared(functionInvocation, scope)) {
            ASTNodeInfo<FunctionInvocation> aSTNodeInfo = ASTNodeInfo.create(functionInvocation);
            this.fncInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(StaticMethodInvocation staticMethodInvocation, Scope scope) {
        if (this.canBePrepared(staticMethodInvocation, scope)) {
            ASTNodeInfo<StaticMethodInvocation> aSTNodeInfo = ASTNodeInfo.create(staticMethodInvocation);
            this.staticMethodInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(StaticFieldAccess staticFieldAccess, Scope scope) {
        if (this.canBePrepared(staticFieldAccess, scope)) {
            ASTNodeInfo<StaticFieldAccess> aSTNodeInfo = ASTNodeInfo.create(staticFieldAccess);
            this.staticFieldInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(StaticConstantAccess staticConstantAccess, Scope scope) {
        if (this.canBePrepared(staticConstantAccess, scope)) {
            ASTNodeInfo<StaticConstantAccess> aSTNodeInfo = ASTNodeInfo.create(staticConstantAccess);
            this.staticConstantInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(ClassName className, Scope scope) {
        if (this.canBePrepared(className, scope)) {
            ASTNodeInfo<ClassName> aSTNodeInfo = ASTNodeInfo.create(className);
            this.clasNames.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(ASTNodeInfo.Kind kind, Identifier identifier, Scope scope) {
        ASTNodeInfo<Identifier> aSTNodeInfo = ASTNodeInfo.create(kind, identifier);
        if (this.canBePrepared(identifier, scope)) {
            switch (aSTNodeInfo.getKind()) {
                case CLASS: {
                    this.clasIDs.put(aSTNodeInfo, scope);
                    break;
                }
                case IFACE: {
                    this.ifaceIDs.put(aSTNodeInfo, scope);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(ClassInstanceCreation classInstanceCreation, Scope scope) {
        ASTNodeInfo<ClassInstanceCreation> aSTNodeInfo = ASTNodeInfo.create(classInstanceCreation);
        if (this.canBePrepared(classInstanceCreation, scope)) {
            this.clasInstanceCreations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(ASTNodeInfo.Kind kind, Scalar scalar, Scope scope) {
        ASTNodeInfo<Scalar> aSTNodeInfo = ASTNodeInfo.create(kind, scalar);
        if (this.canBePrepared(scalar, scope)) {
            this.constInvocations.put(aSTNodeInfo, scope);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(ASTNodeInfo<Scalar> aSTNodeInfo, ConstantElement constantElement) {
        Scalar scalar = aSTNodeInfo.getOriginalNode();
        if (this.canBePrepared(scalar, constantElement)) {
            this.constDeclarations.put(aSTNodeInfo, constantElement);
            this.setOccurenceAsCurrent(aSTNodeInfo);
        }
    }

    void prepare(PHPDocTypeTag pHPDocTypeTag, Scope scope) {
        if (this.canBePrepared(pHPDocTypeTag, scope)) {
            List<? extends PhpDocTypeTagInfo> list = PhpDocTypeTagInfo.create(pHPDocTypeTag, scope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : list) {
                this.docTags.put(phpDocTypeTagInfo, scope);
                this.setOccurenceAsCurrent(phpDocTypeTagInfo);
            }
        }
    }

    void prepare(ClassDeclaration classDeclaration, ClassScope classScope) {
        if (this.canBePrepared(classDeclaration, classScope)) {
            ClassDeclarationInfo classDeclarationInfo = ClassDeclarationInfo.create(classDeclaration);
            this.clasDeclarations.put(classDeclarationInfo, classScope);
            this.prepare(ASTNodeInfo.Kind.CLASS, classDeclaration.getSuperClass(), (Scope)classScope);
            List<Identifier> list = classDeclaration.getInterfaes();
            for (Identifier identifier : list) {
                this.prepare(ASTNodeInfo.Kind.IFACE, identifier, (Scope)classScope);
            }
            this.setOccurenceAsCurrent(classDeclarationInfo);
        }
    }

    void prepare(InterfaceDeclaration interfaceDeclaration, InterfaceScope interfaceScope) {
        if (this.canBePrepared(interfaceDeclaration, interfaceScope)) {
            InterfaceDeclarationInfo interfaceDeclarationInfo = InterfaceDeclarationInfo.create(interfaceDeclaration);
            this.ifaceDeclarations.put(interfaceDeclarationInfo, interfaceScope);
            List<Identifier> list = interfaceDeclaration.getInterfaes();
            for (Identifier identifier : list) {
                this.prepare(ASTNodeInfo.Kind.IFACE, identifier, (Scope)interfaceScope);
            }
            this.setOccurenceAsCurrent(interfaceDeclarationInfo);
        }
    }

    void prepare(FunctionDeclaration functionDeclaration, FunctionScope functionScope) {
        if (this.canBePrepared(functionDeclaration, functionScope)) {
            FunctionDeclarationInfo functionDeclarationInfo = FunctionDeclarationInfo.create(functionDeclaration);
            this.fncDeclarations.put(functionDeclarationInfo, functionScope);
            this.setOccurenceAsCurrent(functionDeclarationInfo);
        }
    }

    void prepare(MethodDeclaration methodDeclaration, MethodScope methodScope) {
        if (this.canBePrepared(methodDeclaration, methodScope)) {
            MethodDeclarationInfo methodDeclarationInfo = MethodDeclarationInfo.create(methodDeclaration);
            this.methodDeclarations.put(methodDeclarationInfo, methodScope);
            this.setOccurenceAsCurrent(methodDeclarationInfo);
        }
    }

    void prepare(ClassConstantDeclarationInfo classConstantDeclarationInfo, ClassConstantElement classConstantElement) {
        if (classConstantDeclarationInfo != null && this.canBePrepared((ASTNode)classConstantDeclarationInfo.getOriginalNode(), classConstantElement)) {
            this.classConstantDeclarations.put(classConstantDeclarationInfo, classConstantElement);
            this.setOccurenceAsCurrent(classConstantDeclarationInfo);
        }
    }

    void prepare(ASTNodeInfo aSTNodeInfo) {
        this.setOccurenceAsCurrent(aSTNodeInfo);
    }

    private void buildFieldDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<SingleFieldDeclarationInfo, FieldElementImpl> entry : this.fldDeclarations.entrySet()) {
            SingleFieldDeclarationInfo singleFieldDeclarationInfo = entry.getKey();
            if (!string.equalsIgnoreCase(singleFieldDeclarationInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), singleFieldDeclarationInfo.getRange(), fileScopeImpl));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildFieldInvocations(String string, FileScopeImpl fileScopeImpl) {
        HashMap<String, List<FieldElementImpl>> hashMap = new HashMap<String, List<FieldElementImpl>>();
        for (Map.Entry<ASTNodeInfo<FieldAccess>, Scope> entry : this.fieldInvocations.entrySet()) {
            ASTNodeInfo<FieldAccess> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            Collection<? extends TypeScope> collection = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), aSTNodeInfo.getOriginalNode());
            ArrayList<ClassScope> arrayList = new ArrayList<ClassScope>();
            for (TypeScope typeScope : collection) {
                if (!(typeScope instanceof ClassScope)) continue;
                arrayList.add((ClassScope)typeScope);
            }
            ArrayList arrayList2 = new ArrayList();
            if (!arrayList.isEmpty()) {
                for (Object object : arrayList) {
                    Collection<? extends FieldElement> collection2 = CachingSupport.getInheritedFields((ClassScope)object, string, fileScopeImpl, new int[0]);
                    arrayList2.addAll(collection2);
                    if (!arrayList2.isEmpty()) continue;
                    fileScopeImpl.addOccurence(new OccurenceImpl((ModelElement)object, aSTNodeInfo.getRange(), fileScopeImpl));
                }
            } else {
                void var10_16;
                List<FieldElementImpl> list;
                List list2 = (List)hashMap.get(string);
                if (list2 == null && !(list = OccurenceBuilder.name2Fields(fileScopeImpl, string)).isEmpty()) {
                    hashMap.put(string, list);
                }
                if (!var10_16.isEmpty()) {
                    Object object;
                    object = new OccurenceImpl((Collection<? extends ModelElement>)var10_16, aSTNodeInfo.getRange(), fileScopeImpl);
                    fileScopeImpl.addOccurence((Occurence)object);
                }
            }
            if (arrayList2.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList2, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildMethodDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<MethodDeclaration>, MethodScope> entry : this.methodDeclarations.entrySet()) {
            ASTNodeInfo<MethodDeclaration> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildMethodInvocations(String string, FileScopeImpl fileScopeImpl) {
        HashMap<String, List<MethodScope>> hashMap = new HashMap<String, List<MethodScope>>();
        for (Map.Entry<ASTNodeInfo<MethodInvocation>, Scope> entry : this.methodInvocations.entrySet()) {
            ASTNodeInfo<MethodInvocation> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            Collection<? extends TypeScope> collection = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), aSTNodeInfo.getOriginalNode());
            ArrayList<? extends MethodScope> arrayList = new ArrayList<MethodScope>();
            if (!collection.isEmpty()) {
                for (TypeScope typeScope : collection) {
                    Collection<? extends MethodScope> collection2 = CachingSupport.getInheritedMethods(typeScope, string, fileScopeImpl, new int[0]);
                    arrayList.addAll(collection2);
                }
            } else {
                List list = (List)hashMap.get(string);
                if (list == null && !(list = OccurenceBuilder.name2Methods(fileScopeImpl, string, aSTNodeInfo)).isEmpty()) {
                    hashMap.put(string, list);
                }
                if (!list.isEmpty()) {
                    OccurenceImpl occurenceImpl = new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl);
                    fileScopeImpl.addOccurence(occurenceImpl);
                }
            }
            if (arrayList.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildIncludes(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<IncludeInfo, IncludeElement> entry : this.includes.entrySet()) {
            IncludeInfo includeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(includeInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), includeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildConstantInvocations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Scalar>, Scope> entry : this.constInvocations.entrySet()) {
            List<? extends ConstantElement> list;
            ASTNodeInfo<Scalar> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName()) || (list = CachingSupport.getConstants(string, fileScopeImpl)).isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildConstantDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Scalar>, ConstantElement> entry : this.constDeclarations.entrySet()) {
            ASTNodeInfo<Scalar> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildStaticConstantDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Identifier>, ClassConstantElement> entry : this.classConstantDeclarations.entrySet()) {
            ASTNodeInfo<Identifier> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildStaticMethodInvocations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<StaticMethodInvocation>, Scope> entry : this.staticMethodInvocations.entrySet()) {
            ASTNodeInfo<StaticMethodInvocation> aSTNodeInfo = entry.getKey();
            String string2 = aSTNodeInfo.getName();
            if (!string.equalsIgnoreCase(string2)) continue;
            String string3 = aSTNodeInfo.getOriginalNode().getClassName().getName();
            boolean bl = string3.equals("parent");
            ArrayList<? extends MethodScope> arrayList = new ArrayList<MethodScope>();
            Collection<? extends ClassScope> collection = OccurenceBuilder.getStaticClassName(entry.getValue(), string3);
            for (ClassScope classScope : collection) {
                Collection<? extends MethodScope> collection2 = null;
                collection2 = bl ? CachingSupport.getInheritedMethods(classScope, string2, fileScopeImpl, new int[0]) : CachingSupport.getInheritedMethods(classScope, string2, fileScopeImpl, 8);
                arrayList.addAll(collection2);
            }
            if (arrayList.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildStaticFieldInvocations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<StaticFieldAccess>, Scope> entry : this.staticFieldInvocations.entrySet()) {
            ASTNodeInfo<StaticFieldAccess> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            StaticFieldAccess staticFieldAccess = aSTNodeInfo.getOriginalNode();
            ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
            Collection<? extends ClassScope> collection = OccurenceBuilder.getStaticClassName(entry.getValue(), staticFieldAccess.getClassName().getName());
            for (ClassScope classScope : collection) {
                List<? extends FieldElement> list = ModelUtils.filter(classScope.getFields(), aSTNodeInfo.getName());
                arrayList.addAll(list);
            }
            if (arrayList.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildStaticConstantInvocations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<StaticConstantAccess>, Scope> entry : this.staticConstantInvocations.entrySet()) {
            ASTNodeInfo<StaticConstantAccess> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            StaticConstantAccess staticConstantAccess = aSTNodeInfo.getOriginalNode();
            ArrayList<? extends ClassConstantElement> arrayList = new ArrayList<ClassConstantElement>();
            Collection<? extends TypeScope> collection = OccurenceBuilder.getStaticTypeName(entry.getValue(), staticConstantAccess.getClassName().getName());
            for (TypeScope typeScope : collection) {
                Collection<? extends ClassConstantElement> collection2 = typeScope.findInheritedConstants(string);
                arrayList.addAll(collection2);
            }
            if (arrayList.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildDocTagsForClasses(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
            PhpDocTypeTagInfo phpDocTypeTagInfo = entry.getKey();
            if (!ASTNodeInfo.Kind.CLASS.equals((Object)phpDocTypeTagInfo.getKind()) || !string.equalsIgnoreCase(phpDocTypeTagInfo.getName())) continue;
            List<? extends ClassScope> list = null;
            list = CachingSupport.getClasses(phpDocTypeTagInfo.getName(), fileScopeImpl);
            if (list == null || list.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, phpDocTypeTagInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildClassInstanceCreation(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<ClassInstanceCreation>, Scope> entry : this.clasInstanceCreations.entrySet()) {
            ASTNodeInfo<ClassInstanceCreation> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            List<? extends ClassScope> list = CachingSupport.getClasses(string, fileScopeImpl);
            ArrayList<? extends MethodScope> arrayList = new ArrayList<MethodScope>();
            for (ClassScope classScope : list) {
                arrayList.addAll(CachingSupport.getInheritedMethods(classScope, "__construct", fileScopeImpl, new int[0]));
            }
            if (list.isEmpty()) continue;
            OccurenceImpl occurenceImpl = new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl);
            if (!arrayList.isEmpty()) {
                MethodScope methodScope = (MethodScope)ModelUtils.getFirst(arrayList);
                assert (methodScope != null);
                if (ModelUtils.nameKindMatch(methodScope.getTypeScope().getName(), QuerySupport.Kind.EXACT, string)) {
                    occurenceImpl.setGotoDeclaratin(methodScope);
                }
            }
            fileScopeImpl.addOccurence(occurenceImpl);
        }
    }

    private void buildClassNames(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<ClassName>, Scope> entry : this.clasNames.entrySet()) {
            List<? extends ClassScope> list;
            ASTNodeInfo<ClassName> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName()) || (list = CachingSupport.getClasses(string, fileScopeImpl)).isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildInterfaceIDs(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Identifier>, Scope> entry : this.ifaceIDs.entrySet()) {
            Collection<? extends TypeScope> collection;
            ASTNodeInfo<Identifier> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName()) || (collection = CachingSupport.getTypes(string, fileScopeImpl)).isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(collection, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildClassIDs(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Identifier>, Scope> entry : this.clasIDs.entrySet()) {
            List<? extends ClassScope> list;
            ASTNodeInfo<Identifier> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName()) || (list = CachingSupport.getClasses(string, fileScopeImpl)).isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildInterfaceDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<InterfaceDeclarationInfo, InterfaceScope> entry : this.ifaceDeclarations.entrySet()) {
            InterfaceDeclarationInfo interfaceDeclarationInfo = entry.getKey();
            if (!string.equalsIgnoreCase(interfaceDeclarationInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), interfaceDeclarationInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildClassDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ClassDeclarationInfo, ClassScope> entry : this.clasDeclarations.entrySet()) {
            ClassDeclarationInfo classDeclarationInfo = entry.getKey();
            if (!string.equalsIgnoreCase(classDeclarationInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), classDeclarationInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildFunctionDeclarations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<FunctionDeclaration>, FunctionScope> entry : this.fncDeclarations.entrySet()) {
            ASTNodeInfo<FunctionDeclaration> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(entry.getValue(), aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildFunctionInvocations(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<FunctionInvocation>, Scope> entry : this.fncInvocations.entrySet()) {
            Collection<? extends FunctionScope> collection;
            ASTNodeInfo<FunctionInvocation> aSTNodeInfo = entry.getKey();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName()) || (collection = CachingSupport.getFunctions(string, fileScopeImpl)).isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(collection, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildDocTagsForVars(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
            PhpDocTypeTagInfo phpDocTypeTagInfo = entry.getKey();
            String string2 = phpDocTypeTagInfo.getName();
            Scope scope = entry.getValue();
            if (!ASTNodeInfo.Kind.VARIABLE.equals((Object)phpDocTypeTagInfo.getKind()) || !(scope instanceof VariableScope) || !string.equalsIgnoreCase(string2)) continue;
            VariableScope variableScope = (VariableScope)entry.getValue();
            List<? extends VariableName> list = ModelUtils.filter(variableScope.getDeclaredVariables(), string2);
            if (list.isEmpty()) {
                list = ModelUtils.filter(fileScopeImpl.getDeclaredVariables(), string2);
            }
            if (list.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, phpDocTypeTagInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildDocTagsForFields(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
            PhpDocTypeTagInfo phpDocTypeTagInfo = entry.getKey();
            String string2 = phpDocTypeTagInfo.getName();
            Scope scope = entry.getValue();
            if (!ASTNodeInfo.Kind.FIELD.equals((Object)phpDocTypeTagInfo.getKind()) || !(scope instanceof ClassScope) || !string.equalsIgnoreCase(string2)) continue;
            List<? extends ClassScope> list = CachingSupport.getClasses(scope.getName(), scope);
            ArrayList<? extends FieldElement> arrayList = new ArrayList<FieldElement>();
            if (!list.isEmpty()) {
                for (ClassScope classScope : list) {
                    Collection<? extends FieldElement> collection = CachingSupport.getInheritedFields(classScope, string, fileScopeImpl, new int[0]);
                    arrayList.addAll(collection);
                    if (!arrayList.isEmpty()) continue;
                    fileScopeImpl.addOccurence(new OccurenceImpl(classScope, phpDocTypeTagInfo.getRange(), fileScopeImpl));
                }
            }
            if (arrayList.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(arrayList, phpDocTypeTagInfo.getRange(), fileScopeImpl));
        }
    }

    private void buildVariables(String string, FileScopeImpl fileScopeImpl) {
        for (Map.Entry<ASTNodeInfo<Variable>, Scope> entry : this.variables.entrySet()) {
            ASTNodeInfo<Variable> aSTNodeInfo = entry.getKey();
            String string2 = aSTNodeInfo.getName();
            if (!string.equalsIgnoreCase(aSTNodeInfo.getName())) continue;
            VariableScope variableScope = (VariableScope)entry.getValue();
            List<? extends VariableName> list = ModelUtils.filter(variableScope.getDeclaredVariables(), string2);
            if (list.isEmpty()) {
                list = ModelUtils.filter(fileScopeImpl.getDeclaredVariables(), string2);
            }
            if (list.isEmpty()) continue;
            fileScopeImpl.addOccurence(new OccurenceImpl(list, aSTNodeInfo.getRange(), fileScopeImpl));
        }
    }

    void build(FileScopeImpl fileScopeImpl) {
        ASTNodeInfo.Kind kind = this.currentNodeInfo != null ? this.currentNodeInfo.getKind() : null;
        String string = this.currentNodeInfo != null ? this.currentNodeInfo.getName() : null;
        this.currentNodeInfo = null;
        if (kind == null && this.element != null) {
            switch (this.element.getPhpKind()) {
                case CLASS: {
                    kind = ASTNodeInfo.Kind.CLASS;
                    break;
                }
                case CLASS_CONSTANT: {
                    kind = ASTNodeInfo.Kind.CLASS_CONSTANT;
                    break;
                }
                case CONSTANT: {
                    kind = ASTNodeInfo.Kind.CONSTANT;
                    break;
                }
                case FIELD: {
                    kind = ASTNodeInfo.Kind.FIELD;
                    break;
                }
                case FUNCTION: {
                    kind = ASTNodeInfo.Kind.FUNCTION;
                    break;
                }
                case IFACE: {
                    kind = ASTNodeInfo.Kind.IFACE;
                    break;
                }
                case INCLUDE: {
                    kind = ASTNodeInfo.Kind.INCLUDE;
                    break;
                }
                case METHOD: {
                    boolean bl = this.element.getPhpModifiers().isStatic();
                    kind = bl ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
                    break;
                }
                case VARIABLE: {
                    kind = ASTNodeInfo.Kind.VARIABLE;
                }
            }
        }
        if (string == null && this.element != null) {
            string = this.element.getName();
        }
        if (string != null && string.trim().length() > 0 && kind != null) {
            switch (kind) {
                case FUNCTION: {
                    this.buildFunctionInvocations(string, fileScopeImpl);
                    this.buildFunctionDeclarations(string, fileScopeImpl);
                    break;
                }
                case VARIABLE: {
                    this.buildVariables(string, fileScopeImpl);
                    this.buildDocTagsForVars(string, fileScopeImpl);
                    break;
                }
                case STATIC_METHOD: {
                    this.buildStaticMethodInvocations(string, fileScopeImpl);
                    this.buildMethodDeclarations(string, fileScopeImpl);
                    break;
                }
                case FIELD: 
                case STATIC_FIELD: {
                    this.buildFieldDeclarations(string, fileScopeImpl);
                    this.buildFieldInvocations(string, fileScopeImpl);
                    this.buildStaticFieldInvocations(string, fileScopeImpl);
                    this.buildDocTagsForFields(string, fileScopeImpl);
                    break;
                }
                case CONSTANT: {
                    this.buildConstantInvocations(string, fileScopeImpl);
                    this.buildConstantDeclarations(string, fileScopeImpl);
                    break;
                }
                case CLASS_CONSTANT: 
                case STATIC_CLASS_CONSTANT: {
                    this.buildStaticConstantInvocations(string, fileScopeImpl);
                    this.buildStaticConstantDeclarations(string, fileScopeImpl);
                    break;
                }
                case CLASS: 
                case IFACE: 
                case CLASS_INSTANCE_CREATION: {
                    this.buildClassNames(string, fileScopeImpl);
                    this.buildClassIDs(string, fileScopeImpl);
                    this.buildClassDeclarations(string, fileScopeImpl);
                    this.buildDocTagsForClasses(string, fileScopeImpl);
                    this.buildClassInstanceCreation(string, fileScopeImpl);
                    this.buildInterfaceIDs(string, fileScopeImpl);
                    this.buildInterfaceDeclarations(string, fileScopeImpl);
                    break;
                }
                case METHOD: {
                    this.buildMethodInvocations(string, fileScopeImpl);
                    this.buildMethodDeclarations(string, fileScopeImpl);
                    break;
                }
                case INCLUDE: {
                    this.buildIncludes(string, fileScopeImpl);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private boolean canBePrepared(ASTNode aSTNode, ModelElement modelElement) {
        return (this.getOffset() >= 0 || this.element != null) && modelElement != null && aSTNode != null;
    }

    private void setOccurenceAsCurrent(ASTNodeInfo aSTNodeInfo) {
        OffsetRange offsetRange;
        if (this.element == null && (offsetRange = aSTNodeInfo.getRange()).containsInclusive(this.getOffset())) {
            this.currentNodeInfo = aSTNodeInfo;
        }
    }

    private static Collection<? extends TypeScope> getClassName(VariableScope variableScope, VariableBase variableBase) {
        String string = VariousUtils.extractTypeFroVariableBase(variableBase, Collections.<String, AssignmentImpl>emptyMap());
        FileScope fileScope = ModelUtils.getFileScope(variableScope);
        return VariousUtils.getType(fileScope, variableScope, string, variableBase.getStartOffset(), true);
    }

    private static Collection<? extends ClassScope> getStaticClassName(Scope scope, String string) {
        if (scope instanceof MethodScope) {
            MethodScope methodScope = (MethodScope)scope;
            ClassScope classScope = (ClassScope)methodScope.getInScope();
            if ("self".equals(string)) {
                return Collections.singletonList(classScope);
            }
            if ("parent".equals(string)) {
                return classScope.getSuperClasses();
            }
        }
        return CachingSupport.getClasses(string, scope);
    }

    private static Collection<? extends TypeScope> getStaticTypeName(Scope scope, String string) {
        if (scope instanceof MethodScope) {
            MethodScope methodScope = (MethodScope)scope;
            ClassScope classScope = (ClassScope)methodScope.getInScope();
            if ("self".equals(string)) {
                return Collections.singletonList(classScope);
            }
            if ("parent".equals(string)) {
                return classScope.getSuperClasses();
            }
        }
        return CachingSupport.getTypes(string, scope);
    }

    private static List<MethodScope> methods4TypeNames(FileScopeImpl fileScopeImpl, Set<String> set, String string) {
        ArrayList<? extends ClassScope> arrayList2 = new ArrayList<ClassScope>();
        for (String arrayList3 : set) {
            arrayList2.addAll(CachingSupport.getClasses(arrayList3, fileScopeImpl));
        }
        HashSet hashSet = new HashSet();
        for (ClassScope classScope : arrayList2) {
            hashSet.addAll((List)CachingSupport.getInheritedMethods(classScope, string, fileScopeImpl, new int[0]));
        }
        ArrayList<MethodScope> arrayList = new ArrayList<MethodScope>(hashSet);
        return arrayList;
    }

    private static List<FieldElementImpl> flds4TypeNames(FileScopeImpl fileScopeImpl, Set<String> set, String string) {
        ArrayList<? extends ClassScope> arrayList2 = new ArrayList<ClassScope>();
        for (String arrayList3 : set) {
            arrayList2.addAll(CachingSupport.getClasses(arrayList3, fileScopeImpl));
        }
        HashSet hashSet = new HashSet();
        for (ClassScope classScope : arrayList2) {
            hashSet.addAll((List)CachingSupport.getInheritedFields(classScope, string, fileScopeImpl, -1));
        }
        ArrayList<FieldElementImpl> arrayList = new ArrayList<FieldElementImpl>(hashSet);
        return arrayList;
    }

    private static List<MethodScope> name2Methods(FileScopeImpl fileScopeImpl, String string, ASTNodeInfo<MethodInvocation> aSTNodeInfo) {
        IndexScope indexScope = fileScopeImpl.getIndexScope();
        PHPIndex pHPIndex = indexScope.getIndex();
        Set<String> set = pHPIndex.typeNamesForIdentifier(string, null, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        List<MethodScope> list = Collections.emptyList();
        FunctionInvocation functionInvocation = aSTNodeInfo.getOriginalNode().getMethod();
        int n = functionInvocation.getParameters().size();
        if (set.size() > 0) {
            List<MethodScope> list2 = OccurenceBuilder.methods4TypeNames(fileScopeImpl, set, string);
            list = new ArrayList<MethodScope>();
            for (MethodScope methodScope : list2) {
                List<? extends Parameter> list3 = methodScope.getParameters();
                if (!ModelElementImpl.nameKindMatch(string, QuerySupport.Kind.EXACT, methodScope.getName()) || n < OccurenceBuilder.numberOfMandatoryParams(list3) || n > list3.size()) continue;
                list.add(methodScope);
            }
        }
        return list;
    }

    private static List<FieldElementImpl> name2Fields(FileScopeImpl fileScopeImpl, String string) {
        IndexScope indexScope = fileScopeImpl.getIndexScope();
        PHPIndex pHPIndex = indexScope.getIndex();
        Set<String> set = pHPIndex.typeNamesForIdentifier(string.startsWith("$") ? string.substring(1) : string, null, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        List<FieldElementImpl> list = Collections.emptyList();
        if (set.size() > 0) {
            list = new ArrayList<FieldElementImpl>();
            List<FieldElementImpl> list2 = OccurenceBuilder.flds4TypeNames(fileScopeImpl, set, string);
            for (FieldElementImpl fieldElementImpl : list2) {
                if (!ModelElementImpl.nameKindMatch(string, QuerySupport.Kind.EXACT, fieldElementImpl.getName())) continue;
                list.add(fieldElementImpl);
            }
        }
        return list;
    }

    int getOffset() {
        return this.offset;
    }

    private static int numberOfMandatoryParams(List<? extends Parameter> list) {
        int n = 0;
        for (Parameter parameter : list) {
            if (!parameter.isMandatory()) continue;
            ++n;
        }
        return n;
    }
}

