/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DeclarationFinderImpl
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, int n) {
        return DeclarationFinderImpl.findDeclarationImpl(parserResult, n);
    }

    public OffsetRange getReferenceSpan(Document document, final int n) {
        OffsetRange[] offsetRangeArray2;
        LinkedList linkedList = TokenHierarchy.get((Document)document).embeddedTokenSequences(n, false);
        boolean bl = false;
        linkedList = new LinkedList(linkedList);
        Collections.reverse(linkedList);
        for (final OffsetRange[] offsetRangeArray2 : linkedList) {
            if (offsetRangeArray2.language() != PHPTokenId.language()) continue;
            Token token = offsetRangeArray2.token();
            if (token.id() == PHPTokenId.PHP_VARIABLE) {
                return new OffsetRange(offsetRangeArray2.offset() + 1, offsetRangeArray2.offset() + token.length());
            }
            if (token.id() == PHPTokenId.PHP_STRING) {
                return new OffsetRange(offsetRangeArray2.offset(), offsetRangeArray2.offset() + token.length());
            }
            if (token.id() != PHPTokenId.PHPDOC_COMMENT && token.id() != PHPTokenId.PHP_COMMENT) continue;
            bl = true;
            break;
        }
        FileObject fileObject = NavUtils.getFile(document);
        offsetRangeArray2 = new OffsetRange[1];
        if (!bl) {
            if (fileObject != null) {
                try {
                    ParserManager.parse(Collections.singleton(Source.create((Document)document)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                            List<ASTNode> list = NavUtils.underCaret(parserResult, n);
                            if (list.size() == 0) {
                                return;
                            }
                            list = new LinkedList<ASTNode>(list);
                            Collections.reverse(list);
                            Scalar scalar = null;
                            for (ASTNode aSTNode : list) {
                                Object object;
                                if (aSTNode instanceof Include) {
                                    object = NavUtils.resolveInclude(parserResult, (Include)aSTNode);
                                    if (object == null || scalar == null) continue;
                                    offsetRangeArray2[0] = new OffsetRange(scalar.getStartOffset() + 1, scalar.getEndOffset() - 1);
                                    break;
                                }
                                if (aSTNode instanceof FunctionInvocation) {
                                    object = (FunctionInvocation)aSTNode;
                                    String string = CodeUtils.extractFunctionName((FunctionInvocation)object);
                                    if (string == null || !string.equals("constant")) continue;
                                    offsetRangeArray2[0] = new OffsetRange(scalar.getStartOffset() + 1, scalar.getEndOffset() - 1);
                                    continue;
                                }
                                if (!(aSTNode instanceof Scalar)) continue;
                                scalar = (Scalar)aSTNode;
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            } else {
                try {
                    ParserManager.parse(Collections.singleton(Source.create((Document)document)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            block9: {
                                Object object;
                                Comment aSTNode2;
                                block8: {
                                    ParserResult parserResult = (ParserResult)resultIterator.getParserResult();
                                    Program program = Utils.getRoot(parserResult);
                                    aSTNode2 = null;
                                    for (Comment aSTNode3 : program.getComments()) {
                                        if (aSTNode3.getStartOffset() < n && n < aSTNode3.getEndOffset()) {
                                            aSTNode2 = aSTNode3;
                                            break;
                                        }
                                        if (n >= aSTNode3.getStartOffset()) continue;
                                        break;
                                    }
                                    if (aSTNode2 == null || !(aSTNode2 instanceof PHPDocBlock)) break block8;
                                    object = (PHPDocBlock)aSTNode2;
                                    ASTNode[] aSTNodeArray = Utils.getNodeHierarchyAtOffset((ASTNode)object, n);
                                    PHPDocNode pHPDocNode = null;
                                    if (aSTNodeArray.length <= 0) break block9;
                                    if (aSTNodeArray[0] instanceof PHPDocTypeTag) {
                                        for (PHPDocNode pHPDocNode2 : ((PHPDocTypeTag)aSTNodeArray[0]).getTypes()) {
                                            if (pHPDocNode2.getStartOffset() >= n || n >= pHPDocNode2.getEndOffset()) continue;
                                            pHPDocNode = pHPDocNode2;
                                            break;
                                        }
                                        if (pHPDocNode != null && !PHPDocTypeTag.ORDINAL_TYPES.contains(pHPDocNode.getValue().toUpperCase())) {
                                            offsetRangeArray2[0] = new OffsetRange(pHPDocNode.getStartOffset(), pHPDocNode.getEndOffset());
                                        }
                                    }
                                    if (aSTNodeArray[0] instanceof PHPDocVarTypeTag && (pHPDocNode = ((PHPDocVarTypeTag)aSTNodeArray[0]).getVariable()) != null && pHPDocNode.getStartOffset() < n && n < pHPDocNode.getEndOffset()) {
                                        offsetRangeArray2[0] = new OffsetRange(pHPDocNode.getStartOffset(), pHPDocNode.getEndOffset());
                                    }
                                    break block9;
                                }
                                if (aSTNode2 instanceof PHPVarComment) {
                                    object = (PHPVarComment)aSTNode2;
                                    PHPDocVarTypeTag pHPDocVarTypeTag = ((PHPVarComment)object).getVariable();
                                    ArrayList<PHPDocNode> arrayList = new ArrayList<PHPDocNode>(pHPDocVarTypeTag.getTypes());
                                    arrayList.add(pHPDocVarTypeTag.getVariable());
                                    for (ASTNode aSTNode : arrayList) {
                                        if (aSTNode == null || aSTNode.getStartOffset() >= n || n >= aSTNode.getEndOffset()) continue;
                                        offsetRangeArray2[0] = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
                                        break;
                                    }
                                }
                            }
                        }
                    });
                }
                catch (ParseException parseException) {
                    Exceptions.printStackTrace((Throwable)parseException);
                }
            }
            if (offsetRangeArray2[0] != null) {
                return offsetRangeArray2[0];
            }
        }
        return OffsetRange.NONE;
    }

    public static DeclarationFinder.DeclarationLocation findDeclarationImpl(ParserResult parserResult, int n) {
        DeclarationFinder.DeclarationLocation declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
        OccurencesSupport occurencesSupport = ModelFactory.getModel(parserResult).getOccurencesSupport(n);
        Occurence occurence = occurencesSupport.getOccurence();
        if (occurence != null) {
            ModelElement modelElement = occurence.gotoDeclaratin();
            FileObject fileObject = modelElement.getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            declarationLocation = new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement.getPHPElement());
            if (parserResult.getSnapshot().getSource().getFileObject() == modelElement.getFileObject()) {
                return declarationLocation;
            }
            Collection<? extends ModelElement> collection = occurence.getAllDeclarations();
            if (collection.size() > 1) {
                declarationLocation = DeclarationFinder.DeclarationLocation.NONE;
                for (ModelElement modelElement2 : collection) {
                    FileObject fileObject2 = modelElement2.getFileObject();
                    if (fileObject2 == null) continue;
                    DeclarationFinder.DeclarationLocation declarationLocation2 = new DeclarationFinder.DeclarationLocation(fileObject2, modelElement2.getOffset(), (ElementHandle)modelElement2.getPHPElement());
                    AlternativeLocationImpl alternativeLocationImpl = new AlternativeLocationImpl(modelElement2, declarationLocation2);
                    if (declarationLocation == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation = alternativeLocationImpl.getLocation();
                    }
                    declarationLocation.addAlternative((DeclarationFinder.AlternativeLocation)alternativeLocationImpl);
                }
                return declarationLocation;
            }
        }
        return declarationLocation;
    }

    private static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private ModelElement modelElement;
        private DeclarationFinder.DeclarationLocation declaration;

        AlternativeLocationImpl(ModelElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            this.modelElement = modelElement;
            this.declaration = declarationLocation;
        }

        public ElementHandle getElement() {
            return this.modelElement.getPHPElement();
        }

        public String getDisplayHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            ElementKind elementKind = this.modelElement.getPHPElement().getKind();
            if (elementKind != null) {
                htmlFormatter.name(elementKind, true);
                htmlFormatter.appendText(this.modelElement.getName());
                htmlFormatter.name(elementKind, false);
            } else {
                htmlFormatter.appendText(this.modelElement.getName());
            }
            if (this.declaration.getFileObject() != null) {
                htmlFormatter.appendText(" in ");
                htmlFormatter.appendText(FileUtil.getFileDisplayName((FileObject)this.declaration.getFileObject()));
            }
            return htmlFormatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.declaration;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternativeLocation) {
            AlternativeLocationImpl alternativeLocationImpl = (AlternativeLocationImpl)alternativeLocation;
            return this.modelElement.getName().compareTo(alternativeLocationImpl.modelElement.getName());
        }
    }
}

