/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.PHPVarComment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticAnalysis
extends SemanticAnalyzer {
    public static final EnumSet<ColoringAttributes> UNUSED_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_FIELD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.FIELD, ColoringAttributes.STATIC);
    public static final EnumSet<ColoringAttributes> UNUSED_METHOD_SET = EnumSet.of(ColoringAttributes.UNUSED, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD);
    public static final EnumSet<ColoringAttributes> UNUSED_STATIC_METHOD_SET = EnumSet.of(ColoringAttributes.STATIC, ColoringAttributes.METHOD, ColoringAttributes.UNUSED);
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights = null;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        PHPParseResult pHPParseResult = (PHPParseResult)result;
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        if (pHPParseResult.getProgram() != null) {
            pHPParseResult.getProgram().accept(new SemanticHighlightVisitor(hashMap, pHPParseResult.getSnapshot()));
            this.semanticHighlights = hashMap.size() > 0 ? hashMap : null;
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SemanticHighlightVisitor
    extends DefaultVisitor {
        Map<OffsetRange, Set<ColoringAttributes>> highlights;
        private final Map<String, IdentifierColoring> privateFieldsUsed;
        private final Map<String, IdentifierColoring> privateMethod;
        private List<Block> needToScan = new ArrayList<Block>();
        private final Snapshot snapshot;

        public SemanticHighlightVisitor(Map<OffsetRange, Set<ColoringAttributes>> map, Snapshot snapshot) {
            this.highlights = map;
            this.privateFieldsUsed = new HashMap<String, IdentifierColoring>();
            this.privateMethod = new HashMap<String, IdentifierColoring>();
            this.snapshot = snapshot;
        }

        private void addOffsetRange(ASTNode aSTNode, Set<ColoringAttributes> set) {
            int n = this.snapshot.getOriginalOffset(aSTNode.getStartOffset());
            if (n > -1) {
                int n2 = n + aSTNode.getEndOffset() - aSTNode.getStartOffset();
                this.highlights.put(new OffsetRange(n, n2), set);
            }
        }

        @Override
        public void visit(Program program) {
            this.scan(program.getStatements());
            for (Comment comment : program.getComments()) {
                if (comment.getCommentType() != Comment.Type.TYPE_VARTYPE) continue;
                this.scan(comment);
            }
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier identifier = classDeclaration.getName();
            this.addOffsetRange(identifier, ColoringAttributes.CLASS_SET);
            this.needToScan = new ArrayList<Block>();
            if (classDeclaration.getBody() != null) {
                classDeclaration.getBody().accept(this);
                for (Block object : this.needToScan) {
                    object.accept(this);
                }
                for (IdentifierColoring identifierColoring : this.privateFieldsUsed.values()) {
                    if (identifierColoring.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(identifierColoring.identifier, UNUSED_STATIC_FIELD_SET);
                        continue;
                    }
                    this.addOffsetRange(identifierColoring.identifier, UNUSED_FIELD_SET);
                }
                for (IdentifierColoring identifierColoring : this.privateMethod.values()) {
                    if (identifierColoring.coloring.contains(ColoringAttributes.STATIC)) {
                        this.addOffsetRange(identifierColoring.identifier, UNUSED_STATIC_METHOD_SET);
                        continue;
                    }
                    this.addOffsetRange(identifierColoring.identifier, UNUSED_METHOD_SET);
                }
            }
        }

        @Override
        public void visit(MethodDeclaration methodDeclaration) {
            Block block;
            boolean bl = BodyDeclaration.Modifier.isPrivate(methodDeclaration.getModifier());
            EnumSet<ColoringAttributes> enumSet = ColoringAttributes.METHOD_SET;
            if (BodyDeclaration.Modifier.isStatic(methodDeclaration.getModifier())) {
                enumSet = STATIC_METHOD_SET;
            }
            Identifier identifier = methodDeclaration.getFunction().getFunctionName();
            String string = identifier.getName();
            if (bl && string != null && !string.startsWith("__")) {
                this.privateMethod.put(identifier.getName(), new IdentifierColoring(identifier, enumSet));
            } else {
                this.addOffsetRange(identifier, enumSet);
            }
            if (!BodyDeclaration.Modifier.isAbstract(methodDeclaration.getModifier()) && (block = methodDeclaration.getFunction().getBody()) != null) {
                this.needToScan.add(block);
            }
        }

        @Override
        public void visit(MethodInvocation methodInvocation) {
            Object object;
            Identifier identifier = null;
            if (methodInvocation.getMethod().getFunctionName().getName() instanceof Variable) {
                object = (Variable)methodInvocation.getMethod().getFunctionName().getName();
                if (((Variable)object).getName() instanceof Identifier) {
                    identifier = (Identifier)((Variable)object).getName();
                }
            } else if (methodInvocation.getMethod().getFunctionName().getName() instanceof Identifier) {
                identifier = (Identifier)methodInvocation.getMethod().getFunctionName().getName();
            }
            if (identifier != null && (object = this.privateMethod.remove(identifier.getName())) != null) {
                this.addOffsetRange(((IdentifierColoring)object).identifier, ((IdentifierColoring)object).coloring);
            }
            super.visit(methodInvocation);
        }

        @Override
        public void visit(InterfaceDeclaration interfaceDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            Identifier identifier = interfaceDeclaration.getName();
            this.addOffsetRange(identifier, ColoringAttributes.CLASS_SET);
            interfaceDeclaration.getBody().accept(this);
        }

        @Override
        public void visit(FieldsDeclaration fieldsDeclaration) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            boolean bl = BodyDeclaration.Modifier.isPrivate(fieldsDeclaration.getModifier());
            EnumSet enumSet = ColoringAttributes.FIELD_SET;
            if (BodyDeclaration.Modifier.isStatic(fieldsDeclaration.getModifier())) {
                enumSet = ColoringAttributes.STATIC_FIELD_SET;
            }
            Variable[] variableArray = fieldsDeclaration.getVariableNames();
            for (int i = 0; i < variableArray.length; ++i) {
                Variable variable = variableArray[i];
                if (!bl) {
                    this.addOffsetRange(variable.getName(), enumSet);
                    continue;
                }
                if (!(variable.getName() instanceof Identifier)) continue;
                Identifier identifier = (Identifier)variable.getName();
                this.privateFieldsUsed.put(identifier.getName(), new IdentifierColoring(identifier, enumSet));
            }
        }

        @Override
        public void visit(FieldAccess fieldAccess) {
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            if (!fieldAccess.getField().isDollared()) {
                Expression expression = fieldAccess.getField().getName();
                new FieldAccessVisitor(ColoringAttributes.FIELD_SET).scan(expression);
            }
            super.scan(fieldAccess.getDispatcher());
        }

        @Override
        public void visit(StaticMethodInvocation staticMethodInvocation) {
            String string;
            IdentifierColoring identifierColoring;
            if (SemanticAnalysis.this.isCancelled()) {
                return;
            }
            FunctionName functionName = staticMethodInvocation.getMethod().getFunctionName();
            if (functionName.getName() instanceof Identifier && (identifierColoring = this.privateMethod.remove(string = ((Identifier)functionName.getName()).getName())) != null) {
                this.addOffsetRange(identifierColoring.identifier, identifierColoring.coloring);
                return;
            }
            this.addOffsetRange(functionName, ColoringAttributes.STATIC_SET);
        }

        @Override
        public void visit(PHPVarComment pHPVarComment) {
            int n = pHPVarComment.getVariable().getStartOffset();
            int n2 = n + 4;
            int n3 = this.snapshot.getOriginalOffset(n);
            if (n3 > -1) {
                int n4 = n3 + n2 - n;
                this.highlights.put(new OffsetRange(n3, n4), ColoringAttributes.CUSTOM1_SET);
            }
        }

        @Override
        public void visit(StaticFieldAccess staticFieldAccess) {
            Expression expression = staticFieldAccess.getField().getName();
            if (expression instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)expression;
                expression = arrayAccess.getName();
            }
            new FieldAccessVisitor(ColoringAttributes.STATIC_FIELD_SET).scan(expression);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class FieldAccessVisitor
        extends DefaultVisitor {
            private final Set<ColoringAttributes> coloring;

            public FieldAccessVisitor(Set<ColoringAttributes> set) {
                this.coloring = set;
            }

            @Override
            public void visit(Identifier identifier) {
                IdentifierColoring identifierColoring = (IdentifierColoring)SemanticHighlightVisitor.this.privateFieldsUsed.remove(identifier.getName());
                if (identifierColoring != null) {
                    SemanticHighlightVisitor.this.addOffsetRange(identifierColoring.identifier, identifierColoring.coloring);
                }
                SemanticHighlightVisitor.this.addOffsetRange(identifier, this.coloring);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class IdentifierColoring {
            public Identifier identifier;
            public Set<ColoringAttributes> coloring;

            public IdentifierColoring(Identifier identifier, Set<ColoringAttributes> set) {
                this.identifier = identifier;
                this.coloring = set;
            }
        }
    }
}

