/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletion;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionContext;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.php.editor.sql.DatabaseConnectionSupport;
import org.netbeans.modules.php.editor.sql.PHPSQLStatement;
import org.netbeans.modules.php.editor.sql.SelectConnectionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.text.NbDocument;

public class PHPSQLCompletion
implements CompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(PHPSQLCompletion.class.getName());
    private static final Boolean NO_COMPLETION = Boolean.getBoolean("netbeans.php.nosqlcompletion");

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        return 0;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Query() {
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            this.doQuery(completionResultSet, document, n);
            completionResultSet.finish();
        }

        private void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            if (NO_COMPLETION.booleanValue()) {
                return;
            }
            PHPSQLStatement pHPSQLStatement = PHPSQLStatement.computeSQLStatement(document, n);
            if (pHPSQLStatement == null) {
                return;
            }
            SQLCompletionContext sQLCompletionContext = SQLCompletionContext.empty();
            if (!SQLCompletion.canComplete((SQLCompletionContext)(sQLCompletionContext = sQLCompletionContext.setStatement((CharSequence)pHPSQLStatement.getStatement())))) {
                return;
            }
            sQLCompletionContext = sQLCompletionContext.setOffset(pHPSQLStatement.sourceToGeneratedPos(n));
            DatabaseConnection databaseConnection = DatabaseConnectionSupport.getDatabaseConnection(document, true);
            if (databaseConnection == null) {
                completionResultSet.addItem((CompletionItem)new SelectConnectionItem(document));
            } else {
                sQLCompletionContext = sQLCompletionContext.setDatabaseConnection(databaseConnection);
                SQLCompletion sQLCompletion = SQLCompletion.create((SQLCompletionContext)sQLCompletionContext);
                SQLCompletionResultSet sQLCompletionResultSet = SQLCompletionResultSet.create();
                sQLCompletion.query(sQLCompletionResultSet, (SubstitutionHandler)new SQLSubstitutionHandler(pHPSQLStatement));
                completionResultSet.addAllItems((Collection)sQLCompletionResultSet.getItems());
                completionResultSet.setAnchorOffset(pHPSQLStatement.generatedToSourcePos(sQLCompletionResultSet.getAnchorOffset()));
            }
        }

        static class SQLSubstitutionHandler
        implements SubstitutionHandler {
            final PHPSQLStatement statement;

            public SQLSubstitutionHandler(PHPSQLStatement pHPSQLStatement) {
                this.statement = pHPSQLStatement;
            }

            public void substituteText(JTextComponent jTextComponent, int n, final String string) {
                final int n2 = jTextComponent.getSelectionEnd();
                final int n3 = this.statement.generatedToSourcePos(n);
                final StyledDocument styledDocument = (StyledDocument)jTextComponent.getDocument();
                try {
                    NbDocument.runAtomicAsUser((StyledDocument)styledDocument, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                int n = n3;
                                styledDocument.remove(n, n2 - n);
                                styledDocument.insertString(n, string, null);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

