/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.verification.ModelRule;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementAbstractMethods
extends ModelRule {
    Map<Integer, CachedFixInfo> cahcedFixedInfo = new HashMap<Integer, CachedFixInfo>();
    long diggest;

    public String getId() {
        return "Implement.Abstract.Methods";
    }

    public String getDescription() {
        return NbBundle.getMessage(ImplementAbstractMethods.class, (String)"ImplementAbstractMethodsDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementAbstractMethods.class, (String)"ImplementAbstractMethodsDispName");
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    public boolean showInTasklist() {
        return false;
    }

    @Override
    void check(FileScope fileScope, RuleContext ruleContext, List<Hint> list) {
        Collection<? extends TypeScope> collection = fileScope.getDeclaredTypes();
        long l = this.computeDigest(collection);
        if (l != this.diggest || !this.cahcedFixedInfo.isEmpty()) {
            this.fillCachedFixedInfo(collection, l != this.diggest);
        }
        this.diggest = l;
        for (CachedFixInfo cachedFixInfo : this.cahcedFixedInfo.values()) {
            list.add(new Hint((Rule)this, this.getDisplayName(), ruleContext.parserResult.getSnapshot().getSource().getFileObject(), cachedFixInfo.classNameRange, Collections.singletonList(new Fix(ruleContext, cachedFixInfo)), 500));
        }
    }

    private long computeDigest(Collection<? extends TypeScope> collection) {
        CRC32 cRC32 = new CRC32();
        for (TypeScope typeScope : collection) {
            cRC32.update(String.valueOf(typeScope.hashCode()).getBytes());
            cRC32.update(String.valueOf(typeScope.getPhpModifiers().hashCode()).getBytes());
            Collection<? extends MethodScope> collection2 = typeScope.getDeclaredMethods();
            for (MethodScope methodScope : collection2) {
                cRC32.update(String.valueOf(methodScope.hashCode()).getBytes());
            }
        }
        return cRC32.getValue();
    }

    private void fillCachedFixedInfo(Collection<? extends TypeScope> collection, boolean bl) {
        if (!bl && !this.cahcedFixedInfo.isEmpty()) {
            for (TypeScope typeScope : collection) {
                CachedFixInfo cachedFixInfo = this.cahcedFixedInfo.get(typeScope.hashCode());
                if (cachedFixInfo == null) continue;
                cachedFixInfo.setClassScope(typeScope);
            }
        } else {
            this.cahcedFixedInfo.clear();
            for (TypeScope typeScope : collection) {
                Object object;
                Object object2;
                LinkedHashSet<String> linkedHashSet;
                LinkedHashSet<MethodScope> linkedHashSet2 = new LinkedHashSet<MethodScope>();
                ClassScope classScope = typeScope instanceof ClassScope ? ModelUtils.getFirst(((ClassScope)typeScope).getSuperClasses()) : null;
                Collection<? extends InterfaceScope> collection2 = typeScope.getSuperInterfaces();
                if ((classScope != null || collection2.size() > 0) && !typeScope.getPhpModifiers().isAbstract() && typeScope instanceof ClassScope) {
                    MethodScope methodScope2;
                    linkedHashSet = new HashSet();
                    object2 = typeScope.getMethods();
                    Collection<? extends MethodScope> collection3 = typeScope.getDeclaredMethods();
                    object = new HashSet();
                    for (MethodScope methodScope2 : collection3) {
                        object.add(methodScope2.getName());
                    }
                    Iterator<MethodScope> iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        methodScope2 = iterator.next();
                        Scope scope = methodScope2.getInScope();
                        if (scope instanceof InterfaceScope || methodScope2.getPhpModifiers().isAbstract()) {
                            if (object.contains(methodScope2.getName())) continue;
                            linkedHashSet2.add(methodScope2);
                            continue;
                        }
                        linkedHashSet.add(methodScope2.getName());
                    }
                    iterator = linkedHashSet2.iterator();
                    while (iterator.hasNext()) {
                        methodScope2 = iterator.next();
                        if (!linkedHashSet.contains(methodScope2.getName())) continue;
                        iterator.remove();
                    }
                }
                if (linkedHashSet2.isEmpty()) continue;
                linkedHashSet = new LinkedHashSet();
                for (MethodScope methodScope : linkedHashSet2) {
                    object = methodScope.getClassSkeleton();
                    object = ((String)object).replace("abstract ", "");
                    linkedHashSet.add((String)object);
                }
                object2 = new CachedFixInfo(typeScope, linkedHashSet);
                this.cahcedFixedInfo.put(typeScope.hashCode(), (CachedFixInfo)object2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedFixInfo {
        private LinkedHashSet<String> methodSkeletons;
        private int offset;
        private OffsetRange classNameRange;

        CachedFixInfo(TypeScope typeScope, LinkedHashSet<String> linkedHashSet) {
            this.methodSkeletons = linkedHashSet;
            this.setClassScope(typeScope);
        }

        void setClassScope(TypeScope typeScope) {
            this.classNameRange = typeScope.getNameRange();
            this.offset = typeScope.getBlockRange().getEnd() - 1;
        }
    }

    private class Fix
    implements HintFix {
        private RuleContext context;
        private final CachedFixInfo fixInfo;

        Fix(RuleContext ruleContext, CachedFixInfo cachedFixInfo) {
            this.context = ruleContext;
            this.fixInfo = cachedFixInfo;
        }

        public String getDescription() {
            return ImplementAbstractMethods.this.getDescription();
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        EditList getEditList() throws Exception {
            BaseDocument baseDocument = this.context.doc;
            EditList editList = new EditList(baseDocument);
            for (String string : this.fixInfo.methodSkeletons) {
                editList.replace(this.fixInfo.offset, 0, string, true, 0);
            }
            return editList;
        }
    }
}

