/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.groovy.support.debug.DebugUtils;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GroovyLineBreakpoint
extends Breakpoint {
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 2;
    private String printText;
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private LineBreakpoint javalb;

    public GroovyLineBreakpoint() {
    }

    public GroovyLineBreakpoint(String string, int n) {
        this.url = string;
        this.lineNumber = n;
        String string2 = NbBundle.getMessage(GroovyLineBreakpoint.class, (String)"CTL_Default_Print_Text");
        this.printText = Utilities.replaceString((String)string2, (String)"{jspName}", (String)DebugUtils.getJspName(string));
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        String string3 = DebugUtils.getClassFilter(string);
        this.javalb = LineBreakpoint.create((String)string, (int)n);
        this.javalb.setStratum("Groovy");
        this.javalb.setSourceName(DebugUtils.getJspName(string));
        this.javalb.setSourcePath(DebugUtils.getJspPath(string));
        this.javalb.setPreferredClassName(string3);
        this.javalb.setHidden(true);
        this.javalb.setPrintText(this.printText);
        debuggerManager.addBreakpoint((Breakpoint)this.javalb);
        this.setURL(string);
        this.setLineNumber(n);
    }

    public static GroovyLineBreakpoint create(String string, int n) {
        return new GroovyLineBreakpoint(string, n);
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        if (n == this.suspend) {
            return;
        }
        int n2 = this.suspend;
        this.suspend = n;
        if (this.javalb != null) {
            this.javalb.setSuspend(n);
        }
        this.firePropertyChange(PROP_SUSPEND, n2, n);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        if (bl == this.hidden) {
            return;
        }
        boolean bl2 = this.hidden;
        this.hidden = bl;
        this.firePropertyChange(PROP_HIDDEN, bl2, bl);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (this.printText == string) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        if (this.javalb != null) {
            this.javalb.setPrintText(string);
        }
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    protected void dispose() {
        if (this.javalb != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.javalb);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.javalb != null) {
            this.javalb.disable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.javalb != null) {
            this.javalb.enable();
        }
        this.firePropertyChange(PROP_ENABLED, Boolean.FALSE, Boolean.TRUE);
    }

    public void setURL(String string) {
        if (string == this.url || string != null && this.url != null && string.equals(this.url)) {
            return;
        }
        String string2 = string;
        this.url = string;
        this.firePropertyChange(PROP_URL, string2, string);
    }

    public String getURL() {
        return this.url;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        if (n == this.lineNumber) {
            return;
        }
        int n2 = this.lineNumber;
        this.lineNumber = n;
        if (this.javalb != null) {
            this.javalb.setLineNumber(n);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, n2, this.getLineNumber());
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
            return;
        }
        String string2 = this.condition;
        this.condition = string;
        if (this.javalb != null) {
            this.javalb.setCondition(string);
        }
        this.firePropertyChange(PROP_CONDITION, string2, this.condition);
    }

    public String getCondition() {
        return this.condition;
    }

    public String toString() {
        return "GroovyLineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    public LineBreakpoint getJavalb() {
        return this.javalb;
    }

    public void setJavalb(LineBreakpoint lineBreakpoint) {
        this.javalb = lineBreakpoint;
    }

    public void setGroupName(String string) {
        super.setGroupName(string);
        this.javalb.setGroupName(string);
    }
}

