/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.ui.PushDownPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PushDownRefactoringUI
implements RefactoringUI {
    private final PushDownRefactoring refactoring;
    private final Set initialMembers = new HashSet();
    private PushDownPanel panel;
    private String description;

    public PushDownRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        TreePathHandle treePathHandle2 = PushDownRefactoringUI.resolveSelection(treePathHandle, compilationInfo);
        if (treePathHandle2 != null) {
            Element element = treePathHandle2.resolveElement(compilationInfo);
            this.initialMembers.add(MemberInfo.create(element, compilationInfo));
            if (!(element instanceof TypeElement)) {
                element = compilationInfo.getElementUtilities().enclosingTypeElement(element);
            }
            TreePath treePath = compilationInfo.getTrees().getPath(element);
            TreePathHandle treePathHandle3 = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
            this.description = ElementHeaders.getHeader((TreePath)treePath, (CompilationInfo)compilationInfo, (String)"%name%");
            this.refactoring = new PushDownRefactoring(treePathHandle3);
            this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(treePathHandle3));
        } else {
            this.refactoring = new PushDownRefactoring(treePathHandle);
        }
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new PushDownPanel(this.refactoring, this.initialMembers, changeListener);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.captureParameters();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        this.captureParameters();
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"DSC_PushDown", (Object)this.description);
    }

    public String getName() {
        return NbBundle.getMessage(PushDownRefactoringUI.class, (String)"LBL_PushDown");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PushDownRefactoringUI.class.getName());
    }

    private void captureParameters() {
        this.refactoring.setMembers(this.panel.getMembers());
    }

    static TreePathHandle resolveSelection(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        TreePath treePath;
        TreePath treePath2 = treePath = treePathHandle.resolve(compilationInfo);
        Element element = treePathHandle.resolveElement(compilationInfo);
        while (treePath2 != null && element == null) {
            if ((treePath2 = treePath2.getParentPath()) == null) {
                return null;
            }
            element = compilationInfo.getTrees().getElement(treePath2);
        }
        return treePath2 == treePath ? treePathHandle : TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo);
    }
}

