/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private TreePathHandle handle;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;

    public RenameRefactoringUI(TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        this.handle = treePathHandle;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)treePathHandle));
        Element element = treePathHandle.resolveElement(compilationInfo);
        this.oldName = element.getSimpleName().toString();
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(false, treePathHandle.getFileObject()));
        } else {
            this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(true, true, RetoucheUtils.getFileObject(treePathHandle)));
        }
        this.dispOldName = this.oldName;
    }

    public RenameRefactoringUI(FileObject fileObject, TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        if (treePathHandle != null) {
            this.handle = treePathHandle;
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject, treePathHandle}));
            this.oldName = treePathHandle.resolveElement(compilationInfo).getSimpleName().toString();
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject}));
            this.oldName = fileObject.getName();
        }
        this.dispOldName = this.oldName;
        ClasspathInfo classpathInfo = treePathHandle == null ? RetoucheUtils.getClasspathInfoFor(fileObject) : RetoucheUtils.getClasspathInfoFor(treePathHandle);
        this.refactoring.getContext().add((Object)classpathInfo);
    }

    public RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        this.oldName = RetoucheUtils.getPackageName(nonRecursiveFolder.getFolder());
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder()));
        this.dispOldName = this.oldName;
        this.pkgRename = true;
    }

    RenameRefactoringUI(FileObject fileObject, String string, TreePathHandle treePathHandle, CompilationInfo compilationInfo) {
        this.refactoring = treePathHandle != null ? new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject, treePathHandle})) : new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject}));
        this.oldName = string;
        this.dispOldName = string;
        ClasspathInfo classpathInfo = treePathHandle == null ? RetoucheUtils.getClasspathInfoFor(fileObject) : RetoucheUtils.getClasspathInfoFor(treePathHandle);
        this.refactoring.getContext().add((Object)classpathInfo);
        this.fromListener = true;
    }

    RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder, String string) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        this.refactoring.getContext().add((Object)RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder()));
        this.oldName = string;
        this.dispOldName = RetoucheUtils.getPackageName(nonRecursiveFolder.getFolder());
        this.fromListener = true;
        this.pkgRename = true;
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.oldName;
            String string2 = "";
            if (this.handle != null) {
                ElementKind elementKind = RetoucheUtils.getElementKind(this.handle);
                if (elementKind.isClass() || elementKind.isInterface()) {
                    string2 = elementKind.isInterface() ? RenameRefactoringUI.getString("LBL_Interface") : RenameRefactoringUI.getString("LBL_Class");
                } else if (elementKind == ElementKind.METHOD) {
                    string2 = RenameRefactoringUI.getString("LBL_Method");
                } else if (elementKind == ElementKind.FIELD) {
                    string2 = RenameRefactoringUI.getString("LBL_Field");
                } else if (elementKind == ElementKind.LOCAL_VARIABLE) {
                    string2 = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (elementKind == ElementKind.PACKAGE || this.handle == null && this.fromListener) {
                    string2 = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (elementKind == ElementKind.PARAMETER) {
                    string2 = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            string2 = string2 + " " + string;
            this.panel = new RenamePanel(string, changeListener, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + string2, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)string);
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        ElementKind elementKind;
        String string = this.handle == null ? ".JavaPackage" : ((elementKind = RetoucheUtils.getElementKind(this.handle)).isClass() || elementKind.isInterface() ? ".JavaClass" : (elementKind == ElementKind.METHOD ? ".Method" : (elementKind.isField() ? ".Field" : "")));
        return new HelpCtx(RenameRefactoringUI.class.getName() + string);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        FileObject fileObject;
        DataFolder dataFolder = null;
        if (this.byPassFolder != null) {
            dataFolder = DataFolder.findFolder((FileObject)this.byPassFolder);
        } else {
            fileObject = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            if (fileObject != null) {
                dataFolder = DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
            }
        }
        if (dataFolder != null) {
            dataFolder.rename(this.panel.getNameValue());
        } else {
            fileObject = (NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
            if (fileObject != null) {
                this.renamePackage(fileObject.getFolder(), this.panel.getNameValue());
            }
        }
    }

    private void renamePackage(FileObject fileObject, String string) {
        int n;
        int n2;
        FileObject fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
        string = string.replace('.', '/') + '/';
        String string2 = this.dispOldName.replace('.', '/') + '/';
        for (n2 = 0; n2 < string2.length() && n2 < string.length() && string2.charAt(n2) == string.charAt(n2); ++n2) {
        }
        String string3 = (n = string2.lastIndexOf(47, --n2)) == -1 ? null : string2.substring(0, n);
        String string4 = n + 1 == string.length() ? "" : string.substring(n + 1);
        try {
            DataFolder dataFolder;
            String string5;
            FileObject fileObject3;
            FileObject fileObject4 = fileObject3 = string3 == null ? fileObject2 : fileObject2.getFileObject(string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                dataFolder = fileObject4.getFileObject(string5);
                if (dataFolder == null) {
                    dataFolder = fileObject4.createFolder(string5);
                }
                fileObject4 = dataFolder;
            }
            string5 = DataFolder.findFolder((FileObject)fileObject);
            dataFolder = DataFolder.findFolder((FileObject)fileObject4);
            DataObject[] dataObjectArray = string5.getChildren();
            for (int i = 0; i < dataObjectArray.length; ++i) {
                if (!dataObjectArray[i].getPrimaryFile().isData()) continue;
                dataObjectArray[i].move(dataFolder);
            }
            while (!fileObject3.equals(fileObject) && fileObject.getChildren().length == 0) {
                FileObject fileObject5 = fileObject;
                fileObject = fileObject.getParent();
                fileObject5.delete();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

