/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.tasklist.filter.FilterCondition;
import org.netbeans.modules.tasklist.filter.Util;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.checklist.CheckList;
import org.netbeans.modules.tasklist.ui.checklist.DefaultCheckListModel;
import org.openide.util.NbBundle;

class TaskGroupCondition
extends FilterCondition {
    private boolean[] groupState;
    private TaskGroup[] groups;

    public static TaskGroupCondition[] createConditions() {
        return new TaskGroupCondition[]{new TaskGroupCondition()};
    }

    public TaskGroupCondition() {
        ArrayList arrayList = new ArrayList(TaskGroup.getGroups());
        this.groups = arrayList.toArray(new TaskGroup[arrayList.size()]);
        this.groupState = new boolean[this.groups.length];
        Arrays.fill(this.groupState, true);
    }

    public TaskGroupCondition(TaskGroupCondition taskGroupCondition) {
        super(taskGroupCondition);
        this.groups = new TaskGroup[taskGroupCondition.groups.length];
        this.groupState = new boolean[taskGroupCondition.groupState.length];
        assert (this.groups.length == this.groupState.length);
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i] = taskGroupCondition.groups[i];
            this.groupState[i] = taskGroupCondition.groupState[i];
        }
    }

    public Object clone() {
        return new TaskGroupCondition(this);
    }

    public boolean isTrue(Object object) {
        TaskGroup taskGroup = (TaskGroup)object;
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].equals((Object)taskGroup)) continue;
            return this.groupState[i];
        }
        return true;
    }

    public JComponent createConstantComponent() {
        CheckList checkList = new CheckList(new DefaultCheckListModel(this.groupState, this.groups));
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TextField.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jPanel.add((Component)checkList, "Center");
        jPanel.setToolTipText(Util.getString("group_desc"));
        checkList.getAccessibleContext().setAccessibleName(Util.getString("LBL_PriorityCheckList"));
        checkList.getAccessibleContext().setAccessibleDescription(Util.getString("LBL_PriorityCheckList"));
        checkList.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                boolean bl = false;
                for (int i = 0; i < TaskGroupCondition.this.groupState.length; ++i) {
                    if (!TaskGroupCondition.this.groupState[i]) continue;
                    bl = true;
                    break;
                }
                jPanel.putClientProperty("value-valid", new Boolean(bl));
            }
        });
        return jPanel;
    }

    public void getConstantFrom(JComponent jComponent) {
    }

    protected String getDisplayName() {
        return NbBundle.getMessage(TaskGroupCondition.class, (String)"IsOneOf");
    }

    void load(Preferences preferences, String string) throws BackingStoreException {
        for (int i = 0; i < this.groups.length; ++i) {
            String string2 = this.groups[i].getName();
            this.groupState[i] = preferences.getBoolean(string + "_enabled_" + string2, true);
        }
    }

    void save(Preferences preferences, String string) throws BackingStoreException {
        for (int i = 0; i < this.groups.length; ++i) {
            String string2 = this.groups[i].getName();
            preferences.putBoolean(string + "_enabled_" + string2, this.groupState[i]);
        }
    }
}

