/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class TaskProperties {
    public static final String PROPID_GROUP = "group";
    public static final String PROPID_DESCRIPTION = "description";
    public static final String PROPID_FILE = "file";
    public static final String PROPID_LOCATION = "location";
    public static TaskProperty PROP_GROUP = new TaskProperty("group", TaskGroup.class){

        public Object getValue(Task task) {
            return Accessor.getGroup(task);
        }
    };
    public static TaskProperty PROP_DESCRIPTION = new TaskProperty("description", String.class){

        public Object getValue(Task task) {
            return Accessor.getDescription(task);
        }
    };
    public static TaskProperty PROP_FILE = new TaskProperty("file", String.class){

        public Object getValue(Task task) {
            FileObject fileObject = Accessor.getResource(task);
            if (null == fileObject || fileObject.isFolder()) {
                return "";
            }
            return fileObject.getNameExt();
        }
    };
    public static TaskProperty PROP_LOCATION = new TaskProperty("location", String.class){

        public Object getValue(Task task) {
            FileObject fileObject = Accessor.getResource(task);
            if (null == fileObject || fileObject.isFolder()) {
                return FileUtil.getFileDisplayName((FileObject)fileObject);
            }
            return FileUtil.getFileDisplayName((FileObject)fileObject.getParent());
        }
    };

    TaskProperties() {
    }

    public static TaskProperty getProperty(String string) {
        if (string.equals(PROPID_GROUP)) {
            return PROP_GROUP;
        }
        if (string.equals(PROPID_DESCRIPTION)) {
            return PROP_DESCRIPTION;
        }
        if (string.equals(PROPID_FILE)) {
            return PROP_FILE;
        }
        if (string.equals(PROPID_LOCATION)) {
            return PROP_LOCATION;
        }
        throw new IllegalArgumentException("Unresolved property id " + string);
    }
}

