/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;

class ScopeStatusBar
extends JLabel
implements PropertyChangeListener {
    private TaskManagerImpl taskManager;
    private TaskList.Listener listener;

    public ScopeStatusBar(TaskManagerImpl taskManagerImpl) {
        this.taskManager = taskManagerImpl;
        this.setEnabled(false);
        this.updateText();
        this.listener = new TaskList.Listener(){

            @Override
            public void tasksAdded(List<? extends Task> list) {
                ScopeStatusBar.this.updateText();
            }

            @Override
            public void tasksRemoved(List<? extends Task> list) {
                ScopeStatusBar.this.updateText();
            }

            @Override
            public void cleared() {
                ScopeStatusBar.this.updateText();
            }
        };
    }

    private void updateText() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        TaskScanningScope taskScanningScope = this.taskManager.getScope();
        Map map = (Map)taskScanningScope.getLookup().lookup(Map.class);
        if (null != map && null != (string = (String)map.get("StatusBarLabel"))) {
            stringBuffer.append(string);
        }
        this.setText(stringBuffer.toString());
    }

    public void removeNotify() {
        super.removeNotify();
        this.taskManager.removePropertyChangeListener("taskScanningScope", this);
        this.taskManager.getTasks().removeListener(this.listener);
    }

    public void addNotify() {
        super.addNotify();
        this.taskManager.addPropertyChangeListener("taskScanningScope", this);
        this.taskManager.getTasks().addListener(this.listener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateText();
    }
}

