/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.filesystem;

import java.net.URL;
import java.util.ArrayList;
import java.util.WeakHashMap;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLContentProvider;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileObject;
import org.netbeans.modules.web.client.javascript.debugger.filesystem.URLFileSystem;
import org.openide.filesystems.FileObject;

public final class URLFileObjectFactory {
    private static WeakHashMap<URLContentProvider, URLFileSystem> fsCache;

    public static synchronized URLFileSystem getFileSystem(URLContentProvider uRLContentProvider) {
        URLFileSystem uRLFileSystem;
        if (fsCache == null) {
            fsCache = new WeakHashMap();
        }
        if ((uRLFileSystem = fsCache.get(uRLContentProvider)) == null) {
            uRLFileSystem = new URLFileSystem();
            uRLFileSystem.setContentProvider(uRLContentProvider);
            Object object = uRLContentProvider.getSource();
            if (object != null) {
                uRLFileSystem.setSessionId(object.toString());
            }
            fsCache.put(uRLContentProvider, uRLFileSystem);
        }
        return uRLFileSystem;
    }

    public static synchronized URLFileObject getFileObject(URLContentProvider uRLContentProvider, URL uRL) {
        URLFileObject uRLFileObject;
        URLFileSystem uRLFileSystem = URLFileObjectFactory.getFileSystem(uRLContentProvider);
        String string = uRL.toExternalForm();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((uRLFileObject = (URLFileObject)uRLFileSystem.findResource(string)) == null) {
            return uRLFileSystem.addURL(uRL);
        }
        return uRLFileObject;
    }

    public static synchronized URLFileObject findFileObject(URLContentProvider uRLContentProvider, URL uRL) {
        URLFileSystem uRLFileSystem = URLFileObjectFactory.getFileSystem(uRLContentProvider);
        String string = uRL.toExternalForm();
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return (URLFileObject)uRLFileSystem.findResource(string);
    }

    public static synchronized FileObject[] findFileObjects(URL uRL) {
        if (fsCache == null || fsCache.size() == 0) {
            return null;
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        String string = uRL.toExternalForm();
        for (URLFileSystem uRLFileSystem : fsCache.values()) {
            FileObject fileObject;
            if (uRLFileSystem == null || (fileObject = uRLFileSystem.findResource(string)) == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }
}

