/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui;

import java.awt.AWTKeyStroke;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSDialogUtil;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class NbJSDialogUtil {
    public static void setupContext(JEditorPane jEditorPane, String string, int n) {
        StyledDocument styledDocument;
        DataObject dataObject;
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
            if (fileObject == null) {
                return;
            }
            try {
                dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie == null) {
                    return;
                }
                try {
                    styledDocument = editorCookie.openDocument();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            jEditorPane.getDocument().putProperty("stream", dataObject);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField();
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    private static class FilteredKeymap
    implements Keymap {
        private final KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        private final KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        private final KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        private final Keymap keyMap;

        public FilteredKeymap(final JTextComponent jTextComponent) {
            this.keyMap = jTextComponent.getKeymap();
            jTextComponent.addPropertyChangeListener("keymap", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!(propertyChangeEvent.getNewValue() instanceof FilteredKeymap)) {
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        class KeymapUpdater
                        implements Runnable {
                            final /* synthetic */ JTextComponent val$component;
                            final /* synthetic */ FilteredKeymap this$0;

                            KeymapUpdater() {
                                this.this$0 = filteredKeymap;
                                this.val$component = jTextComponent;
                            }

                            public void run() {
                                this.val$component.setKeymap(new FilteredKeymap(this.val$component));
                            }
                        }
                        jTextComponent.removePropertyChangeListener("keymap", this);
                        if (EventQueue.isDispatchThread()) {
                            EventQueue.invokeLater(new KeymapUpdater(FilteredKeymap.this, jTextComponent));
                        } else {
                            RequestProcessor.getDefault().post((Runnable)new KeymapUpdater(FilteredKeymap.this, jTextComponent), 100);
                        }
                    }
                }
            });
        }

        public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
            this.keyMap.addActionForKeyStroke(keyStroke, action);
        }

        public Action getAction(KeyStroke keyStroke) {
            if (this.enter.equals(keyStroke) || this.esc.equals(keyStroke) || this.tab.equals(keyStroke)) {
                return null;
            }
            return this.keyMap.getAction(keyStroke);
        }

        public Action[] getBoundActions() {
            return this.keyMap.getBoundActions();
        }

        public KeyStroke[] getBoundKeyStrokes() {
            return this.keyMap.getBoundKeyStrokes();
        }

        public Action getDefaultAction() {
            return this.keyMap.getDefaultAction();
        }

        public KeyStroke[] getKeyStrokesForAction(Action action) {
            return this.keyMap.getKeyStrokesForAction(action);
        }

        public String getName() {
            return this.keyMap.getName() + "_Filtered";
        }

        public Keymap getResolveParent() {
            return this.keyMap.getResolveParent();
        }

        public boolean isLocallyDefined(KeyStroke keyStroke) {
            if (this.enter.equals(keyStroke) || this.esc.equals(keyStroke) || this.tab.equals(keyStroke)) {
                return false;
            }
            return this.keyMap.isLocallyDefined(keyStroke);
        }

        public void removeBindings() {
            this.keyMap.removeBindings();
        }

        public void removeKeyStrokeBinding(KeyStroke keyStroke) {
            this.keyMap.removeKeyStrokeBinding(keyStroke);
        }

        public void setDefaultAction(Action action) {
            this.keyMap.setDefaultAction(action);
        }

        public void setResolveParent(Keymap keymap) {
            this.keyMap.setResolveParent(keymap);
        }
    }
}

