/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.web.client.javascript.debugger.ui.NbJSDialogUtil;
import org.netbeans.modules.web.client.javascript.debugger.ui.breakpoints.NbJSBreakpoint;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class NbJSBreakpointConditionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String orCondition;
    private int orFilter;
    private Breakpoint.HIT_COUNT_FILTERING_STYLE orFilterStyle;
    private NbJSBreakpoint breakpoint;
    private JTextField tfConditionFieldForUI;
    private JComboBox cbHitStyle;
    private JCheckBox cbWhenHitCount;
    private JLabel classIncludeFilterLabel;
    private JCheckBox conditionCheckBox;
    private JPanel panelHitCountFilter;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfHitCountFilter;

    public NbJSBreakpointConditionsPanel() {
        this.setupPanel();
        this.orCondition = "";
        this.orFilterStyle = Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER;
        this.orFilter = 0;
        this.initConditionPanel(this.orCondition, this.orFilterStyle, this.orFilter);
    }

    public NbJSBreakpointConditionsPanel(NbJSBreakpoint nbJSBreakpoint) {
        this.setupPanel();
        this.breakpoint = nbJSBreakpoint;
        FileObject fileObject = null;
        if (nbJSBreakpoint != null) {
            this.orCondition = nbJSBreakpoint.getCondition();
            this.orFilterStyle = nbJSBreakpoint.getHitCountFilteringStyle();
            this.orFilter = nbJSBreakpoint.getHitCountFilter();
            fileObject = nbJSBreakpoint.getFileObject();
        } else {
            this.orCondition = "";
            this.orFilterStyle = Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER;
            this.orFilter = 0;
        }
        this.initConditionPanel(this.orCondition, this.orFilterStyle, this.orFilter);
        if (fileObject != null) {
            this.setupConditionPaneContext(fileObject.getPath(), nbJSBreakpoint.getLineNumber());
        }
    }

    private void setupPanel() {
        this.initComponents();
        this.tfConditionFieldForUI = new JTextField();
        this.tfConditionFieldForUI.setEnabled(false);
        this.tfConditionFieldForUI.setToolTipText(this.tfCondition.getToolTipText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.tfConditionFieldForUI, gridBagConstraints);
        this.conditionCheckBoxActionPerformed(null);
        this.cbWhenHitCountActionPerformed(null);
        int n = this.tfConditionFieldForUI.getPreferredSize().height;
        if (this.spCondition.getPreferredSize().height > n) {
            n = this.spCondition.getPreferredSize().height;
            this.tfConditionFieldForUI.setPreferredSize(new Dimension(this.tfConditionFieldForUI.getPreferredSize().width, n));
        }
        this.tfHitCountFilter.setPreferredSize(new Dimension(8 * this.tfHitCountFilter.getFontMetrics(this.tfHitCountFilter.getFont()).charWidth('8'), this.tfHitCountFilter.getPreferredSize().height));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.equals"), NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.greaterThanOrEquals"), NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.multiple")}));
    }

    private void initConditionPanel(String string, Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE, int n) {
        this.setCondition(string);
        this.setHitCount(n);
        this.setHitCountFilteringStyle(hIT_COUNT_FILTERING_STYLE);
    }

    public void showCondition(boolean bl) {
        this.conditionCheckBox.setVisible(bl);
        if (bl) {
            this.conditionCheckBoxActionPerformed(null);
        } else {
            this.spCondition.setVisible(bl);
            this.tfCondition.setVisible(bl);
            this.tfConditionFieldForUI.setVisible(bl);
        }
    }

    public void setCondition(String string) {
        String string2 = string != null ? string : "";
        this.tfCondition.setText(string2);
        this.conditionCheckBox.setSelected(string2.length() > 0);
        this.conditionCheckBoxActionPerformed(null);
    }

    public void setHitCountFilteringStyle(Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE) {
        this.cbHitStyle.setSelectedIndex(hIT_COUNT_FILTERING_STYLE != null ? hIT_COUNT_FILTERING_STYLE.ordinal() : 0);
    }

    public void setHitCount(int n) {
        if (n != 0) {
            this.cbWhenHitCount.setSelected(true);
            this.tfHitCountFilter.setText(Integer.toString(n));
        } else {
            this.cbWhenHitCount.setSelected(false);
            this.tfHitCountFilter.setText("1");
        }
        this.cbWhenHitCountActionPerformed(null);
    }

    public void setupConditionPaneContext(String string, int n) {
        NbJSDialogUtil.setupContext(this.tfCondition, string, n);
    }

    public String getCondition() {
        if (this.conditionCheckBox.isSelected()) {
            return this.tfCondition.getText().trim();
        }
        return "";
    }

    public Breakpoint.HIT_COUNT_FILTERING_STYLE getHitCountFilteringStyle() {
        return Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[this.cbHitStyle.getSelectedIndex()];
    }

    public int getHitCount() {
        if (!this.cbWhenHitCount.isSelected()) {
            return 0;
        }
        String string = this.tfHitCountFilter.getText().trim();
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String valiadateMsg() {
        String string = this.tfHitCountFilter.getText().trim();
        if (this.cbWhenHitCount.isSelected()) {
            if (string.length() > 0) {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"MSG_Bad_Hit_Count_Filter_Spec", (Object)string);
                }
                if (n <= 0) {
                    return NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"MSG_NonPositive_Hit_Count_Filter_Spec");
                }
            } else {
                return NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"MSG_No_Hit_Count_Filter_Spec");
            }
        }
        if (this.conditionCheckBox.isSelected() && this.tfCondition.getText().trim().length() == 0) {
            return NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"MSG_No_Condition_Spec");
        }
        return null;
    }

    private void initComponents() {
        this.classIncludeFilterLabel = new JLabel();
        this.conditionCheckBox = new JCheckBox();
        this.panelHitCountFilter = new JPanel();
        this.tfHitCountFilter = new JTextField();
        this.cbHitStyle = new JComboBox();
        this.cbWhenHitCount = new JCheckBox();
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.classIncludeFilterLabel, null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 3);
        this.add((Component)this.classIncludeFilterLabel, gridBagConstraints);
        this.classIncludeFilterLabel.getAccessibleContext().setAccessibleDescription("null");
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSD_L_Line_Breakpoint_Condition"));
        this.conditionCheckBox.setToolTipText(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"TTT_CB_ConditionsPanel_Condition"));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbJSBreakpointConditionsPanel.this.conditionCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.conditionCheckBox, gridBagConstraints);
        this.conditionCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ASCD_Condition_CKBX"));
        this.conditionCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ASCD_Condition_CKBX_Desc"));
        this.panelHitCountFilter.setLayout(new GridBagLayout());
        this.tfHitCountFilter.setToolTipText(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"TTT_TF_Hit_Count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.tfHitCountFilter, gridBagConstraints);
        this.tfHitCountFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSN_HitCountTF"));
        this.tfHitCountFilter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSD_TF_HitCount_Desc"));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"equals to", "is greater than or equals to", "is multiple of"}));
        this.cbHitStyle.setSelectedIndex(1);
        this.cbHitStyle.setEnabled(false);
        this.cbHitStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbJSBreakpointConditionsPanel.this.cbHitStyleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        this.panelHitCountFilter.add((Component)this.cbHitStyle, gridBagConstraints);
        this.cbHitStyle.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSN_CB_HitCount_Qualifier"));
        this.cbHitStyle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSD_CB_HitCount_Desc"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWhenHitCount, (String)NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.text"));
        this.cbWhenHitCount.setToolTipText(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"TTT_CB_CondtionsPanel_HitFilterWhen"));
        this.cbWhenHitCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbJSBreakpointConditionsPanel.this.cbWhenHitCountActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.cbWhenHitCount, gridBagConstraints);
        this.cbWhenHitCount.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ASCD_Break_hitCount"));
        this.cbWhenHitCount.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSD_Break_HitCount_Desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelHitCountFilter, gridBagConstraints);
        this.spCondition = NbJSDialogUtil.createScrollableLineEditor(this.tfCondition);
        this.spCondition.setToolTipText(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"TTT_TF_Line_Breakpoint_Condition"));
        this.tfCondition.setContentType(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"NbJSBreakpointConditionsPanel.tfCondition.contentType"));
        this.tfCondition.setToolTipText(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"TTT_TF_Line_Breakpoint_Condition"));
        this.spCondition.setViewportView(this.tfCondition);
        this.tfCondition.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSN_ConditionTF"));
        this.tfCondition.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSN_ConditionTF_Desc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.spCondition, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbJSBreakpointConditionsPanel.class, (String)"ACSD_Conditions"));
    }

    private void cbWhenHitCountActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.cbWhenHitCount.isSelected();
        this.cbHitStyle.setEnabled(bl);
        this.tfHitCountFilter.setEnabled(bl);
    }

    private void conditionCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.conditionCheckBox.isSelected();
        this.spCondition.setEnabled(bl);
        this.tfCondition.setEnabled(bl);
        if (bl) {
            this.tfCondition.setVisible(true);
            this.spCondition.setVisible(true);
            this.tfConditionFieldForUI.setVisible(false);
            if (this.spCondition.getPreferredSize().height > this.tfCondition.getPreferredSize().height) {
                final int n = -(this.spCondition.getPreferredSize().height - this.tfCondition.getPreferredSize().height) / 2;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NbJSBreakpointConditionsPanel.this.spCondition.getViewport().setViewPosition(new Point(0, n));
                    }
                });
            }
            this.tfCondition.requestFocusInWindow();
        } else {
            this.tfCondition.setVisible(false);
            this.spCondition.setVisible(false);
            this.tfConditionFieldForUI.setText(this.tfCondition.getText());
            this.tfConditionFieldForUI.setVisible(true);
        }
        this.revalidate();
        this.repaint();
    }

    private void cbHitStyleActionPerformed(ActionEvent actionEvent) {
    }

    public void ok() {
        String string = this.getCondition();
        int n = this.getHitCount();
        Breakpoint.HIT_COUNT_FILTERING_STYLE hIT_COUNT_FILTERING_STYLE = this.getHitCountFilteringStyle();
        boolean bl = false;
        if (!string.equals(this.orCondition)) {
            this.breakpoint.setCondition(string);
            bl = true;
        }
        if (n != this.orFilter || hIT_COUNT_FILTERING_STYLE != this.orFilterStyle) {
            this.breakpoint.setHitCountFilter(n, hIT_COUNT_FILTERING_STYLE);
            bl = true;
        }
        if (bl) {
            this.breakpoint.notifyUpdated(this);
        }
    }

    public void setBreakpoint(NbJSBreakpoint nbJSBreakpoint) {
        this.breakpoint = nbJSBreakpoint;
    }
}

