/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.netbeans.modules.web.client.javascript.debugger.api.NbJSDebugger;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionException;
import org.netbeans.modules.web.client.tools.impl.DebugConstants;
import org.netbeans.modules.web.client.tools.impl.Log;
import org.netbeans.modules.web.client.tools.spi.WebClientToolsSessionStarter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class WebClientToolsSessionStarterImpl
implements WebClientToolsSessionStarter {
    public void startSession(final URI uRI, final HtmlBrowser.Factory factory, final Lookup lookup) throws WebClientToolsSessionException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    WebClientToolsSessionStarterImpl.this.startSessionImpl(uRI, factory, lookup);
                }
                catch (WebClientToolsSessionException webClientToolsSessionException) {
                    Log.getLogger().log(Level.INFO, "Unexpected exception while starting debugger", webClientToolsSessionException);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private void startSessionImpl(URI uRI, HtmlBrowser.Factory factory, Lookup lookup) throws WebClientToolsSessionException {
        boolean bl = WebClientToolsProjectUtils.isInternetExplorerSupported();
        boolean bl2 = WebClientToolsProjectUtils.isFirefoxSupported();
        Preferences preferences = NbPreferences.forModule(DebugConstants.class);
        if (!bl && !bl2) {
            this.displayNoBrowserDialog(preferences);
            this.displayInBrowser(uRI);
            return;
        }
        factory = this.getSupportedBrowser(factory, bl2, bl);
        NbJSDebugger.startDebugging(uRI, factory, lookup);
    }

    private void displayNoBrowserDialog(Preferences preferences) {
        if (preferences.getBoolean("noBrowserShowDialog", true)) {
            JCheckBox jCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)NbBundle.getMessage(WebClientToolsSessionStarterImpl.class, (String)"DO_NOT_SHOW_AGAIN"));
            jCheckBox.setSelected(false);
            String string = NbBundle.getMessage(WebClientToolsSessionStarterImpl.class, (String)"NO_BROWSER_TEXT");
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(false);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)new Object[]{jLabel, jCheckBox});
            message.setMessageType(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            if (jCheckBox.isSelected()) {
                preferences.putBoolean("noBrowserShowDialog", false);
                try {
                    preferences.sync();
                }
                catch (BackingStoreException backingStoreException) {
                    Log.getLogger().log(Level.WARNING, "Could not save preference", backingStoreException);
                }
            }
        }
    }

    private void displayInBrowser(URI uRI) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Could not launch browser", malformedURLException);
        }
    }

    private HtmlBrowser.Factory getSupportedBrowser(HtmlBrowser.Factory factory, boolean bl, boolean bl2) {
        if (bl && bl2) {
            return factory;
        }
        if (bl2) {
            return WebClientToolsProjectUtils.getInternetExplorerBrowser();
        }
        return WebClientToolsProjectUtils.getFirefoxBrowser();
    }
}

