/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.impl.projects;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.impl.DebugConstants;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class CustomizerDebug
extends JPanel
implements ActionListener {
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final String debugServerMsg;
    private final String debugClientMsg;
    private final boolean ieBrowserSupported;
    private final boolean ffBrowserSupported;
    private ButtonGroup browserButtonGroup;
    private JCheckBox debugClientJCheckBox;
    private JCheckBox debugServerJCheckBox;
    private JRadioButton firefoxRadioButton;
    private JRadioButton internetExplorerRadioButton;
    private JLabel noSupportedBrowserLabel;

    public CustomizerDebug(ProjectCustomizer.Category category, Project project, String string, String string2) {
        this.category = category;
        this.debugServerMsg = string;
        this.debugClientMsg = string2;
        this.project = project;
        this.initComponents();
        boolean bl = WebClientToolsProjectUtils.getServerDebugProperty((Project)project);
        boolean bl2 = WebClientToolsProjectUtils.getClientDebugProperty((Project)project);
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        WebClientToolsProjectUtils.Browser browser = null;
        if (!WebClientToolsProjectUtils.isDebugPropertySet((Project)project)) {
            boolean bl3;
            Preferences preferences = NbPreferences.forModule(DebugConstants.class);
            String string3 = preferences.get("clientDebugSwitch", null);
            String string4 = this.ffBrowserSupported || !this.ieBrowserSupported ? WebClientToolsProjectUtils.Browser.FIREFOX.name() : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER.name();
            browser = WebClientToolsProjectUtils.Browser.valueOf((String)preferences.get("debugConfigBrowser", string4));
            boolean bl4 = bl3 = !preferences.getBoolean("debugConfigShowDialog", true);
            if (bl3 && string3 != null && !(bl2 = preferences.getBoolean("clientDebugSwitch", true))) {
                bl = true;
            }
        }
        if (!this.ieBrowserSupported && !this.ffBrowserSupported) {
            bl2 = false;
            this.debugClientJCheckBox.setEnabled(false);
            this.debugServerJCheckBox.setEnabled(false);
            this.firefoxRadioButton.setEnabled(false);
            this.internetExplorerRadioButton.setEnabled(false);
            this.noSupportedBrowserLabel.setVisible(true);
        } else {
            this.noSupportedBrowserLabel.setVisible(false);
        }
        this.debugServerJCheckBox.setSelected(bl);
        this.debugClientJCheckBox.setSelected(bl2);
        this.debugClientJCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CustomizerDebug.this.adjustBrowserRadioButtons();
            }
        });
        if (this.ffBrowserSupported && !this.ieBrowserSupported) {
            this.firefoxRadioButton.setSelected(true);
        } else if (this.ieBrowserSupported && !this.ffBrowserSupported) {
            this.internetExplorerRadioButton.setSelected(true);
        } else if (browser != null) {
            this.firefoxRadioButton.setSelected(WebClientToolsProjectUtils.Browser.FIREFOX == browser);
            this.internetExplorerRadioButton.setSelected(WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER == browser);
        } else {
            this.firefoxRadioButton.setSelected(!Utilities.isWindows() || WebClientToolsProjectUtils.isFirefox((Project)project));
            this.internetExplorerRadioButton.setSelected(Utilities.isWindows() && WebClientToolsProjectUtils.isInternetExplorer((Project)project));
        }
        this.adjustBrowserRadioButtons();
        this.category.setStoreListener((ActionListener)this);
        this.validateCheckBoxes();
    }

    private void adjustBrowserRadioButtons() {
        this.firefoxRadioButton.setEnabled(this.debugClientJCheckBox.isSelected() && this.ffBrowserSupported);
        this.internetExplorerRadioButton.setEnabled(this.debugClientJCheckBox.isSelected() && this.ieBrowserSupported);
    }

    private void initComponents() {
        this.browserButtonGroup = new ButtonGroup();
        this.debugServerJCheckBox = new JCheckBox();
        this.debugClientJCheckBox = new JCheckBox();
        this.firefoxRadioButton = new JRadioButton();
        this.internetExplorerRadioButton = new JRadioButton();
        this.noSupportedBrowserLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.debugServerJCheckBox, (String)this.debugServerMsg);
        this.debugServerJCheckBox.setMargin(new Insets(0, 0, 2, 2));
        this.debugServerJCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerDebug.this.debugServerActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.debugClientJCheckBox, (String)this.debugClientMsg);
        this.debugClientJCheckBox.setMargin(new Insets(0, 0, 2, 2));
        this.debugClientJCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerDebug.this.debugClientActionPerformed(actionEvent);
            }
        });
        this.browserButtonGroup.add(this.firefoxRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.internetExplorerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.internetExplorerRadioButton, (String)NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.internetExplorerRadioButton.text"));
        this.internetExplorerRadioButton.setToolTipText(NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.internetExplorerRadioButton.tooltip"));
        Mnemonics.setLocalizedText((JLabel)this.noSupportedBrowserLabel, (String)NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.noSupportedBrowserLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugServerJCheckBox, -1, 650, Short.MAX_VALUE).add(22, 22, 22)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugClientJCheckBox, -1, 661, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(24, 24, 24).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.internetExplorerRadioButton).add((Component)this.firefoxRadioButton)).add(378, 378, 378)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.noSupportedBrowserLabel).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.debugServerJCheckBox, -2, 30, -2).addPreferredGap(0).add((Component)this.debugClientJCheckBox, -2, 30, -2).addPreferredGap(0).add((Component)this.firefoxRadioButton).addPreferredGap(0).add((Component)this.internetExplorerRadioButton).add(18, 18, 18).add((Component)this.noSupportedBrowserLabel).addContainerGap(375, Short.MAX_VALUE)));
        this.debugServerJCheckBox.getAccessibleContext().setAccessibleDescription("null");
        this.debugClientJCheckBox.getAccessibleContext().setAccessibleDescription("null");
        this.firefoxRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.firefoxRadioButton.text"));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDebug.class, (String)"ACSD_FF_RadioButton"));
        this.internetExplorerRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDebug.class, (String)"CustomizerDebug.internetExplorerRadioButton.text"));
        this.internetExplorerRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDebug.class, (String)"ACSD_IE_RadioButton"));
    }

    private void debugServerActionPerformed(ActionEvent actionEvent) {
        this.validateCheckBoxes();
    }

    private void debugClientActionPerformed(ActionEvent actionEvent) {
        this.validateCheckBoxes();
    }

    private void validateCheckBoxes() {
        if (!this.debugClientJCheckBox.isSelected() && !this.debugServerJCheckBox.isSelected()) {
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerDebug.class, (String)"LBL_CustomizeDebug_NoDebug_Error"));
            this.category.setValid(false);
        } else {
            this.category.setErrorMessage(null);
            this.category.setValid(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.ieBrowserSupported || this.ffBrowserSupported) {
            WebClientToolsProjectUtils.setProjectProperties((Project)this.project, (boolean)this.debugServerJCheckBox.isSelected(), (boolean)this.debugClientJCheckBox.isSelected(), (WebClientToolsProjectUtils.Browser)(this.internetExplorerRadioButton.isSelected() ? WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER : WebClientToolsProjectUtils.Browser.FIREFOX));
        }
    }
}

