/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class WSITRefactoringPlugin<T extends AbstractRefactoring>
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.refactoring");
    protected static final String WS_ANNOTATION = "javax.xml.ws.WebService";
    protected static final String WSDL_LOCATION_ELEMENT = "wsdlLocation";
    protected final T refactoring;
    protected final TreePathHandle[] treePathHandle;

    public WSITRefactoringPlugin(T t) {
        this.refactoring = t;
        this.treePathHandle = t.getRefactoringSource().lookupAll(TreePathHandle.class).toArray(new TreePathHandle[0]);
        LOGGER.log(Level.FINE, "refactoring: " + t.getClass().getName() + "; refactoring sources: " + Arrays.asList(this.treePathHandle));
    }

    public void cancelRequest() {
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(final RefactoringElementsBag refactoringElementsBag) {
        LOGGER.log(Level.FINE, "prepare()");
        Problem problem = null;
        ClasspathInfo classpathInfo = this.getClasspathInfo();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle[0].getFileObject()});
        this.fireProgressListenerStart(3, 5);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    block10: for (TreePathHandle treePathHandle : WSITRefactoringPlugin.this.treePathHandle) {
                        Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                        if (element == null) {
                            return;
                        }
                        switch (element.getKind()) {
                            case METHOD: {
                                ElementHandle elementHandle = ElementHandle.create((Element)element);
                                FileObject fileObject = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)compilationController.getClasspathInfo());
                                if (fileObject == null) {
                                    ErrorManager.getDefault().log(1, "WSIT: Null instance returned from SourceUtils.getFile; element not found " + element);
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Element element2 = element.getEnclosingElement();
                                if (WSITRefactoringPlugin.isWebSvcFromWsdl(element2)) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
                                if (jAXWSSupport == null) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                                if (project == null) {
                                    return;
                                }
                                WSDLModel wSDLModel = null;
                                try {
                                    wSDLModel = WSITModelSupport.getModelForServiceFromJava(fileObject, project, false, null);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (wSDLModel == null) {
                                    return;
                                }
                                refactoringElementsBag.add(WSITRefactoringPlugin.this.refactoring, WSITRefactoringPlugin.this.createMethodRE(element.getSimpleName().toString(), wSDLModel));
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                continue block10;
                            }
                            case CLASS: 
                            case INTERFACE: 
                            case ANNOTATION_TYPE: 
                            case ENUM: {
                                ElementHandle elementHandle = ElementHandle.create((Element)element);
                                FileObject fileObject = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)compilationController.getClasspathInfo());
                                if (fileObject == null) {
                                    ErrorManager.getDefault().log(1, "WSIT: Null instance returned from SourceUtils.getFile; element not found " + element);
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (WSITRefactoringPlugin.isWebSvcFromWsdl(element)) {
                                    return;
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Element element2 = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
                                if (element2 == null) {
                                    return;
                                }
                                JAXWSSupport jAXWSSupport = null;
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                                if (project == null) {
                                    return;
                                }
                                try {
                                    jAXWSSupport = WSITModelSupport.getModelForServiceFromJava(fileObject, project, false, null);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                if (jAXWSSupport == null) {
                                    return;
                                }
                                refactoringElementsBag.addFileChange(WSITRefactoringPlugin.this.refactoring, WSITRefactoringPlugin.this.createClassRE((WSDLModel)jAXWSSupport));
                                WSITRefactoringPlugin.this.fireProgressListenerStep();
                                continue block10;
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        finally {
            this.fireProgressListenerStop();
        }
        return problem;
    }

    protected abstract RefactoringElementImplementation createMethodRE(String var1, WSDLModel var2);

    protected abstract RefactoringElementImplementation createClassRE(WSDLModel var1);

    protected final ClasspathInfo getClasspathInfo() {
        return (ClasspathInfo)this.refactoring.getContext().lookup(ClasspathInfo.class);
    }

    protected static boolean isWebSvcFromWsdl(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!WS_ANNOTATION.equals(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName())) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!WSDL_LOCATION_ELEMENT.equals(executableElement.getSimpleName().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected static Problem createProblem(Problem problem, boolean bl, String string) {
        Problem problem2 = new Problem(bl, string);
        if (problem == null) {
            return problem2;
        }
        if (bl) {
            problem2.setNext(problem);
            return problem2;
        }
        Problem problem3 = problem;
        while (problem3.getNext() != null) {
            problem3 = problem3.getNext();
        }
        problem3.setNext(problem2);
        return problem;
    }

    protected static abstract class AbstractRefactoringElement
    extends SimpleRefactoringElementImplementation {
        protected final WSDLModel model;
        protected final FileObject file;

        public AbstractRefactoringElement(WSDLModel wSDLModel) {
            this.model = wSDLModel;
            this.file = Util.getFOForModel(wSDLModel);
        }

        public String getText() {
            return this.getDisplayText();
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }
    }
}

