/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificSecurity;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificTransport;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.openide.filesystems.FileObject;

public abstract class WsitProvider {
    protected Project project;
    protected static final String CLIENT_CFG_FOLDER = "META-INF";
    private static final Logger logger = Logger.getLogger(WsitProvider.class.getName());

    public ProjectSpecificSecurity getProjectSecurityUpdater() {
        return null;
    }

    public ProjectSpecificTransport getProjectTransportUpdater() {
        return null;
    }

    public boolean isJsr109Project() {
        return false;
    }

    public boolean isWsitSupported() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            FileObject fileObject = classPath.findResource("com/sun/xml/ws/tx/service/TxServerPipe.class");
            if (fileObject != null) {
                return true;
            }
            J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(this.project);
            if (j2eePlatform != null) {
                Collection collection = j2eePlatform.getLookup().lookupAll(WSStack.class);
                for (WSStack wSStack : collection) {
                    if (!wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public FileObject getConfigFilesFolder(boolean bl) {
        FileObject fileObject = null;
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
            if (fileObject != null) {
                fileObject = fileObject.getFileObject(CLIENT_CFG_FOLDER);
            }
            if (fileObject == null || !fileObject.isValid()) {
                try {
                    fileObject = sourceGroupArray[0].getRootFolder().createFolder(CLIENT_CFG_FOLDER);
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
            }
        }
        return fileObject;
    }

    public void addServiceDDEntry(String string, String string2, String string3) {
    }

    public boolean addMetroLibrary() {
        Library[] libraryArray = new Library[]{LibraryManager.getDefault().getLibrary("jaxws21")};
        Library library = LibraryManager.getDefault().getLibrary("metro");
        if (library != null) {
            try {
                SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
                if (sourceGroupArray != null && sourceGroupArray.length > 0) {
                    ProjectClassPathModifier.removeLibraries((Library[])libraryArray, (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
                    return ProjectClassPathModifier.addLibraries((Library[])new Library[]{library}, (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void createUser() {
        try {
            this.project.getProjectDirectory().getFileObject("nbproject").createData("wsit.createuser");
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, null, iOException);
        }
    }
}

