/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.ui.service.InputPanel;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.TargetsPanel;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class OutputPanel
extends SectionInnerPanel {
    private WSDLModel model;
    private BindingOperation operation;
    private BindingOutput output;
    private Binding binding;
    private UndoManager undoManager;
    private JButton targetsButton;

    public OutputPanel(SectionView sectionView, BindingOutput bindingOutput, UndoManager undoManager) {
        super(sectionView);
        this.model = bindingOutput.getModel();
        this.output = bindingOutput;
        this.operation = (BindingOperation)bindingOutput.getParent();
        this.binding = (Binding)this.operation.getParent();
        this.undoManager = undoManager;
        this.initComponents();
        this.sync();
        this.model.addComponentListener(new ComponentListener(){

            public void valueChanged(ComponentEvent componentEvent) {
                OutputPanel.this.sync();
            }

            public void childrenAdded(ComponentEvent componentEvent) {
                OutputPanel.this.sync();
            }

            public void childrenDeleted(ComponentEvent componentEvent) {
                OutputPanel.this.sync();
            }
        });
    }

    private void sync() {
        this.enableDisable();
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        SectionView sectionView = this.getSectionView();
        this.enableDisable();
        if (sectionView != null) {
            sectionView.getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return new JButton();
    }

    private void enableDisable() {
        boolean bl = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.binding);
        boolean bl2 = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)this.operation);
        String string = null;
        if (bl) {
            string = ProfilesModelHelper.getSecurityProfile((WSDLComponent)this.binding);
        }
        boolean bl3 = bl || bl2;
        this.targetsButton.setEnabled(bl3 && !ProfilesModelHelper.isSSLProfile(string));
    }

    private void initComponents() {
        this.targetsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.targetsButton, (String)NbBundle.getMessage(OutputPanel.class, (String)"LBL_SignEncrypt"));
        this.targetsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutputPanel.this.targetsButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.targetsButton).addContainerGap(156, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.targetsButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.targetsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OutputPanel.class, (String)"LBL_OutputPanel_MsgParts_ACSD"));
    }

    private void targetsButtonActionPerformed(ActionEvent actionEvent) {
        UndoCounter undoCounter = new UndoCounter();
        this.model.addUndoableEditListener((UndoableEditListener)undoCounter);
        TargetsPanel targetsPanel = new TargetsPanel((WSDLComponent)this.output);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)targetsPanel, NbBundle.getMessage(InputPanel.class, (String)"LBL_Targets_Panel_Title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!this.undoManager.canUndo()) continue;
                this.undoManager.undo();
            }
        } else {
            SecurityPolicyModelHelper.getInstance(PolicyModelHelper.getConfigVersion((WSDLComponent)this.binding)).setTargets((WSDLComponent)this.output, targetsPanel.getTargetsModel());
        }
        this.model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }
}

