/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.Kerberos;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class KerberosProfile
extends ProfileBase
implements SecureConversationFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    public int getId() {
        return 25;
    }

    public String getDisplayName() {
        return ComboConstants.PROF_KERBEROS;
    }

    public String getDescription() {
        return ComboConstants.PROF_KERBEROS_INFO;
    }

    public boolean isProfileSupported(Project project, WSDLComponent wSDLComponent, boolean bl) {
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(wSDLComponent);
        return ConfigVersion.CONFIG_1_3.equals((Object)configVersion);
    }

    public boolean isCurrentProfile(WSDLComponent wSDLComponent) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(wSDLComponent));
    }

    public void displayConfig(WSDLComponent wSDLComponent, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        wSDLModel.addUndoableEditListener((UndoableEditListener)undoCounter);
        Kerberos kerberos = new Kerberos(wSDLComponent, this);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)kerberos, this.getDisplayName());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        wSDLModel.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    public boolean isSecureConversation(WSDLComponent wSDLComponent) {
        ExtensibilityElement extensibilityElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(wSDLComponent);
        WSDLComponent wSDLComponent2 = SecurityTokensModelHelper.getTokenElement((WSDLComponent)extensibilityElement, ProtectionToken.class);
        WSDLComponent wSDLComponent3 = SecurityTokensModelHelper.getTokenTypeElement(wSDLComponent2);
        return wSDLComponent3 instanceof SecureConversationToken;
    }

    public void enableSecureConversation(WSDLComponent wSDLComponent, boolean bl) {
        ProfilesModelHelper profilesModelHelper = ProfilesModelHelper.getInstance(PolicyModelHelper.getConfigVersion(wSDLComponent));
        profilesModelHelper.setSecureConversation(wSDLComponent, bl);
    }
}

