/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.ServiceProviderElement;
import org.netbeans.modules.websvc.wsitconf.ui.service.subpanels.ServiceProviderSelectorPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.ServiceProvider;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ServiceProvidersTablePanel
extends DefaultTablePanel {
    private static final String[] columnName = new String[]{NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"MSG_ServiceProviders")};
    private ServiceProvidersTableModel tablemodel;
    private STSConfiguration stsConfig;
    private Map<String, ServiceProviderElement> addedProviders;
    private RemoveActionListener removeActionListener;
    private AddActionListener addActionListener;
    private EditActionListener editActionListener;
    private ConfigVersion cfgVersion;

    public ServiceProvidersTablePanel(ServiceProvidersTableModel serviceProvidersTableModel, STSConfiguration sTSConfiguration, ConfigVersion configVersion) {
        super((AbstractTableModel)serviceProvidersTableModel);
        this.stsConfig = sTSConfiguration;
        this.tablemodel = serviceProvidersTableModel;
        this.cfgVersion = configVersion;
        this.editButton.setVisible(true);
        this.addedProviders = new HashMap<String, ServiceProviderElement>();
        this.editActionListener = new EditActionListener();
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.editActionListener, (Object)this.editButton);
        this.editButton.addActionListener(actionListener);
        this.addActionListener = new AddActionListener();
        ActionListener actionListener2 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.addActionListener, (Object)this.addButton);
        this.addButton.addActionListener(actionListener2);
        this.removeActionListener = new RemoveActionListener();
        ActionListener actionListener3 = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.removeActionListener, (Object)this.removeButton);
        this.removeButton.addActionListener(actionListener3);
    }

    public List getChildren() {
        return this.tablemodel.getChildren();
    }

    public void populateModel() {
        this.tablemodel.setData(this.stsConfig);
    }

    public static class ServiceProvidersTableModel
    extends AbstractTableModel {
        List<ServiceProviderElement> children;

        public Object getValueAt(int n, int n2) {
            return this.children.get(n);
        }

        public int getRowCount() {
            if (this.children != null) {
                return this.children.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return columnName.length;
        }

        public void removeRow(int n) {
            this.children.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void addRow(ServiceProviderElement serviceProviderElement) {
            this.children.add(serviceProviderElement);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        public void setData(STSConfiguration sTSConfiguration) {
            this.children = new ArrayList<ServiceProviderElement>();
            List<ServiceProvider> list = ProprietarySecurityPolicyModelHelper.getSTSServiceProviders(sTSConfiguration);
            if (list != null && !list.isEmpty()) {
                for (ServiceProvider serviceProvider : list) {
                    String string = serviceProvider.getEndpoint();
                    String string2 = ProprietarySecurityPolicyModelHelper.getSPCertAlias(serviceProvider);
                    String string3 = ProprietarySecurityPolicyModelHelper.getSPTokenType(serviceProvider);
                    String string4 = ProprietarySecurityPolicyModelHelper.getSPKeyType(serviceProvider);
                    ServiceProviderElement serviceProviderElement = new ServiceProviderElement(string, string2, string3, string4);
                    this.children.add(serviceProviderElement);
                }
                this.fireTableDataChanged();
            }
        }

        public String getColumnName(int n) {
            return columnName[n];
        }

        public List getChildren() {
            return this.children;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServiceProvidersTablePanel.this.getTable().getSelectedRow();
            if (n == -1) {
                return;
            }
            ServiceProviderElement serviceProviderElement = (ServiceProviderElement)ServiceProvidersTablePanel.this.getTable().getValueAt(n, 0);
            ServiceProviderSelectorPanel serviceProviderSelectorPanel = new ServiceProviderSelectorPanel(serviceProviderElement.getEndpoint(), serviceProviderElement.getCertAlias(), serviceProviderElement.getTokenType(), serviceProviderElement.getKeyType());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)serviceProviderSelectorPanel, NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"LBL_SelectSProvider_Title"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(ServiceProviderSelectorPanel.class), null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(DialogDescriptor.OK_OPTION) && serviceProviderSelectorPanel != null) {
                String string = serviceProviderSelectorPanel.getSpUrl();
                String string2 = serviceProviderSelectorPanel.getCertAlias();
                String string3 = serviceProviderSelectorPanel.getTokenType();
                String string4 = serviceProviderSelectorPanel.getKeyType();
                ServiceProviderElement serviceProviderElement2 = new ServiceProviderElement(string, string2, string3, string4);
                ServiceProvidersTablePanel.this.addedProviders.put(string, serviceProviderElement2);
                ServiceProvidersTablePanel.this.tablemodel.removeRow(n);
                ServiceProvidersTablePanel.this.tablemodel.addRow(serviceProviderElement2);
                ProprietarySecurityPolicyModelHelper.removeSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, serviceProviderElement2);
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, serviceProviderElement2, ServiceProvidersTablePanel.this.cfgVersion);
            }
        }
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ServiceProviderSelectorPanel serviceProviderSelectorPanel = new ServiceProviderSelectorPanel(null, null, null, null);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)serviceProviderSelectorPanel, NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"LBL_SelectSProvider_Title"), true, 2, DialogDescriptor.CANCEL_OPTION, 0, new HelpCtx(ServiceProviderSelectorPanel.class), null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(DialogDescriptor.OK_OPTION) && serviceProviderSelectorPanel != null) {
                String string = serviceProviderSelectorPanel.getSpUrl();
                String string2 = serviceProviderSelectorPanel.getCertAlias();
                String string3 = serviceProviderSelectorPanel.getTokenType();
                String string4 = serviceProviderSelectorPanel.getKeyType();
                ServiceProviderElement serviceProviderElement = new ServiceProviderElement(string, string2, string3, string4);
                ServiceProvidersTablePanel.this.addedProviders.put(string, serviceProviderElement);
                ServiceProvidersTablePanel.this.tablemodel.addRow(serviceProviderElement);
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, serviceProviderElement, ServiceProvidersTablePanel.this.cfgVersion);
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ServiceProvidersTablePanel.this.getTable().getSelectedRow();
            if (n == -1) {
                return;
            }
            ServiceProviderElement serviceProviderElement = (ServiceProviderElement)ServiceProvidersTablePanel.this.getTable().getValueAt(n, 0);
            if (this.confirmDeletion(serviceProviderElement)) {
                ServiceProvidersTablePanel.this.addedProviders.remove(serviceProviderElement);
                ServiceProvidersTablePanel.this.tablemodel.removeRow(n);
                ProprietarySecurityPolicyModelHelper.removeSTSServiceProvider(ServiceProvidersTablePanel.this.stsConfig, serviceProviderElement);
            }
        }

        private boolean confirmDeletion(ServiceProviderElement serviceProviderElement) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ServiceProvidersTablePanel.class, (String)"MSG_ServiceProviderConfirmDelete", (Object)serviceProviderElement.getEndpoint()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

