/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.customizer.CustomizerSupport;
import org.netbeans.modules.tomcat5.util.EditableProperties;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TomcatProperties {
    private static final Logger LOGGER = Logger.getLogger(TomcatProperties.class.getName());
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String DEBUG_TYPE_SOCKET = "SEL_debuggingType_socket";
    public static final String DEBUG_TYPE_SHARED = "SEL_debuggingType_shared";
    public static final String BUNDLED_TOMCAT_SETTING = "J2EE/BundledTomcat/Setting";
    private static final String PROP_URL = "url";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";
    public static final String PROP_SERVER_PORT = "httpportnumber";
    private static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_SHUTDOWN = "admin_port";
    public static final String PROP_MONITOR = "monitor_enabled";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_CUSTOM_SCRIPT = "custom_script_enabled";
    private static final String PROP_SCRIPT_PATH = "script_path";
    private static final String PROP_FORCE_STOP = "forceStopOption";
    private static final String PROP_DEBUG_TYPE = "debug_type";
    private static final String PROP_DEBUG_PORT = "debugger_port";
    private static final String PROP_SHARED_MEM = "shared_memory";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_JAVA_OPTS = "java_opts";
    private static final String PROP_SEC_MANAGER = "securityStartupOption";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final String PROP_OPEN_LOG = "openContextLogOnRun";
    private static final String PROP_TIMESTAMP = "timestamp";
    private static final String PROP_HOST = "host";
    public static final String PROP_RUNNING_CHECK_TIMEOUT = "runningCheckTimeout";
    private static final String PROP_INSTANCE_ID = "instance_id";
    public static final String PROP_AUTOREGISTERED = "autoregistered";
    private static final String PROP_DRIVER_DEPLOYMENT = "driverDeploymentEnabled";
    private static final boolean DEF_VALUE_SEC_MANAGER = false;
    private static final boolean DEF_VALUE_CUSTOM_SCRIPT = false;
    private static final String DEF_VALUE_SCRIPT_PATH = "";
    private static final boolean DEF_VALUE_FORCE_STOP = false;
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final String DEF_VALUE_DEBUG_TYPE = Utilities.isWindows() ? "SEL_debuggingType_shared" : "SEL_debuggingType_socket";
    private static final boolean DEF_VALUE_MONITOR = true;
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private static final int DEF_VALUE_DEBUG_PORT = 11550;
    private static final int DEF_VALUE_DEBUG_PORT_BUNDLED = 11555;
    private static final int DEF_VALUE_SERVER_PORT = 8080;
    public static final int DEF_VALUE_SHUTDOWN_PORT = 8005;
    public static final int DEF_VALUE_BUNDLED_SERVER_PORT = 8084;
    public static final int DEF_VALUE_BUNDLED_SHUTDOWN_PORT = 8025;
    private static final String DEF_VALUE_SHARED_MEM = "tomcat_shared_memory_id";
    private static final boolean DEF_VALUE_OPEN_LOG = true;
    private static final String DEF_VALUE_HOST = "localhost";
    public static final int DEF_VALUE_RUNNING_CHECK_TIMEOUT = 2000;
    private static final String DEF_VALUE_DISPLAY_NAME = NbBundle.getMessage(TomcatProperties.class, (String)"LBL_DefaultDisplayName");
    private static final boolean DEF_VALUE_DRIVER_DEPLOYMENT = true;
    private static final int DEF_VALUE_DEPLOYMENT_TIMEOUT = 120;
    private TomcatManager tm;
    private InstanceProperties ip;
    private File homeDir;
    private File baseDir;

    public TomcatProperties(TomcatManager tomcatManager) throws IllegalArgumentException {
        this.tm = tomcatManager;
        this.ip = tomcatManager.getInstanceProperties();
        String string = null;
        String string2 = null;
        String string3 = this.ip.getProperty(PROP_URL);
        int n = string3.indexOf("http://");
        int n2 = string3.indexOf("home=") + "home=".length();
        int n3 = string3.indexOf(":base=", n2);
        if (n2 >= "home=".length()) {
            FileObject fileObject;
            int n4 = n3 > 0 ? n3 : (n > 0 ? n - 1 : string3.length());
            int n5 = n > 0 ? n - 1 : string3.length();
            string = string3.substring(n2, n4);
            if (n3 > 0) {
                string2 = string3.substring(n3 + ":base=".length(), n5);
            }
            if (string.length() > 0 && string.charAt(0) == '$' && (fileObject = FileUtil.getConfigFile((String)BUNDLED_TOMCAT_SETTING)) != null) {
                string = fileObject.getAttribute(string.substring(1)).toString();
                if (string2 != null && string2.length() > 0 && string2.charAt(0) == '$') {
                    string2 = fileObject.getAttribute(string2.substring(1)).toString();
                }
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("CATALINA_HOME must not be null.");
        }
        this.homeDir = new File(string);
        if (!this.homeDir.isAbsolute()) {
            InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
            this.homeDir = installedFileLocator.locate(string, null, false);
        }
        if (!this.homeDir.exists()) {
            throw new IllegalArgumentException("CATALINA_HOME directory does not exist.");
        }
        if (string2 != null) {
            this.baseDir = new File(string2);
            if (!this.baseDir.isAbsolute()) {
                InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                this.baseDir = installedFileLocator.locate(string2, null, false);
                if (this.baseDir == null) {
                    this.baseDir = new File(System.getProperty("netbeans.user"), string2);
                }
            }
        }
        this.ip.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TomcatProperties.PROP_SERVER_PORT.equals(string) || TomcatProperties.PROP_USERNAME.equals(string) || TomcatProperties.PROP_PASSWORD.equals(string)) {
                    try {
                        TomcatProperties.this.storeAntDeploymentProperties(TomcatProperties.this.getAntDeploymentPropertiesFile(), false);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, iOException);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAntDeploymentProperties(File file, boolean bl) throws IOException {
        if (!bl && !file.exists()) {
            return;
        }
        EditableProperties editableProperties = new EditableProperties();
        editableProperties.setProperty("tomcat.home", this.homeDir.getAbsolutePath());
        editableProperties.setProperty("tomcat.url", this.getWebUrl());
        editableProperties.setProperty("tomcat.username", this.getUsername());
        editableProperties.setProperty("tomcat.password", this.getPassword());
        file.createNewFile();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableProperties.store(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public File getAntDeploymentPropertiesFile() {
        return new File(System.getProperty("netbeans.user"), this.getInstanceID() + ".properties");
    }

    private String getInstanceID() {
        String string;
        String string2;
        String string3 = this.ip.getProperty(PROP_INSTANCE_ID);
        if (string3 != null) {
            return string3;
        }
        switch (this.tm.getTomcatVersion()) {
            case TOMCAT_60: {
                string2 = "tomcat60";
                string = "Tomcat60";
                break;
            }
            case TOMCAT_55: {
                string2 = "tomcat55";
                string = "Tomcat55";
                break;
            }
            default: {
                string2 = "tomcat50";
                string = "Tomcat";
            }
        }
        String[] stringArray = Deployment.getDefault().getInstancesOfServer(string);
        int n = 0;
        while (string3 == null) {
            string3 = n == 0 ? string2 : string2 + "_" + n;
            for (String string4 : stringArray) {
                String string5;
                InstanceProperties instanceProperties;
                if (this.tm.getUri().equals(string4) || (instanceProperties = InstanceProperties.getInstanceProperties((String)string4)) == null || !string3.equals(string5 = instanceProperties.getProperty(PROP_INSTANCE_ID))) continue;
                string3 = null;
                break;
            }
            ++n;
        }
        this.ip.setProperty(PROP_INSTANCE_ID, string3);
        return string3;
    }

    public String getWebUrl() {
        return "http://" + this.getHost() + ":" + this.getServerPort();
    }

    public File getCatalinaHome() {
        return this.homeDir;
    }

    public File getCatalinaBase() {
        return this.baseDir;
    }

    public File getCatalinaDir() {
        return this.baseDir == null ? this.homeDir : this.baseDir;
    }

    public File getLibsDir() {
        String string = this.tm.isTomcat50() || this.tm.isTomcat55() ? "common/lib" : "lib";
        return new File(this.getCatalinaHome(), string);
    }

    public File getMonitorLibFolder() {
        if (this.tm.isBundledTomcat()) {
            return new File(this.baseDir, "nblib");
        }
        return this.tm.isTomcat60() ? new File(this.homeDir, "lib") : new File(this.homeDir, "common/lib");
    }

    public File getJavaEndorsedDir() {
        if (TomcatManager.TomcatVersion.TOMCAT_60 == this.tm.getTomcatVersion()) {
            return new File(this.getCatalinaHome(), "endorsed");
        }
        return new File(this.getCatalinaHome(), "common/endorsed");
    }

    public String getUsername() {
        String string = this.ip.getProperty(PROP_USERNAME);
        return string != null ? string : "";
    }

    public void setUsername(String string) {
        this.ip.setProperty(PROP_USERNAME, string);
    }

    public String getPassword() {
        String string = this.ip.getProperty(PROP_PASSWORD);
        return string != null ? string : "";
    }

    public void setPassword(String string) {
        this.ip.setProperty(PROP_PASSWORD, string);
    }

    public JavaPlatform getJavaPlatform() {
        String string = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            String string2 = (String)javaPlatformArray[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatformArray[i];
        }
        return javaPlatformManager.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String string = this.ip.getProperty(PROP_JAVA_OPTS);
        return string != null ? string : "";
    }

    public void setJavaOpts(String string) {
        this.ip.setProperty(PROP_JAVA_OPTS, string);
    }

    public boolean getSecManager() {
        String string = this.ip.getProperty(PROP_SEC_MANAGER);
        return string != null ? Boolean.valueOf(string) : false;
    }

    public void setSecManager(boolean bl) {
        this.ip.setProperty(PROP_SEC_MANAGER, Boolean.toString(bl));
    }

    public boolean getCustomScript() {
        String string = this.ip.getProperty(PROP_CUSTOM_SCRIPT);
        return string != null ? Boolean.valueOf(string) : false;
    }

    public void setCustomScript(boolean bl) {
        this.ip.setProperty(PROP_CUSTOM_SCRIPT, Boolean.toString(bl));
    }

    public String getScriptPath() {
        String string = this.ip.getProperty(PROP_SCRIPT_PATH);
        return string != null ? string : "";
    }

    public void setScriptPath(String string) {
        this.ip.setProperty(PROP_SCRIPT_PATH, string);
    }

    public boolean getForceStop() {
        if (Utilities.isWindows()) {
            return false;
        }
        String string = this.ip.getProperty(PROP_FORCE_STOP);
        return string != null ? Boolean.valueOf(string) : false;
    }

    public void setForceStop(boolean bl) {
        this.ip.setProperty(PROP_FORCE_STOP, Boolean.toString(bl));
    }

    public String getDebugType() {
        String string = this.ip.getProperty(PROP_DEBUG_TYPE);
        if (DEBUG_TYPE_SHARED.equalsIgnoreCase(string) && Utilities.isWindows() || DEBUG_TYPE_SOCKET.equalsIgnoreCase(string)) {
            return string;
        }
        return DEF_VALUE_DEBUG_TYPE;
    }

    public void setDebugType(String string) {
        this.ip.setProperty(PROP_DEBUG_TYPE, string);
    }

    public boolean getMonitor() {
        String string = this.ip.getProperty(PROP_MONITOR);
        return string != null ? Boolean.valueOf(string) : true;
    }

    public void setMonitor(boolean bl) {
        this.ip.setProperty(PROP_MONITOR, Boolean.toString(bl));
    }

    public boolean getProxyEnabled() {
        String string = this.ip.getProperty(PROP_PROXY_ENABLED);
        return string != null ? Boolean.valueOf(string) : true;
    }

    public void setProxyEnabled(boolean bl) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(bl));
    }

    public int getDebugPort() {
        String string = this.ip.getProperty(PROP_DEBUG_PORT);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        if (this.tm.isBundledTomcat()) {
            return 11555;
        }
        return 11550;
    }

    public void setDebugPort(int n) {
        this.ip.setProperty(PROP_DEBUG_PORT, Integer.toString(n));
    }

    public int getServerPort() {
        String string = this.ip.getProperty(PROP_SERVER_PORT);
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && n <= 65535) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        return this.tm.isBundledTomcat() ? 8084 : 8080;
    }

    public void setServerPort(int n) {
        this.ip.setProperty(PROP_SERVER_PORT, Integer.toString(n));
    }

    public int getShutdownPort() {
        String string = this.ip.getProperty(PROP_SHUTDOWN);
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n >= 0 && n <= 65535) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        return this.tm.isBundledTomcat() ? 8025 : 8005;
    }

    public void setShutdownPort(int n) {
        this.ip.setProperty(PROP_SHUTDOWN, Integer.toString(n));
    }

    public String getSharedMem() {
        String string = this.ip.getProperty(PROP_SHARED_MEM);
        return string != null && string.length() > 0 ? string : DEF_VALUE_SHARED_MEM;
    }

    public void setSharedMem(String string) {
        this.ip.setProperty(PROP_SHARED_MEM, string);
    }

    public int getDeploymentTimeout() {
        String string = this.ip.getProperty("deploymentTimeout");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n >= 1) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        return 120;
    }

    public void setDeploymentTimeout(int n) {
        this.ip.setProperty("deploymentTimeout", Integer.toString(n));
    }

    public boolean getDriverDeployment() {
        String string = this.ip.getProperty(PROP_DRIVER_DEPLOYMENT);
        return string != null ? Boolean.valueOf(string) : true;
    }

    public void setDriverDeployment(boolean bl) {
        this.ip.setProperty(PROP_DRIVER_DEPLOYMENT, Boolean.toString(bl));
    }

    public List getClasses() {
        String[] stringArray = new String[]{"httpmonitor", "schema2beans", "jasper-compiler-jdt", "jasper-jdt"};
        String[] stringArray2 = new String[]{"-impl.jar"};
        List list = TomcatProperties.listUrls(new File(this.homeDir, this.tm.libFolder()), stringArray);
        if (this.tm.isTomcat60()) {
            try {
                list.add(new File(this.homeDir, "bin/tomcat-juli.jar").toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.WARNING, "$CATALINA_HOME/bin/tomcat-juli.jar not found", malformedURLException);
            }
        }
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "common/endorsed"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "shared/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxws/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxb/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jwsdp-shared/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxp/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxrpc/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jaxr/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "saaj/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "sjsxp/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.homeDir, "jstl/lib"), stringArray2));
        list.addAll(TomcatProperties.listUrls(new File(this.baseDir, "shared/lib"), stringArray));
        return list;
    }

    public List getSources() {
        String string = this.ip.getProperty(PROP_SOURCES);
        if (string == null) {
            return new ArrayList();
        }
        return CustomizerSupport.tokenizePath(string);
    }

    public void setSources(List list) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(list));
        this.tm.getTomcatPlatform().notifyLibrariesChanged();
    }

    public List getJavadocs() {
        String string = this.ip.getProperty(PROP_JAVADOCS);
        if (string == null) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            try {
                File file;
                File file2 = new File(this.homeDir, "webapps/tomcat-docs/jspapi");
                File file3 = new File(this.homeDir, "webapps/tomcat-docs/servletapi");
                if (file2.exists() && file3.exists()) {
                    arrayList.add(Utils.fileToUrl(file2));
                    arrayList.add(Utils.fileToUrl(file3));
                } else {
                    file = InstalledFileLocator.getDefault().locate("docs/javaee5-doc-api.zip", null, false);
                    if (file != null) {
                        arrayList.add(Utils.fileToUrl(file));
                    }
                }
                file = new File(this.homeDir, "docs/api");
                if (file.exists()) {
                    arrayList.add(Utils.fileToUrl(file));
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            return arrayList;
        }
        return CustomizerSupport.tokenizePath(string);
    }

    public void setJavadocs(List list) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(list));
        this.tm.getTomcatPlatform().notifyLibrariesChanged();
    }

    public void setOpenContextLogOnRun(boolean bl) {
        this.ip.setProperty(PROP_OPEN_LOG, Boolean.valueOf(bl).toString());
    }

    public boolean getOpenContextLogOnRun() {
        String string = this.ip.getProperty(PROP_OPEN_LOG);
        if (string != null) {
            return Boolean.valueOf(string.toString());
        }
        return true;
    }

    public void setTimestamp(long l) {
        this.ip.setProperty(PROP_TIMESTAMP, Long.toString(l));
    }

    public long getTimestamp() {
        String string = this.ip.getProperty(PROP_TIMESTAMP);
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        return -1L;
    }

    public File getServerXml() {
        String string = "conf/server.xml";
        File file = null;
        if (this.baseDir != null) {
            file = new File(this.baseDir, string);
        }
        if (file == null || !file.exists()) {
            file = new File(this.getCatalinaHome(), string);
        }
        return file;
    }

    public String getHost() {
        String string = this.ip.getProperty(PROP_HOST);
        return string != null ? string : DEF_VALUE_HOST;
    }

    public int getRunningCheckTimeout() {
        String string = this.ip.getProperty(PROP_RUNNING_CHECK_TIMEOUT);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(TomcatProperties.class.getName()).log(Level.INFO, null, numberFormatException);
            }
        }
        return 2000;
    }

    public String getDisplayName() {
        String string = this.ip.getProperty(PROP_DISPLAY_NAME);
        return string != null && string.length() > 0 ? string : DEF_VALUE_DISPLAY_NAME;
    }

    private static List listUrls(final File file, final String[] stringArray) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file2, String string) {
                if (!string.endsWith(".jar") || !file2.equals(file)) {
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (string.indexOf(stringArray[i]) == -1) continue;
                    return false;
                }
                return true;
            }
        });
        if (fileArray == null) {
            return new ArrayList();
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                arrayList.add(Utils.fileToUrl(fileArray[i]));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList;
    }
}

