/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TomcatUsers {
    private TomcatUsers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUser(File file, String string, String string2) throws IOException {
        String string3;
        Document document = TomcatUsers.getDocument(file);
        Element element = document.getDocumentElement();
        Element element2 = TomcatUsers.findUserByName(element, string);
        if (element2 == null) {
            element2 = document.createElement("user");
            element2.setAttribute("username", string);
        }
        if ((string3 = element2.getAttribute("roles")) == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(string3.trim());
        if (!TomcatUsers.hasRole(string3, "manager")) {
            if (stringBuilder.length() > 0 && !stringBuilder.toString().endsWith(",")) {
                stringBuilder.append(',');
            }
            stringBuilder.append("manager");
        }
        if (!TomcatUsers.hasRole(string3, "admin")) {
            if (!stringBuilder.toString().endsWith(",")) {
                stringBuilder.append(',');
            }
            stringBuilder.append("admin");
        }
        element2.setAttribute("roles", stringBuilder.toString());
        element2.setAttribute("password", string2);
        element.appendChild(element2);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            throw new IOException(NbBundle.getMessage(TomcatUsers.class, (String)"MSG_FileNotFound", (Object)file.getPath()));
        }
        OutputStream outputStream = fileObject.getOutputStream();
        try {
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
        }
        finally {
            outputStream.close();
        }
    }

    public static boolean hasManagerRole(File file, String string) throws IOException {
        Document document = TomcatUsers.getDocument(file);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("user");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("name");
            if (string3.length() == 0) {
                string3 = element2.getAttribute("username");
            }
            if (!string.equals(string3) || !TomcatUsers.hasRole(string2 = element2.getAttribute("roles"), "manager")) continue;
            return true;
        }
        return false;
    }

    public static boolean userExists(File file, String string) throws IOException {
        Document document = TomcatUsers.getDocument(file);
        return TomcatUsers.findUserByName(document.getDocumentElement(), string) != null;
    }

    private static Document getDocument(File file) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            throw new IOException(NbBundle.getMessage(TomcatUsers.class, (String)"MSG_FileNotFound", (Object)file.getPath()));
        }
        XMLDataObject xMLDataObject = (XMLDataObject)DataObject.find((FileObject)fileObject);
        try {
            return xMLDataObject.getDocument();
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException().initCause(sAXException);
        }
    }

    private static Element findUserByName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("user");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = element2.getAttribute("name");
            if (string2.length() == 0) {
                string2 = element2.getAttribute("username");
            }
            if (!string.equals(string2)) continue;
            return element2;
        }
        return null;
    }

    private static boolean hasRole(String string, String string2) {
        for (String string3 : string.split(",")) {
            if (!string2.equals(string3.trim())) continue;
            return true;
        }
        return false;
    }
}

