/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatUsers;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class InstallPanelVisual
extends JPanel {
    private static final String SERVER_XML = "conf/server.xml";
    private final List listeners = new ArrayList();
    private final TomcatManager.TomcatVersion tomcatVersion;
    private String errorMessage;
    private boolean infoMessage;
    private String serverPort;
    private String shutdownPort;
    private RequestProcessor.Task validationTask;
    private JCheckBox createUserCheckBox;
    private JButton jButtonBaseBrowse;
    private JButton jButtonHomeBrowse;
    private JCheckBox jCheckBoxShared;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelBaseDir;
    private JLabel jLabelHomeDir;
    private JLabel jLabelPassword;
    private JLabel jLabelUsername;
    private JTextField jTextFieldBaseDir;
    private JTextField jTextFieldHomeDir;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldUsername;

    public InstallPanelVisual(TomcatManager.TomcatVersion tomcatVersion) {
        this.tomcatVersion = tomcatVersion;
        this.initComponents();
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InstallPanelVisual.this.fireChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InstallPanelVisual.this.fireChange();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InstallPanelVisual.this.fireChange();
            }
        };
        this.jTextFieldHomeDir.getDocument().addDocumentListener(documentListener);
        this.jTextFieldBaseDir.getDocument().addDocumentListener(documentListener);
        this.jTextFieldUsername.getDocument().addDocumentListener(documentListener);
        this.jTextFieldPassword.getDocument().addDocumentListener(documentListener);
        this.createUserCheckBox.getModel().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                InstallPanelVisual.this.fireChange();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (InstallPanelVisual.this.isJWSDP()) {
                    if (InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                        InstallPanelVisual.this.jCheckBoxShared.setEnabled(false);
                        InstallPanelVisual.this.setBaseEnabled(false);
                    }
                } else if (!InstallPanelVisual.this.jCheckBoxShared.isEnabled()) {
                    InstallPanelVisual.this.jCheckBoxShared.setEnabled(true);
                    if (InstallPanelVisual.this.jCheckBoxShared.isSelected()) {
                        InstallPanelVisual.this.setBaseEnabled(true);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    private void initComponents() {
        this.jLabelHomeDir = new JLabel();
        this.jLabelBaseDir = new JLabel();
        this.jTextFieldHomeDir = new JTextField();
        this.jTextFieldBaseDir = new JTextField();
        this.jButtonBaseBrowse = new JButton();
        this.jButtonHomeBrowse = new JButton();
        this.jCheckBoxShared = new JCheckBox();
        this.jLabelUsername = new JLabel();
        this.jLabelPassword = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jTextFieldUsername = new JTextField();
        this.jLabel2 = new JLabel();
        this.createUserCheckBox = new JCheckBox();
        this.setName(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_InstallationAndLoginDetails"));
        this.jLabelHomeDir.setLabelFor(this.jTextFieldHomeDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelHomeDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_home_dir"));
        this.jLabelBaseDir.setLabelFor(this.jTextFieldBaseDir);
        Mnemonics.setLocalizedText((JLabel)this.jLabelBaseDir, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_base_dir"));
        this.jLabelBaseDir.setEnabled(false);
        this.jTextFieldHomeDir.setColumns(15);
        this.jTextFieldBaseDir.setColumns(15);
        this.jTextFieldBaseDir.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBaseBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_base"));
        this.jButtonBaseBrowse.setEnabled(false);
        this.jButtonBaseBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanelVisual.this.jButtonBaseBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonHomeBrowse, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_file_chooser_home"));
        this.jButtonHomeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanelVisual.this.jButtonHomeBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShared, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_SharedInstall"));
        this.jCheckBoxShared.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallPanelVisual.this.jCheckBoxSharedActionPerformed(actionEvent);
            }
        });
        this.jLabelUsername.setLabelFor(this.jTextFieldUsername);
        Mnemonics.setLocalizedText((JLabel)this.jLabelUsername, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Username"));
        this.jLabelUsername.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.jLabelPassword.setLabelFor(this.jTextFieldPassword);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPassword, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Password"));
        this.jLabelPassword.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_TextAbove"));
        this.jTextFieldPassword.setColumns(20);
        this.jTextFieldUsername.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_Credentials"));
        this.jLabel2.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createUserCheckBox, (String)NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUser"));
        this.createUserCheckBox.setToolTipText(NbBundle.getMessage(InstallPanelVisual.class, (String)"LBL_CreateUserToolTip"));
        this.createUserCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.createUserCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jCheckBoxShared).add((Component)this.jLabel2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelUsername).add((Component)this.jLabelPassword).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabelBaseDir)).add((Component)this.jLabelHomeDir)).add(5, 5, 5).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.createUserCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jTextFieldBaseDir, -1, 252, Short.MAX_VALUE).add(2, (Component)this.jTextFieldHomeDir, -1, 252, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jButtonHomeBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonBaseBrowse, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldPassword, 0, 0, Short.MAX_VALUE).add(1, (Component)this.jTextFieldUsername, -1, 129, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabelHomeDir)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonHomeBrowse).add((Component)this.jTextFieldHomeDir, -2, -1, -2)))).add(5, 5, 5).add((Component)this.jCheckBoxShared).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabelBaseDir)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldBaseDir, -2, -1, -2).add((Component)this.jButtonBaseBrowse)))).add(14, 14, 14).add((Component)this.jLabel2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(7, 7, 7).add((Component)this.jLabelUsername)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(5, 5, 5).add((Component)this.jTextFieldUsername, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelPassword).add((Component)this.jTextFieldPassword, -2, -1, -2)).addPreferredGap(0).add((Component)this.createUserCheckBox).addContainerGap(51, Short.MAX_VALUE)));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelHomeDir"));
        this.jLabelHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelHomeDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelBaseDir"));
        this.jLabelBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelBaseDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_homeDir"));
        this.jTextFieldHomeDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_homeDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_baseDir"));
        this.jTextFieldBaseDir.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_baseDir"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonBaseBrowse"));
        this.jButtonBaseBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonBaseBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_ButtonHomeBrowse"));
        this.jButtonHomeBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_ButtonHomeBrowse"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_shared"));
        this.jCheckBoxShared.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_shared"));
        this.jLabelUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelUsername"));
        this.jLabelUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelUsername"));
        this.jLabelPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_labelPassword"));
        this.jLabelPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_labelPassword"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_password"));
        this.jTextFieldPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_password"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_username"));
        this.jTextFieldUsername.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_username"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_NAME_panel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallPanelVisual.class, (String)"A11Y_DESC_panel"));
    }

    private void jButtonBaseBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(this.jTextFieldBaseDir.getText().trim()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.jTextFieldBaseDir.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jButtonHomeBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(this.jTextFieldHomeDir.getText().trim()));
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.jTextFieldHomeDir.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.fireChange();
        }
    }

    private void jCheckBoxSharedActionPerformed(ActionEvent actionEvent) {
        this.setBaseEnabled(this.jCheckBoxShared.isSelected());
        this.fireChange();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put("httpportnumber", this.serverPort);
        properties.put("admin_port", this.shutdownPort);
        properties.put("monitor_enabled", "false");
        return properties;
    }

    public TomcatManager.TomcatVersion getTomcatVersion() {
        return this.tomcatVersion;
    }

    public String getUrl() {
        String string;
        switch (this.tomcatVersion) {
            case TOMCAT_60: {
                string = "tomcat60:";
                break;
            }
            case TOMCAT_55: {
                string = "tomcat55:";
                break;
            }
            default: {
                string = "tomcat:";
            }
        }
        string = string + "home=" + this.jTextFieldHomeDir.getText();
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            string = string + ":base=" + this.jTextFieldBaseDir.getText();
        }
        Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.FINE, "TomcatInstall.getUrl: " + string);
        return string;
    }

    public String getUsername() {
        return this.jTextFieldUsername.getText();
    }

    public String getPassword() {
        return new String(this.jTextFieldPassword.getPassword());
    }

    boolean createUserEnabled() {
        return this.createUserCheckBox.isSelected();
    }

    public File getHomeDir() {
        return new File(this.jTextFieldHomeDir.getText());
    }

    private File getBaseDir() {
        File[] fileArray;
        File file;
        if (this.jCheckBoxShared.isSelected() && (file = new File(this.jTextFieldBaseDir.getText())).isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            return file;
        }
        return new File(this.jTextFieldHomeDir.getText());
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : "<html>" + this.errorMessage.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
    }

    public boolean isInfoMessage() {
        return this.infoMessage;
    }

    boolean isServerXmlValid(File file) {
        try {
            Server server = Server.createGraph(file);
            this.serverPort = TomcatInstallUtil.getPort(server);
            this.shutdownPort = TomcatInstallUtil.getShutdownPort(server);
            if (this.serverPort != null && this.shutdownPort != null) {
                Integer.parseInt(this.serverPort);
                Integer.parseInt(this.shutdownPort);
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, iOException);
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, numberFormatException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(InstallPanelVisual.class.getName()).log(Level.INFO, null, runtimeException);
        }
        return false;
    }

    private boolean isHomeValid() {
        File file;
        Object object;
        File file2;
        String string = this.jTextFieldHomeDir.getText();
        if (string.length() == 0) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyHomeDir");
            this.infoMessage = true;
            return false;
        }
        if (!new File(string, "bin/bootstrap.jar").exists()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        File file3 = file2 = TomcatManager.TomcatVersion.TOMCAT_60.equals((Object)this.tomcatVersion) ? new File(string, "lib") : new File(string, "common" + File.separator + "lib");
        if (!file2.exists() || !file2.isDirectory()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidHomeDir");
            return false;
        }
        boolean bl = false;
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() && ((String)(object = this.jTextFieldBaseDir.getText())).length() != 0 && (file = new File((String)object, SERVER_XML)).exists()) {
            bl = true;
        }
        object = new File(string, SERVER_XML);
        if (!bl && !((File)object).canRead()) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
            return false;
        }
        if (!(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() || this.isServerXmlValid((File)object))) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
            return false;
        }
        return true;
    }

    private boolean isJWSDP() {
        File file;
        if (this.isHomeValid() && (file = this.getHomeDir()) != null && file.exists()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return "jwsdp-shared".equals(string);
                }
            });
            return fileArray.length != 0;
        }
        return false;
    }

    private boolean isBaseValid() {
        if (this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected()) {
            String string = this.jTextFieldBaseDir.getText();
            if (string.length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_SpecifyBaseDir");
                this.infoMessage = true;
                return false;
            }
            File file = new File(string);
            String[] stringArray = file.list();
            File file2 = new File(file, SERVER_XML);
            if (!file.exists() || stringArray == null || stringArray.length > 0 && !file2.exists()) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_InvalidBaseDir");
                return false;
            }
            if (stringArray.length > 0) {
                if (!file2.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableBaseServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(file2)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedBaseServerXml");
                    return false;
                }
            } else {
                File file3 = new File(this.jTextFieldHomeDir.getText(), SERVER_XML);
                if (!file3.canRead()) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_NonReadableHomeServerXml");
                    return false;
                }
                if (!this.isServerXmlValid(file3)) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_CorruptedHomeServerXml");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isUsernamePasswordValid() {
        if (this.createUserCheckBox.isSelected()) {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmpty");
                this.infoMessage = true;
                return false;
            }
            if (this.jTextFieldPassword.getPassword().length == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_PasswordEmpty");
                this.infoMessage = true;
                return false;
            }
        } else {
            if (this.jTextFieldUsername.getText().length() == 0) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UsernameEmptyWarning");
                this.infoMessage = true;
            }
            File file = new File(this.getBaseDir(), "conf/tomcat-users.xml");
            try {
                if (!TomcatUsers.userExists(file, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserDoesNotExist");
                } else if (!TomcatUsers.hasManagerRole(file, this.jTextFieldUsername.getText())) {
                    this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_UserHasNotManagerRole");
                }
            }
            catch (IOException iOException) {
                this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)"MSG_MissingOrInvalidTomcatUsersXml", (Object)file.getPath());
            }
        }
        return true;
    }

    private boolean isAlreadyRegistered() {
        if (InstanceProperties.getInstanceProperties((String)this.getUrl()) != null) {
            this.errorMessage = NbBundle.getMessage(InstallPanelVisual.class, (String)(this.jCheckBoxShared.isEnabled() && this.jCheckBoxShared.isSelected() ? "MSG_AlreadyRegisteredBase" : "MSG_AlreadyRegisteredHome"));
            return true;
        }
        return false;
    }

    private void setBaseEnabled(boolean bl) {
        this.jLabelBaseDir.setEnabled(bl);
        this.jTextFieldBaseDir.setEnabled(bl);
        this.jButtonBaseBrowse.setEnabled(bl);
    }

    public boolean hasValidData() {
        this.errorMessage = null;
        this.infoMessage = false;
        return this.isHomeValid() && this.isBaseValid() && !this.isAlreadyRegistered() && this.isUsernamePasswordValid();
    }

    private void fireChange() {
        if (this.validationTask == null) {
            this.validationTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList arrayList;
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    ChangeEvent changeEvent = new ChangeEvent(this);
                    Object object = InstallPanelVisual.this.listeners;
                    synchronized (object) {
                        arrayList = new ArrayList(InstallPanelVisual.this.listeners);
                    }
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        ((ChangeListener)object.next()).stateChanged(changeEvent);
                    }
                }
            });
        }
        this.validationTask.schedule(60);
    }
}

