/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.api;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EjbJarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";

    private EjbJarProjectGenerator() {
    }

    public static AntProjectHelper createProject(File file, String string, String string2, String string3) throws IOException {
        return EjbJarProjectGenerator.createProject(file, string, string2, string3, null, null);
    }

    public static AntProjectHelper createProject(File file, final String string, final String string2, final String string3, final String string4, final String string5) throws IOException {
        final FileObject fileObject = FileUtil.createFolder((File)file);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = EjbJarProjectGenerator.createProjectImpl(fileObject, string, string2, string3, string4, string5);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper createProjectImpl(FileObject fileObject, String string, String string2, final String string3, String string4, final String string5) throws IOException {
        FileObject fileObject2 = fileObject.createFolder(DEFAULT_SRC_FOLDER);
        fileObject2.createFolder(DEFAULT_JAVA_FOLDER);
        fileObject.createFolder(DEFAULT_TEST_FOLDER);
        FileObject fileObject3 = fileObject2.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-ejbjarproject/MANIFEST.MF"), (FileObject)fileObject3, (String)"MANIFEST");
        String string6 = EjbJarProjectGenerator.configureServerLibrary(string4, string3, fileObject, string5 != null);
        final AntProjectHelper antProjectHelper = EjbJarProjectGenerator.setupProject(fileObject, string, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, string2, string3, string4, string6);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.put("source.root", DEFAULT_SRC_FOLDER);
        editableProperties.setProperty("meta.inf", "${source.root}/conf");
        editableProperties.setProperty("src.dir", "${source.root}/java");
        editableProperties.setProperty("meta.inf.excludes", "sun-cmp-mappings.xml");
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject((Project)ejbJarProject);
        final ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EjbJarProjectGenerator.copyRequiredLibraries(antProjectHelper, referenceHelper, string3, string5);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException.getException());
        }
        if (!"1.5".equals(string2)) {
            String string7 = "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml";
            FileObject fileObject4 = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)string7), (FileObject)fileObject3, (String)"ejb-jar");
            EjbJar ejbJar = DDProvider.getDefault().getDDRoot(fileObject4);
            ejbJar.setDisplayName(string);
            ejbJar.write(fileObject4);
        }
        return antProjectHelper;
    }

    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3, boolean bl) throws IOException {
        return EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, bl, null, null);
    }

    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3, boolean bl, String string4, String string5) throws IOException {
        AntProjectHelper antProjectHelper = EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, string4, string5);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        editableProperties.setProperty("java.source.based", bl + "");
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    public static AntProjectHelper importProject(File file, String string, File[] fileArray, File[] fileArray2, File file2, File file3, String string2, String string3) throws IOException {
        return EjbJarProjectGenerator.importProject(file, string, fileArray, fileArray2, file2, file3, string2, string3, null, null);
    }

    public static AntProjectHelper importProject(File file, final String string, final File[] fileArray, final File[] fileArray2, final File file2, final File file3, final String string2, final String string3, final String string4, final String string5) throws IOException {
        final FileObject fileObject = FileUtil.createFolder((File)file);
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper antProjectHelper;
                antProjectHelperArray[0] = antProjectHelper = EjbJarProjectGenerator.importProjectImpl(fileObject, string, fileArray, fileArray2, file2, file3, string2, string3, string4, string5);
            }
        });
        return antProjectHelperArray[0];
    }

    private static AntProjectHelper importProjectImpl(FileObject fileObject, String string, final File[] fileArray, final File[] fileArray2, File file, File file2, String string2, final String string3, String string4, final String string5) throws IOException {
        assert (fileArray != null && fileArray2 != null) : "Package roots can't be null";
        String string6 = EjbJarProjectGenerator.configureServerLibrary(string4, string3, fileObject, string5 != null);
        final AntProjectHelper antProjectHelper = EjbJarProjectGenerator.setupProject(fileObject, string, null, null, file, file2 == null ? null : file2, null, string2, string3, string4, string6);
        final EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(fileObject);
        final ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties editableProperties;
                    Element element;
                    String string;
                    String string2;
                    int n;
                    Element element2 = antProjectHelper.getPrimaryConfigurationData(true);
                    Document document = element2.getOwnerDocument();
                    NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    assert (nodeList.getLength() == 1);
                    Element element3 = (Element)nodeList.item(0);
                    nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
                    assert (nodeList.getLength() == 1);
                    Element element4 = (Element)nodeList.item(0);
                    for (n = 0; n < fileArray.length; ++n) {
                        string2 = "src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                        string = referenceHelper.createForeignFileReference(fileArray[n], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                        element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                        element.setAttribute("id", string2);
                        element3.appendChild(element);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.put(string2, string);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                    }
                    if (fileArray2.length == 0) {
                        EditableProperties editableProperties2 = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties2.put("test.src.dir", "");
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties2);
                    } else {
                        for (n = 0; n < fileArray2.length; ++n) {
                            if (!fileArray2[n].exists()) {
                                FileUtil.createFolder((File)fileArray2[n]);
                            }
                            string2 = "test.src.dir" + (n == 0 ? "" : Integer.toString(n + 1));
                            string = referenceHelper.createForeignFileReference(fileArray2[n], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                            element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                            element.setAttribute("id", string2);
                            element4.appendChild(element);
                            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put(string2, string);
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        }
                    }
                    antProjectHelper.putPrimaryConfigurationData(element2, true);
                    EjbJarProjectGenerator.copyRequiredLibraries(antProjectHelper, referenceHelper, string3, string5);
                    ProjectManager.getDefault().saveProject((Project)ejbJarProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            IOException iOException = new IOException("project creation failed");
            iOException.initCause(mutexException);
            throw iOException;
        }
        FileObject fileObject2 = FileUtil.toFileObject((File)file).getFileObject("ejb-jar.xml");
        if (fileObject2 != null) {
            try {
                String string7;
                EjbJar ejbJar = DDProvider.getDefault().getDDRoot(fileObject2);
                boolean bl = false;
                if (new BigDecimal("2.0").equals(ejbJar.getVersion()) && string2.equals("1.4")) {
                    ejbJar.setVersion(new BigDecimal("2.1"));
                    bl = true;
                }
                if (null == (string7 = ejbJar.getDefaultDisplayName()) || string7.trim().length() == 0) {
                    ejbJar.setDisplayName(string);
                    bl = true;
                }
                if (bl) {
                    ejbJar.write(fileObject2);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return antProjectHelper;
    }

    private static void copyRequiredLibraries(AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, String string, String string2) throws IOException {
        if (!antProjectHelper.isSharableProject()) {
            return;
        }
        if (referenceHelper.getProjectLibraryManager().getLibrary("junit") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (referenceHelper.getProjectLibraryManager().getLibrary("junit_4") == null) {
            referenceHelper.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)antProjectHelper, (ReferenceHelper)referenceHelper);
    }

    private static String configureServerLibrary(final String string, final String string2, final FileObject fileObject, boolean bl) {
        String string3 = null;
        if (string != null && bl) {
            try {
                string3 = (String)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<String>(){

                    public String run() throws Exception {
                        return SharabilityUtility.findOrCreateLibrary((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)fileObject), (String)string), (String)string2).getName();
                    }
                });
            }
            catch (MutexException mutexException) {
                Exceptions.printStackTrace((Throwable)mutexException.getException());
            }
        }
        return string3;
    }

    private static String createFileReference(ReferenceHelper referenceHelper, FileObject fileObject, FileObject fileObject2) {
        if (FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            return EjbJarProjectGenerator.relativePath(fileObject, fileObject2);
        }
        return referenceHelper.createForeignFileReference(FileUtil.toFile((FileObject)fileObject2), null);
    }

    private static String relativePath(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2.equals(fileObject)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) {
            throw new IllegalArgumentException("Cannot find relative path, " + fileObject + " is not parent of " + fileObject2);
        }
        return fileObject2.getPath().substring(fileObject.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject fileObject, String string, String string2, String string3, File file, File file2, String string4, String string5, String string6, String string7, String string8) throws IOException {
        File[] fileArray;
        Object object;
        String string9;
        Element element;
        Element element2;
        Utils.logUI(NbBundle.getBundle(EjbJarProjectGenerator.class), "UI_EJB_PROJECT_CREATE_SHARABILITY", new Object[]{string7 != null, string8 != null});
        AntProjectHelper antProjectHelper = ProjectGenerator.createProject((FileObject)fileObject, (String)"org.netbeans.modules.j2ee.ejbjarproject", (String)string7);
        EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
        ReferenceHelper referenceHelper = ejbJarProject.getReferenceHelper();
        Element element3 = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element3.getOwnerDocument();
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
        element4.appendChild(document.createTextNode(string));
        element3.appendChild(element4);
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "minimum-ant-version");
        element5.appendChild(document.createTextNode(MINIMUM_ANT_VERSION));
        element3.appendChild(element5);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        Element element6 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
        if (string2 != null) {
            element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            element2.setAttribute("id", "src.dir");
            element2.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_src.dir"));
            element6.appendChild(element2);
            editableProperties.setProperty("src.dir", string2);
        }
        element3.appendChild(element6);
        element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
        if (string3 != null) {
            element = document.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            element.setAttribute("id", "test.src.dir");
            element.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_test.src.dir"));
            element2.appendChild(element);
            editableProperties.setProperty("test.src.dir", string3);
        }
        element3.appendChild(element2);
        antProjectHelper.putPrimaryConfigurationData(element3, true);
        if (string4 != null) {
            editableProperties.setProperty("resource.dir", string4);
        } else {
            editableProperties.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        element = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion specificationVersion = element.getSpecification().getVersion();
        String string10 = specificationVersion.toString();
        if (string10.equals("1.6") || string10.equals("1.7")) {
            string10 = "1.5";
        }
        editableProperties.setProperty("javac.source", string10);
        editableProperties.setProperty("javac.target", string10);
        editableProperties.setProperty("dist.dir", "dist");
        editableProperties.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        editableProperties.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        editableProperties.setProperty("j2ee.platform", string5);
        editableProperties.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)string) + ".jar");
        editableProperties.setProperty("jar.compress", "false");
        Deployment deployment = Deployment.getDefault();
        editableProperties.setProperty("j2ee.server.type", deployment.getServerID(string6));
        if (antProjectHelper.isSharableProject() && string8 != null) {
            editableProperties.setProperty("javac.classpath", "${libs." + string8 + "." + "classpath" + "}");
            EjbJarProjectGenerator.setServerProperties(editableProperties, string8);
        } else {
            editableProperties.setProperty("javac.classpath", "");
        }
        boolean bl = false;
        try {
            bl = Deployment.getDefault().getServerInstance(string6).isDeployOnSaveSupported();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            // empty catch block
        }
        editableProperties.setProperty("j2ee.deploy.on.save", Boolean.toString(bl));
        editableProperties.setProperty("javac.debug", "true");
        editableProperties.setProperty("javac.deprecation", "false");
        editableProperties.setProperty("javac.test.classpath", new String[]{"${javac.classpath}:", "${build.classes.dir}:", "${libs.junit.classpath}:", "${libs.junit_4.classpath}"});
        editableProperties.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        editableProperties.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        editableProperties.setProperty("build.dir", DEFAULT_BUILD_DIR);
        editableProperties.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        editableProperties.setProperty("build.test.results.dir", "${build.dir}/test/results");
        editableProperties.setProperty("build.generated.dir", "${build.dir}/generated");
        editableProperties.setProperty("build.classes.dir", "${build.dir}/jar");
        editableProperties.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        editableProperties.setProperty("build.ear.classes.dir", "${build.dir}/jar");
        editableProperties.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        editableProperties.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        editableProperties.setProperty("platform.active", "default_platform");
        editableProperties.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        editableProperties.setProperty("javadoc.private", "false");
        editableProperties.setProperty("javadoc.notree", "false");
        editableProperties.setProperty("javadoc.use", "true");
        editableProperties.setProperty("javadoc.nonavbar", "false");
        editableProperties.setProperty("javadoc.noindex", "false");
        editableProperties.setProperty("javadoc.splitindex", "true");
        editableProperties.setProperty("javadoc.author", "false");
        editableProperties.setProperty("javadoc.version", "false");
        editableProperties.setProperty("javadoc.windowtitle", "");
        editableProperties.setProperty("javadoc.encoding", "${source.encoding}");
        editableProperties.setProperty("javadoc.preview", "true");
        editableProperties.setProperty("javadoc.additionalparam", "");
        editableProperties.setProperty("runmain.jvmargs", "");
        editableProperties.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        Charset charset = FileEncodingQuery.getDefaultEncoding();
        editableProperties.setProperty("source.encoding", charset.name());
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        if (file != null) {
            string9 = EjbJarProjectGenerator.createFileReference(referenceHelper, fileObject, FileUtil.toFileObject((File)file));
            object = antProjectHelper.getProperties("nbproject/project.properties");
            object.setProperty("meta.inf", string9);
            antProjectHelper.putProperties("nbproject/project.properties", object);
        }
        if (file2 != null) {
            string9 = EjbJarProjectGenerator.createFileReference(referenceHelper, fileObject, FileUtil.toFileObject((File)file2));
            object = antProjectHelper.getProperties("nbproject/project.properties");
            object.setProperty("lib.dir", string9);
            antProjectHelper.putProperties("nbproject/project.properties", object);
        }
        editableProperties = antProjectHelper.getProperties("nbproject/private/private.properties");
        editableProperties.setProperty("j2ee.server.instance", string6);
        string9 = Deployment.getDefault().getJ2eePlatform(string6);
        if (!string9.getSupportedSpecVersions(J2eeModule.EJB).contains(string5)) {
            Logger.getLogger("global").log(Level.WARNING, "J2EE level:" + string5 + " not supported by server " + Deployment.getDefault().getServerInstanceDisplayName(string6) + " for module type EJB");
        }
        if (!antProjectHelper.isSharableProject() || string8 == null) {
            object = Utils.toClasspathString(string9.getClasspathEntries());
            editableProperties.setProperty("j2ee.platform.classpath", (String)object);
            if (string9.isToolSupported("wscompile")) {
                fileArray = string9.getToolClasspathEntries("wscompile");
                editableProperties.setProperty("j2ee.platform.wscompile.classpath", Utils.toClasspathString(fileArray));
            }
            if (string9.isToolSupported("wsimport")) {
                fileArray = string9.getToolClasspathEntries("wsimport");
                editableProperties.setProperty("j2ee.platform.wsimport.classpath", Utils.toClasspathString(fileArray));
            }
            if (string9.isToolSupported("wsgen")) {
                fileArray = string9.getToolClasspathEntries("wsgen");
                editableProperties.setProperty("j2ee.platform.wsgen.classpath", Utils.toClasspathString(fileArray));
            }
            if (string9.isToolSupported("wsit")) {
                fileArray = string9.getToolClasspathEntries("wsit");
                editableProperties.setProperty("j2ee.platform.wsit.classpath", Utils.toClasspathString(fileArray));
            }
            if (string9.isToolSupported("jwsdp")) {
                fileArray = string9.getToolClasspathEntries("jwsdp");
                editableProperties.setProperty("j2ee.platform.jwsdp.classpath", Utils.toClasspathString(fileArray));
            }
        }
        object = FileUtil.toFile((FileObject)fileObject);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File((File)object, "nbproject/ant-deploy.xml"), (Object)J2eeModule.EJB, (String)string6);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        fileArray = AntDeploymentHelper.getDeploymentPropertiesFile((String)string6);
        if (fileArray != null) {
            editableProperties.setProperty("deploy.ant.properties.file", fileArray.getAbsolutePath());
        }
        antProjectHelper.putProperties("nbproject/private/private.properties", editableProperties);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    public static void setServerProperties(EditableProperties editableProperties, String string) {
        editableProperties.setProperty("j2ee.platform.classpath", "${libs." + string + "." + "classpath" + "}");
        editableProperties.setProperty("j2ee.platform.wscompile.classpath", "${libs." + string + "." + "wscompile" + "}");
        editableProperties.setProperty("j2ee.platform.wsimport.classpath", "${libs." + string + "." + "wsimport" + "}");
        editableProperties.setProperty("j2ee.platform.wsgen.classpath", "${libs." + string + "." + "wsgenerate" + "}");
        editableProperties.setProperty("j2ee.platform.wsit.classpath", "${libs." + string + "." + "wsinterop" + "}");
        editableProperties.setProperty("j2ee.platform.jwsdp.classpath", "${libs." + string + "." + "wsjwsdp" + "}");
    }

    public static void setPlatform(final AntProjectHelper antProjectHelper, final String string, final String string2) {
        FileObject fileObject = antProjectHelper.getProjectDirectory();
        if (fileObject == null) {
            return;
        }
        try {
            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        public void run() {
                            try {
                                EjbJarProject ejbJarProject = (EjbJarProject)ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory());
                                UpdateHelper updateHelper = ejbJarProject.getUpdateHelper();
                                EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                                String string = string;
                                if (string == null) {
                                    string = JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
                                }
                                PlatformUiSupport.storePlatform((EditableProperties)editableProperties, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/j2ee-ejbjarproject/3", (String)string, (SpecificationVersion)(string2 != null ? new SpecificationVersion(string2) : null));
                                antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(antProjectHelper.getProjectDirectory()));
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }
}

