/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.migration.archiver.deserializer;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.ArrayListStack;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.BaseSpecificXMLDeserializer;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.NewInstanceHelper;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XMLGraphDeserializer
extends BaseSpecificXMLDeserializer
implements Serializable {
    public static final int XGD_END = 99;
    public static final int XGD_NEED_ATTRIBUTE = 1;
    public static final int XGD_NEED_END_ATTR = 2;
    public static final int XGD_NEED_END_NULLVALUE = 4;
    public static final int XGD_NEED_END_OBJECT = 5;
    public static final int XGD_NEED_END_PARAM = 10;
    public static final int XGD_NEED_END_ROW = 3;
    public static final int XGD_NEED_END_ROW_ELEMENT = 14;
    public static final int XGD_NEED_OBJECT = 7;
    public static final int XGD_NEED_PARAM = 9;
    public static final int XGD_NEED_ROW = 6;
    public static final int XGD_NEED_ROW_ELEMENT = 13;
    public static final int XGD_NEED_ROW_TAG = 12;
    public static final int XGD_NEED_STRING = 11;
    public static final int XGD_NEED_VALUE = 8;
    private HashMap ObjectHash;
    private ArrayListStack AttrNameStack;
    ArrayListStack RowTypeStack;
    private ArrayListStack RowCountStack;
    private HashMap hashedClasses = new HashMap();

    public XMLGraphDeserializer(ClassLoader classLoader) {
        super(classLoader);
        this.AttrNameStack = new ArrayListStack();
        this.ObjectHash = new HashMap(20);
        this.RowTypeStack = new ArrayListStack();
        this.RowCountStack = new ArrayListStack();
    }

    public XMLGraphDeserializer() {
        this(null);
    }

    private Field findField(Object object, final String string) {
        Field field = null;
        Class<?> clazz = object.getClass();
        HashMap<String, Field> hashMap = (HashMap<String, Field>)this.hashedClasses.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap<String, Field>();
            this.hashedClasses.put(clazz, hashMap);
        } else {
            field = (Field)hashMap.get(string);
        }
        while (clazz != null && field == null) {
            final Class<?> clazz2 = clazz;
            field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Field field = clazz2.getDeclaredField(string);
                        if (field != null) {
                            field.setAccessible(true);
                        }
                        return field;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        return null;
                    }
                }
            });
            if (field != null) {
                hashMap.put(string, field);
                break;
            }
            clazz = clazz.getSuperclass();
        }
        return field;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.State = new Integer(99);
    }

    public void endElement(String string) throws SAXException {
        int n = this.State;
        try {
            if (string.equals("ARRAY")) {
                this.popRowCount();
            }
            if (!string.equals("_.ALIAS")) {
                switch (this.State) {
                    case 1: {
                        this.validateTag(string, "OBJECT", true);
                        this.popState();
                        break;
                    }
                    case 2: {
                        String string2 = this.topAttrName();
                        this.validateTag(this.unescapeName(string), string2, true);
                        Object object = this.popObject();
                        this.setCurrentAttribute(object);
                        this.popAttrName();
                        this.popState();
                        break;
                    }
                    case 10: {
                        this.validateTag(string, "PARAM", true);
                        break;
                    }
                    case 3: {
                        this.validateTag(string, "ROW", true);
                        this.popState();
                        Object object = this.popObject();
                        Object object2 = this.topObject();
                        if (object2 instanceof Collection) {
                            Collection collection = (Collection)object2;
                            collection.add(object);
                            break;
                        }
                        if (!object2.getClass().isArray()) break;
                        int n2 = this.currentRowCount();
                        Array.set(object2, n2, object);
                        this.incrementRowCount();
                        break;
                    }
                    case 4: {
                        this.validateTag(string, "NULLVALUE", true);
                        this.popState();
                        break;
                    }
                    case 5: {
                        this.validateTag(string, "OBJECT", true);
                        this.popState();
                        break;
                    }
                    case 9: {
                        this.popState();
                        break;
                    }
                    case 6: {
                        this.validateTag(string, "ARRAY", true);
                        this.popState();
                        this.popRowType();
                        break;
                    }
                    case 8: {
                        this.popState();
                        String string3 = null;
                        String string4 = this.getCharacters();
                        int n3 = string4.length();
                        if (n3 != 0 || n3 != 1) {
                            string3 = string4;
                        }
                        switch (this.State) {
                            case 3: {
                                this.validateTag(string, "ROW", true);
                                Collection collection = (Collection)this.topObject();
                                Object e = null;
                                Class clazz = this.topRowType();
                                if (clazz == String.class) {
                                    String string5 = string3;
                                    collection.add(string5);
                                } else {
                                    collection.add(e);
                                }
                                this.popState();
                                break;
                            }
                            case 2: {
                                this.validateTag(this.unescapeName(string), this.topAttrName(), true);
                                this.setCurrentAttribute(string3);
                                this.popAttrName();
                                this.popState();
                                break;
                            }
                            case 10: {
                                this.popState();
                                this.pushState(9);
                            }
                        }
                        break;
                    }
                    case 11: {
                        this.popState();
                        break;
                    }
                    case 14: {
                        this.State = new Integer(13);
                        break;
                    }
                    case 13: {
                        this.State = new Integer(12);
                        break;
                    }
                    case 12: {
                        this.popState();
                        break;
                    }
                    case 7: {
                        this.unexpectedTag(string, "OBJECT", false);
                    }
                }
            }
            super.endElement(string);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.endElement");
            System.out.println("Tag being process is " + string + " initial state was " + n);
            this.DumpStatus();
            throw sAXException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.endElement");
            System.out.println("Tag being process is " + string + " initial state was " + n);
            this.DumpStatus();
            throw runtimeException;
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.State = new Integer(99);
        this.pushState(7);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        int n = this.State;
        try {
            if (string.equals("ARRAY")) {
                this.pushRowCount();
            }
            if (string.equals("_.ALIAS")) {
                String string2 = attributeList.getValue("NAME");
                String string3 = attributeList.getValue("ALIAS");
                this.addActiveAlias(string2, string3);
            } else {
                switch (this.State) {
                    case 1: {
                        this.readAttributeHeader(string, attributeList);
                        break;
                    }
                    case 12: {
                        this.State = new Integer(13);
                        break;
                    }
                    case 13: {
                        this.State = new Integer(14);
                        break;
                    }
                    case 6: {
                        this.validateTag(string, "ROW", false);
                        if (this.checkSimpleRow(string, attributeList)) {
                            this.pushState(3);
                            break;
                        }
                        this.pushState(3);
                        this.pushState(8);
                        break;
                    }
                    case 7: {
                        this.validateTag(string, "OBJECT", false);
                        this.readObjectHeader(string, attributeList, false);
                        break;
                    }
                    case 9: {
                        this.popState();
                        this.pushState(10);
                        this.pushState(8);
                        break;
                    }
                    case 8: {
                        if (!(string.equals("OBJECT") || string.equals("ARRAY") || string.equals("NULLVALUE"))) {
                            this.unexpectedTag(string, "OBJECT, ARRAY, NULLVALUE", false);
                        }
                        this.readValue(string, attributeList);
                        break;
                    }
                    case 2: {
                        this.unexpectedTag(string, this.topAttrName(), true);
                        break;
                    }
                    case 10: {
                        this.unexpectedTag(string, "/PARAM", false);
                        break;
                    }
                    case 3: {
                        this.unexpectedTag(string, "/ROW", false);
                        break;
                    }
                    case 4: {
                        this.unexpectedTag(string, "/NULLVALUE", false);
                        break;
                    }
                    case 5: {
                        this.unexpectedTag(string, "/OBJECT", false);
                    }
                }
            }
            super.startElement(string, attributeList);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.startElement");
            System.out.println("Tag being process is " + string + " initial state was " + n);
            System.out.println("Attribute list is :");
            for (int i = 0; i < attributeList.getLength(); ++i) {
                System.out.println("Attribute " + attributeList.getName(i) + " Type " + attributeList.getType(i) + " value " + attributeList.getValue(i));
            }
            this.DumpStatus();
            throw sAXException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            System.out.println("Exception cause in XMLGraphDeserializer.startElement");
            System.out.println("Tag being process is " + string + " initial state was " + n);
            System.out.println("Attribute list is :");
            for (int i = 0; i < attributeList.getLength(); ++i) {
                System.out.println("Attribute " + attributeList.getName(i) + " Type " + attributeList.getType(i) + " value " + attributeList.getValue(i));
            }
            this.DumpStatus();
            throw runtimeException;
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return super.findClass(this.lookupAlias(string));
    }

    public String popAttrName() {
        return (String)this.AttrNameStack.pop();
    }

    public void processObjectReference(String string) throws SAXException {
        Object v = this.ObjectHash.get(string);
        if (v == null) {
            String string2 = "Object " + string + " could not be found";
            SAXException sAXException = new SAXException(string2);
            throw sAXException;
        }
        this.pushObject(v);
    }

    public void pushAttrName(String string) {
        this.AttrNameStack.push(string);
    }

    public void readAttributeHeader(String string, AttributeList attributeList) {
        if (string == "_.METHOD" || string == "_.CALLBACK") {
            this.pushAttrName(attributeList.getValue("NAME"));
            this.pushAttrName(string);
            this.pushState(9);
            this.ParameterArray.clear();
        } else {
            this.pushAttrName(this.unescapeName(string));
            this.pushState(2);
            this.pushState(8);
        }
    }

    public void readObjectHeader(String string, AttributeList attributeList, boolean bl) throws SAXException {
        String string2;
        boolean bl2 = this.ObjectStack.size() == 0;
        Object object = null;
        String string3 = null;
        if (bl && (string2 = attributeList.getValue("REFERENCE")) != null) {
            this.processObjectReference(string2);
            this.State = new Integer(5);
            return;
        }
        string3 = attributeList.getValue("ID");
        if (bl2 || !this.useExistingAttribute(attributeList, this.topAttrName(), object)) {
            string2 = attributeList.getValue("CLASS");
            if (string2 == null) {
                object = null;
            } else {
                Class clazz = null;
                try {
                    clazz = this.findClass(string2);
                    object = WrapperClassHelper.isWrapperClass(clazz) ? new WrapperClassHelper(clazz, string3) : clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    String string4 = "Illegal Access to class " + clazz.getName();
                    SAXException sAXException = new SAXException(string4);
                    throw sAXException;
                }
                catch (InstantiationException instantiationException) {
                    object = NewInstanceHelper.newInstance(string2, this.topObject());
                    if (object == null) {
                        instantiationException.printStackTrace();
                        String string5 = "Instantiation exception of class " + clazz.getName();
                        SAXException sAXException = new SAXException(string5);
                        throw sAXException;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    String string6 = "Class " + clazz.getName() + " could not be found";
                    SAXException sAXException = new SAXException(string6);
                    throw sAXException;
                }
            }
        }
        this.pushObject(object);
        if (string3 != null) {
            this.ObjectHash.put(string3, object);
        }
        if (bl2) {
            this.MasterDeserializer.setInitialObject(object);
        }
        this.State = object == null ? new Integer(5) : new Integer(1);
    }

    public String topAttrName() {
        return (String)this.AttrNameStack.peek();
    }

    public void readValue(String string, AttributeList attributeList) throws SAXException {
        boolean bl;
        boolean bl2 = bl = this.ObjectStack.size() == 0;
        if (string.equals("OBJECT")) {
            this.readObjectHeader(string, attributeList, true);
        } else if (string.equals("ARRAY")) {
            Object object = null;
            Class clazz = null;
            Object object2 = null;
            String string2 = attributeList.getValue("CLASS");
            int n = Integer.parseInt(attributeList.getValue("SIZE"));
            String string3 = attributeList.getValue("ROWCLASS");
            if (!string2.equals("PRIMITIVE")) {
                try {
                    Class clazz2 = this.findClass(string2);
                    object2 = clazz2.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    String string4 = "Class " + string2 + " could not be found, " + "either it has the wrong name or cannot be found in lookup table";
                    SAXException sAXException = new SAXException(string4);
                    throw sAXException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    String string5 = "Illegal Access exception whilst trying to init new instance of " + string2;
                    SAXException sAXException = new SAXException(string5);
                    throw sAXException;
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    String string6 = "Instantiation exception whilst trying to init new instance of " + string2;
                    SAXException sAXException = new SAXException(string6);
                    throw sAXException;
                }
            }
            if (!bl && this.useExistingAttribute(attributeList, this.topAttrName(), object)) {
                object2 = object;
            }
            if (string3 != null && !string3.equals("")) {
                try {
                    clazz = this.findClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    String string7 = "Class " + string3 + " could not be found, " + "either it has the wrong name or cannot be found in lookup table";
                    SAXException sAXException = new SAXException(string7);
                    throw sAXException;
                }
            } else {
                clazz = Object.class;
            }
            if (string2.equals("PRIMITIVE")) {
                object2 = Array.newInstance(clazz, n);
            }
            this.pushRowType(clazz);
            this.pushObject(object2);
            this.State = new Integer(6);
        } else if (string.equals("NULLVALUE")) {
            Object object = null;
            Field field = null;
            try {
                object = this.topObject();
                field = this.findField(object, this.topAttrName());
                if (field == null) {
                    this.pushObject(new Object());
                } else {
                    this.pushObject(field.getType().newInstance());
                }
                this.State = new Integer(4);
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                String string8 = "Could not init instance of " + field.getType().getName();
                SAXException sAXException = new SAXException(string8);
                throw sAXException;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                String string9 = "Illegal access of field " + this.topAttrName();
                SAXException sAXException = new SAXException(string9);
                throw sAXException;
            }
        }
    }

    public void pushRowType(Class clazz) {
        this.RowTypeStack.push(clazz);
    }

    public Class popRowType() {
        return (Class)this.RowTypeStack.pop();
    }

    public void setCurrentAttribute(Object object) throws SAXException {
        Object object2 = this.topObject();
        String string = this.topAttrName();
        if (object2 instanceof WrapperClassHelper) {
            WrapperClassHelper wrapperClassHelper = (WrapperClassHelper)object2;
            object2 = wrapperClassHelper.valueOf((String)object);
            this.popObject();
            this.pushObject(object2);
            String string2 = wrapperClassHelper.getId();
            if (string2 != null) {
                this.ObjectHash.put(string2, object2);
            }
            return;
        }
        Field field = null;
        try {
            field = this.findField(object2, string);
            if (field == null) {
                return;
            }
            Class<?> clazz = field.getType();
            if (clazz.isPrimitive() && object instanceof String) {
                if (clazz == Integer.TYPE) {
                    field.setInt(object2, Integer.parseInt((String)object));
                } else if (clazz == Short.TYPE) {
                    field.setShort(object2, Short.parseShort((String)object));
                } else if (clazz == Long.TYPE) {
                    field.setLong(object2, Long.parseLong((String)object));
                } else if (clazz == Byte.TYPE) {
                    field.setByte(object2, Byte.parseByte((String)object));
                } else if (clazz == Double.TYPE) {
                    field.setDouble(object2, Double.parseDouble((String)object));
                } else if (clazz == Float.TYPE) {
                    field.setFloat(object2, Float.parseFloat((String)object));
                } else if (clazz == Boolean.TYPE) {
                    field.setBoolean(object2, Boolean.valueOf((String)object));
                } else if (clazz == Character.TYPE) {
                    field.setChar(object2, ((String)object).charAt(0));
                }
            } else if (clazz.isArray() && object instanceof ArrayList) {
                Class<?> clazz2 = clazz.getComponentType();
                ArrayList arrayList = (ArrayList)object;
                Object object3 = Array.newInstance(clazz2, arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Array.set(object3, i, arrayList.get(i));
                }
                field.set(object2, object3);
            } else {
                field.set(object2, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            String string3 = "Illegal access of field " + string;
            SAXException sAXException = new SAXException(string3);
            throw sAXException;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            String string4 = "Security Exception accessing fields of" + object2.getClass().getName();
            SAXException sAXException = new SAXException(string4);
            throw sAXException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public Class topRowType() {
        return (Class)this.RowTypeStack.peek();
    }

    private boolean checkSimpleRow(String string, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string2 = attributeList.getValue("ROWCLASS");
        String string3 = attributeList.getValue("VALUE");
        if (string2 != null && !string2.equals("")) {
            bl = true;
            if (string2.equals("java.lang.String")) {
                this.pushObject(string3);
            } else if (string2.equals("java.lang.StringBuffer")) {
                this.pushObject(new StringBuffer(string3));
            } else if (string2.equals("int") || string2.equals("java.lang.Integer")) {
                this.pushObject(Integer.valueOf(string3));
            } else if (string2.equals("short") || string2.equals("java.lang.Short")) {
                this.pushObject(Short.valueOf(string3));
            } else if (string2.equals("long") || string2.equals("java.lang.Long")) {
                this.pushObject(Long.valueOf(string3));
            } else if (string2.equals("float") || string2.equals("java.lang.Float")) {
                this.pushObject(Float.valueOf(string3));
            } else if (string2.equals("double") || string2.equals("java.lang.Double")) {
                this.pushObject(Double.valueOf(string3));
            } else if (string2.equals("boolean") || string2.equals("java.lang.Boolean")) {
                this.pushObject(Boolean.valueOf(string3));
            } else if (string2.equals("char") || string2.equals("java.lang.Character")) {
                this.pushObject(new Character(string3.charAt(0)));
            } else {
                System.out.println("Found and unknow type in a row");
                this.pushObject(null);
            }
        }
        return bl;
    }

    public void DumpStatus() {
        super.DumpStatus();
        System.out.println("Dump Status from class XMLGraphSerializer");
        System.out.println("Row Type stack " + this.RowTypeStack);
        System.out.println("Row Counter stack " + this.RowCountStack);
        System.out.println("Object hash table " + this.ObjectHash);
        System.out.println("Dump Status from class XMLGraphSerializer - END");
    }

    private void pushRowCount() {
        Integer n = new Integer(0);
        this.RowCountStack.push(n);
    }

    private void popRowCount() {
        this.RowCountStack.pop();
    }

    private int currentRowCount() {
        Integer n = (Integer)this.RowCountStack.peek();
        return n;
    }

    private void incrementRowCount() {
        Integer n = (Integer)this.RowCountStack.pop();
        int n2 = n;
        this.RowCountStack.push(new Integer(++n2));
    }

    private static class WrapperClassHelper {
        private static final Map converters = new HashMap(8);
        private Class wrapperClass;
        private String id;

        public WrapperClassHelper(Class clazz, String string) {
            this.wrapperClass = clazz;
            this.id = string;
        }

        public String getId() {
            return this.id;
        }

        public Object valueOf(String string) {
            Converter converter = (Converter)converters.get(this.wrapperClass);
            return converter != null ? converter.valueOf(string) : null;
        }

        public static boolean isWrapperClass(Class clazz) {
            return converters.containsKey(clazz);
        }

        static {
            converters.put(Boolean.class, new Converter(){

                public Object valueOf(String string) {
                    return Boolean.valueOf(string);
                }
            });
            converters.put(Byte.class, new Converter(){

                public Object valueOf(String string) {
                    return Byte.valueOf(string);
                }
            });
            converters.put(Short.class, new Converter(){

                public Object valueOf(String string) {
                    return Short.valueOf(string);
                }
            });
            converters.put(Character.class, new Converter(){

                public Object valueOf(String string) {
                    return new Character(string.charAt(0));
                }
            });
            converters.put(Integer.class, new Converter(){

                public Object valueOf(String string) {
                    return Integer.valueOf(string);
                }
            });
            converters.put(Long.class, new Converter(){

                public Object valueOf(String string) {
                    return Long.valueOf(string);
                }
            });
            converters.put(Float.class, new Converter(){

                public Object valueOf(String string) {
                    return Float.valueOf(string);
                }
            });
            converters.put(Double.class, new Converter(){

                public Object valueOf(String string) {
                    return Double.valueOf(string);
                }
            });
        }

        private static interface Converter {
            public Object valueOf(String var1);
        }
    }
}

