/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.RepositoryIndexerListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.sonatype.nexus.index.ArtifactAvailablility;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.GroupedSearchRequest;
import org.sonatype.nexus.index.GroupedSearchResponse;
import org.sonatype.nexus.index.Grouping;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.SearchEngine;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.JarFileContentsIndexCreator;
import org.sonatype.nexus.index.creator.MinimalArtifactInfoIndexCreator;
import org.sonatype.nexus.index.search.grouping.GGrouping;
import org.sonatype.nexus.index.updater.DefaultIndexUpdater;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final String MAVENINDEX_PATH = "mavenindex";
    private ArtifactRepository repository;
    private NexusIndexer indexer;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private WagonManager wagonManager;
    private boolean inited = false;
    private static final String NB_DEPENDENCY_GROUP = "nbdg";
    private static final String NB_DEPENDENCY_ARTIFACT = "nbda";
    private static final String NB_DEPENDENCY_VERSION = "nbdv";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.maven.indexer.RepositoryIndexer");
    static final Mutex MUTEX = new Mutex();
    private Lookup lookup = Lookups.singleton((Object)this);
    private List<? extends IndexCreator> CREATORS;
    private static final int MAX_RESULT_COUNT = 512;

    private List<? extends IndexCreator> getLocalRepoIndexCreators() {
        if (this.CREATORS == null) {
            this.CREATORS = Arrays.asList(new MinimalArtifactInfoIndexCreator(), new JarFileContentsIndexCreator(), new NbIndexCreator());
        }
        return this.CREATORS;
    }

    public static String createLocalRepositoryPath(FileObject fileObject) {
        return EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir();
    }

    @Override
    public String getType() {
        return "nexus";
    }

    @Override
    public Lookup getCapabilityLookup() {
        return this.lookup;
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration defaultContainerConfiguration = new DefaultContainerConfiguration();
                ClassWorld classWorld = new ClassWorld();
                ClassRealm classRealm = classWorld.newRealm("maven.embedder", MavenEmbedder.class.getClassLoader());
                ClassRealm classRealm2 = classWorld.newRealm("maven.indexer", NexusRepositoryIndexerImpl.class.getClassLoader());
                ClassRealm classRealm3 = classWorld.newRealm("plexus.core", NexusRepositoryIndexerImpl.class.getClassLoader());
                classRealm3.importFrom(classRealm.getId(), "META-INF/plexus");
                classRealm3.importFrom(classRealm.getId(), "META-INF/maven");
                classRealm3.importFrom(classRealm2.getId(), "META-INF/plexus");
                classRealm3.importFrom(classRealm2.getId(), "META-INF/maven");
                defaultContainerConfiguration.setClassWorld(classWorld);
                DefaultPlexusContainer defaultPlexusContainer = new DefaultPlexusContainer((ContainerConfiguration)defaultContainerConfiguration);
                this.repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
                this.indexer = (NexusIndexer)defaultPlexusContainer.lookup(NexusIndexer.class);
                this.searcher = (SearchEngine)defaultPlexusContainer.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)defaultPlexusContainer.lookup(IndexUpdater.class);
                this.wagonManager = (WagonManager)defaultPlexusContainer.lookup(WagonManager.class);
                this.contextProducer = (ArtifactContextProducer)defaultPlexusContainer.lookup(ArtifactContextProducer.class);
                this.inited = true;
            }
            catch (DuplicateRealmException duplicateRealmException) {
                Exceptions.printStackTrace((Throwable)duplicateRealmException);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                Exceptions.printStackTrace((Throwable)noSuchRealmException);
            }
            catch (ComponentLookupException componentLookupException) {
                Exceptions.printStackTrace((Throwable)componentLookupException);
            }
            catch (PlexusContainerException plexusContainerException) {
                Exceptions.printStackTrace((Throwable)plexusContainerException);
            }
        }
    }

    private void loadIndexingContext(RepositoryInfo ... repositoryInfoArray) throws IOException {
        assert (MUTEX.isWriteAccess());
        this.initIndexer();
        for (RepositoryInfo repositoryInfo : repositoryInfoArray) {
            Object object;
            IndexingContext indexingContext = this.indexer.getIndexingContexts().get(repositoryInfo.getId());
            if (indexingContext != null) {
                object = indexingContext.getIndexUpdateUrl();
                String string = repositoryInfo.getIndexUpdateUrl();
                File file = indexingContext.getRepository();
                File file2 = repositoryInfo.getRepositoryPath() != null ? new File(repositoryInfo.getRepositoryPath()) : null;
                if (object == null != (string == null) || object != null && !((String)object).equals(string)) {
                    LOGGER.fine("Remote context changed:" + repositoryInfo.getId() + ", unload/load");
                    this.unloadIndexingContext(repositoryInfo);
                } else if (file == null != (file2 == null) || file != null && !file.equals(file2)) {
                    LOGGER.fine("Local context changed:" + repositoryInfo.getId() + ", unload/load");
                    this.unloadIndexingContext(repositoryInfo);
                } else {
                    LOGGER.fine("Skipping Context :" + repositoryInfo.getId() + ", already loaded.");
                    continue;
                }
            }
            LOGGER.fine("Loading Context :" + repositoryInfo.getId());
            if (!repositoryInfo.isLocal() && !repositoryInfo.isRemoteDownloadable()) continue;
            object = new File(this.getDefaultIndexLocation(), repositoryInfo.getId());
            boolean bl = false;
            if (!((File)object).exists() || ((File)object).listFiles().length <= 0) {
                bl = true;
                LOGGER.finer("Index Not Available :" + repositoryInfo.getId() + " At :" + ((File)object).getAbsolutePath());
            }
            try {
                this.indexer.addIndexingContextForced(repositoryInfo.getId(), repositoryInfo.getId(), repositoryInfo.isLocal() ? new File(repositoryInfo.getRepositoryPath()) : null, (File)object, repositoryInfo.isRemoteDownloadable() ? repositoryInfo.getRepositoryUrl() : null, repositoryInfo.isRemoteDownloadable() ? repositoryInfo.getIndexUpdateUrl() : null, repositoryInfo.isLocal() ? this.getLocalRepoIndexCreators() : NexusIndexer.FULL_INDEX);
            }
            catch (IOException iOException) {
                LOGGER.info("Found a broken index at " + ((File)object).getAbsolutePath());
                LOGGER.log(Level.FINE, "Caused by ", iOException);
                FileUtils.deleteDirectory((File)object);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NexusRepositoryIndexerImpl.class, (String)"MSG_Reconstruct_Index"));
                this.indexer.addIndexingContextForced(repositoryInfo.getId(), repositoryInfo.getId(), repositoryInfo.isLocal() ? new File(repositoryInfo.getRepositoryPath()) : null, (File)object, repositoryInfo.isRemoteDownloadable() ? repositoryInfo.getRepositoryUrl() : null, repositoryInfo.isRemoteDownloadable() ? repositoryInfo.getIndexUpdateUrl() : null, repositoryInfo.isLocal() ? this.getLocalRepoIndexCreators() : NexusIndexer.FULL_INDEX);
            }
            if (!bl) continue;
            this.indexLoadedRepo(repositoryInfo, true);
        }
        HashSet hashSet = new HashSet();
        for (RepositoryInfo repositoryInfo : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            hashSet.add(repositoryInfo.getId());
        }
        HashSet<String> hashSet2 = new HashSet<String>(this.indexer.getIndexingContexts().keySet());
        hashSet2.removeAll(hashSet);
        if (!hashSet2.isEmpty()) {
            this.unloadIndexingContext((Set<String>)hashSet2);
        }
    }

    private Collection<IndexingContext> getContexts(RepositoryInfo[] repositoryInfoArray) {
        assert (MUTEX.isWriteAccess());
        ArrayList<IndexingContext> arrayList = new ArrayList<IndexingContext>();
        for (RepositoryInfo repositoryInfo : repositoryInfoArray) {
            IndexingContext indexingContext = this.indexer.getIndexingContexts().get(repositoryInfo.getId());
            if (indexingContext != null) {
                arrayList.add(indexingContext);
                continue;
            }
            if (!repositoryInfo.isLocal() && !repositoryInfo.isRemoteDownloadable()) continue;
            LOGGER.info("The context '" + repositoryInfo.getId() + "' isn't loaded. Please file under component: maven in NetBeans issue tracking system");
        }
        return arrayList;
    }

    private void unloadIndexingContext(RepositoryInfo ... repositoryInfoArray) throws IOException {
        assert (MUTEX.isWriteAccess());
        for (RepositoryInfo repositoryInfo : repositoryInfoArray) {
            LOGGER.finer("Unloading Context :" + repositoryInfo.getId());
            IndexingContext indexingContext = this.indexer.getIndexingContexts().get(repositoryInfo.getId());
            if (indexingContext == null) continue;
            this.indexer.removeIndexingContext(indexingContext, false);
        }
    }

    private void unloadIndexingContext(Set<String> set) throws IOException {
        assert (MUTEX.isWriteAccess());
        for (String string : set) {
            LOGGER.fine("Unloading Context :" + string);
            IndexingContext indexingContext = this.indexer.getIndexingContexts().get(string);
            if (indexingContext == null) continue;
            this.indexer.removeIndexingContext(indexingContext, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexLoadedRepo(RepositoryInfo repositoryInfo, boolean bl) {
        block12: {
            assert (MUTEX.isWriteAccess());
            try {
                Map<String, IndexingContext> map = this.indexer.getIndexingContexts();
                IndexingContext indexingContext = map.get(repositoryInfo.getId());
                if (indexingContext == null) {
                    LOGGER.info("Indexing context could not be found :" + repositoryInfo.getId());
                    return;
                }
                if (repositoryInfo.isRemoteDownloadable()) {
                    LOGGER.finer("Indexing Remote Repository :" + repositoryInfo.getId());
                    RemoteIndexTransferListener remoteIndexTransferListener = new RemoteIndexTransferListener(repositoryInfo);
                    try {
                        IndexUpdateRequest indexUpdateRequest = new IndexUpdateRequest(indexingContext);
                        indexUpdateRequest.setResourceFetcher(new DefaultIndexUpdater.WagonFetcher(this.wagonManager, remoteIndexTransferListener, null));
                        this.remoteIndexUpdater.fetchAndUpdateIndex(indexUpdateRequest);
                        break block12;
                    }
                    finally {
                        remoteIndexTransferListener.transferCompleted(null);
                    }
                }
                LOGGER.finer("Indexing Local Repository :" + repositoryInfo.getId());
                this.indexer.scan(indexingContext, new RepositoryIndexerListener(this.indexer, indexingContext), bl);
            }
            catch (IOException iOException) {
                LOGGER.warning(iOException.getMessage());
            }
            finally {
                RepositoryPreferences.getInstance().setLastIndexUpdate(repositoryInfo.getId(), new Date());
                this.fireChangeIndex(repositoryInfo);
            }
        }
    }

    @Override
    public void indexRepo(final RepositoryInfo repositoryInfo) {
        LOGGER.finer("Indexing Context :" + repositoryInfo);
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    NexusRepositoryIndexerImpl.this.initIndexer();
                    IndexingContext indexingContext = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repositoryInfo.getId());
                    if (indexingContext != null) {
                        NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(indexingContext, true);
                    }
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repositoryInfo});
                    NexusRepositoryIndexerImpl.this.indexLoadedRepo(repositoryInfo, false);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
        }
    }

    public void shutdownAll() {
        LOGGER.finer("Shutting Down All Contexts");
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    if (NexusRepositoryIndexerImpl.this.inited) {
                        for (IndexingContext indexingContext : NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().values()) {
                            LOGGER.finer(" Shutting Down:" + indexingContext.getId());
                            NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(indexingContext, false);
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
        }
    }

    @Override
    public void updateIndexWithArtifacts(final RepositoryInfo repositoryInfo, final Collection<Artifact> collection) {
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repositoryInfo});
                    Map<String, IndexingContext> map = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = map.get(repositoryInfo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context could not be created :" + repositoryInfo.getId());
                        return null;
                    }
                    for (Artifact artifact : collection) {
                        File file;
                        String string;
                        if (artifact.getFile() != null) {
                            string = artifact.getFile().getAbsolutePath();
                        } else {
                            if (artifact.getVersion() == null) continue;
                            string = repositoryInfo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                        }
                        if (!(file = new File(string)).exists()) continue;
                        ArtifactContext artifactContext = NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, file);
                        NexusRepositoryIndexerImpl.this.indexer.addArtifactToIndex(artifactContext, indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
        }
        this.fireChangeIndex(repositoryInfo);
    }

    @Override
    public void deleteArtifactFromIndex(final RepositoryInfo repositoryInfo, final Artifact artifact) {
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    String string;
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repositoryInfo});
                    Map<String, IndexingContext> map = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = map.get(repositoryInfo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context chould not be created :" + repositoryInfo.getId());
                        return null;
                    }
                    if (artifact.getFile() != null) {
                        string = artifact.getFile().getAbsolutePath();
                    } else if (artifact.getVersion() != null) {
                        string = repositoryInfo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                    } else {
                        return null;
                    }
                    String string2 = artifact.getArtifactHandler().getExtension();
                    String string3 = string.substring(0, string.length() - string2.length());
                    string3 = string3 + "pom";
                    File file = new File(string3);
                    if (file.exists()) {
                        NexusRepositoryIndexerImpl.this.indexer.deleteArtifactFromIndex(NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, file), indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
        }
        this.fireChangeIndex(repositoryInfo);
    }

    private void fireChangeIndex(final RepositoryInfo repositoryInfo) {
        if (MUTEX.isWriteAccess()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    NexusRepositoryIndexerImpl.this.fireChangeIndex(repositoryInfo);
                }
            });
            return;
        }
        assert (!MUTEX.isWriteAccess() && !MUTEX.isReadAccess());
        repositoryInfo.fireChangeIndex();
    }

    private File getDefaultIndexLocation() {
        File file;
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            file = new File(new File(new File(string, "var"), "cache"), MAVENINDEX_PATH);
        } else {
            File file2 = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            file = new File(file2, MAVENINDEX_PATH);
        }
        file.mkdirs();
        return file;
    }

    @Override
    public Set<String> getGroups(List<RepositoryInfo> list) {
        return this.filterGroupIds("", list);
    }

    @Override
    public Set<String> filterGroupIds(final String string, final List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    Set<String> set;
                    Object object;
                    TreeSet<String> treeSet = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    ArrayList<RepositoryInfo> arrayList = new ArrayList<RepositoryInfo>();
                    for (RepositoryInfo repositoryInfo : list) {
                        if (!repositoryInfo.isLocal() && !repositoryInfo.isRemoteDownloadable()) continue;
                        object = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repositoryInfo.getId());
                        set = object.getAllGroups();
                        if (set.size() > 0) {
                            if (string.length() == 0) {
                                treeSet.addAll(set);
                                continue;
                            }
                            for (String string2 : set) {
                                if (!string2.startsWith(string)) continue;
                                treeSet.add(string2);
                            }
                            continue;
                        }
                        arrayList.add(repositoryInfo);
                    }
                    RepositoryInfo[] repositoryInfoArray2 = arrayList.toArray(new RepositoryInfo[arrayList.size()]);
                    if (repositoryInfoArray2.length > 0) {
                        RepositoryInfo repositoryInfo;
                        repositoryInfo = new BooleanQuery();
                        repositoryInfo.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string)), BooleanClause.Occur.MUST));
                        object = new GroupedSearchRequest((Query)repositoryInfo, (Grouping)new GGrouping(), new Comparator<String>(){

                            @Override
                            public int compare(String string, String string2) {
                                return string.compareTo(string2);
                            }
                        });
                        set = NexusRepositoryIndexerImpl.this.searcher.searchGrouped((GroupedSearchRequest)object, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray2));
                        treeSet.addAll(((GroupedSearchResponse)((Object)set)).getResults().keySet());
                    }
                    return treeSet;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> getRecords(final String string, final String string2, final String string3, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    String string4 = string + "|" + string2 + "|" + string3 + "|";
                    booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string4)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(flatSearchResponse.getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> getArtifacts(final String string, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    BooleanQuery booleanQuery = new BooleanQuery();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    String string2 = string + "|";
                    booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string2)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    for (ArtifactInfo artifactInfo : flatSearchResponse.getResults()) {
                        treeSet.add(artifactInfo.artifactId);
                    }
                    return treeSet;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> getVersions(final String string, final String string2, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    String string3 = string + "|" + string2 + "|";
                    booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string3)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(flatSearchResponse.getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findVersionsByClass(final String string, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    String string2 = string.replace(".", "/");
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest(NexusRepositoryIndexerImpl.this.indexer.constructQuery("c", string2.toLowerCase()), ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(NexusRepositoryIndexerImpl.this.postProcessClasses(flatSearchResponse.getResults(), string2)));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            this.rethrowTooManyClauses(mutexException);
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findDependencyUsage(final String string, final String string2, final String string3, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_GROUP, string)), BooleanClause.Occur.MUST));
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_ARTIFACT, string2)), BooleanClause.Occur.MUST));
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_VERSION, string3)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(flatSearchResponse.getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findByMD5(String string, List<RepositoryInfo> list) {
        return Collections.emptyList();
    }

    @Override
    public List<NBVersionInfo> findBySHA1(final String string, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(new BooleanClause(NexusRepositoryIndexerImpl.this.indexer.constructQuery("1", string), BooleanClause.Occur.SHOULD));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(flatSearchResponse.getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findArchetypes(List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-archetype")), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(flatSearchResponse.getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> filterPluginArtifactIds(final String string, final String string2, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    String string3 = string + "|" + string2;
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-plugin")), BooleanClause.Occur.MUST));
                    booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string3)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    for (ArtifactInfo artifactInfo : flatSearchResponse.getResults()) {
                        treeSet.add(artifactInfo.artifactId);
                    }
                    return treeSet;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterPluginGroupIds(final String string, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-plugin")), BooleanClause.Occur.MUST));
                    if (string.length() > 0) {
                        booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string)), BooleanClause.Occur.MUST));
                    }
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    for (ArtifactInfo artifactInfo : flatSearchResponse.getResults()) {
                        treeSet.add(artifactInfo.groupId);
                    }
                    return treeSet;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterArtifactIdForGroupId(final String string, final String string2, List<RepositoryInfo> list) {
        final RepositoryInfo[] repositoryInfoArray = list.toArray(new RepositoryInfo[list.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    String string3 = string + "|" + string2;
                    booleanQuery.add(new BooleanClause((Query)new PrefixQuery(new Term("u", string3)), BooleanClause.Occur.MUST));
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    FlatSearchResponse flatSearchResponse = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    for (ArtifactInfo artifactInfo : flatSearchResponse.getResults()) {
                        treeSet.add(artifactInfo.artifactId);
                    }
                    return treeSet;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> find(final List<QueryField> list, List<RepositoryInfo> list2) {
        final RepositoryInfo[] repositoryInfoArray = list2.toArray(new RepositoryInfo[list2.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    Object object2;
                    ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(repositoryInfoArray);
                    BooleanQuery booleanQuery = new BooleanQuery();
                    for (Object object2 : list) {
                        Object object3;
                        String string;
                        BooleanClause.Occur occur;
                        BooleanClause.Occur occur2 = occur = ((QueryField)object2).getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                        String string2 = NexusRepositoryIndexerImpl.this.toNexusField(((QueryField)object2).getField());
                        if (string2 == null) continue;
                        if ("c".equals(string2)) {
                            string = ((QueryField)object2).getValue().replace(".", "/");
                            object3 = NexusRepositoryIndexerImpl.this.indexer.constructQuery("c", string.toLowerCase());
                        } else {
                            object3 = "a".equals(string2) ? NexusRepositoryIndexerImpl.this.indexer.constructQuery(string2, ((QueryField)object2).getValue()) : (((QueryField)object2).getMatch() == 0 ? new TermQuery(new Term(string2, ((QueryField)object2).getValue())) : new PrefixQuery(new Term(string2, ((QueryField)object2).getValue())));
                        }
                        string = new BooleanClause(object3, occur);
                        booleanQuery.add((BooleanClause)string);
                    }
                    FlatSearchRequest flatSearchRequest = new FlatSearchRequest((Query)booleanQuery, ArtifactInfo.VERSION_COMPARATOR);
                    flatSearchRequest.setAiCount(512);
                    object2 = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(flatSearchRequest, NexusRepositoryIndexerImpl.this.getContexts(repositoryInfoArray));
                    arrayList.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(((FlatSearchResponse)object2).getResults()));
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            this.rethrowTooManyClauses(mutexException);
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    @Override
    public List<RepositoryInfo> getLoaded(final List<RepositoryInfo> list) {
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<RepositoryInfo>>(){

                public List<RepositoryInfo> run() throws Exception {
                    if (!NexusRepositoryIndexerImpl.this.inited) {
                        return Collections.emptyList();
                    }
                    ArrayList<RepositoryInfo> arrayList = new ArrayList<RepositoryInfo>(list.size());
                    for (RepositoryInfo repositoryInfo : list) {
                        if (NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repositoryInfo.getId()) == null) continue;
                        arrayList.add(repositoryInfo);
                    }
                    return arrayList;
                }
            });
        }
        catch (MutexException mutexException) {
            Exceptions.printStackTrace((Throwable)mutexException);
            return Collections.emptyList();
        }
    }

    private String toNexusField(String string) {
        if ("artifactId".equals(string)) {
            return "a";
        }
        if ("groupId".equals(string)) {
            return "g";
        }
        if ("version".equals(string)) {
            return "v";
        }
        if ("classes".equals(string)) {
            return "c";
        }
        if ("name".equals(string)) {
            return "n";
        }
        if ("description".equals(string)) {
            return "d";
        }
        if ("packaging".equals(string)) {
            return "p";
        }
        return string;
    }

    private void rethrowTooManyClauses(MutexException mutexException) {
        Exception exception = mutexException.getException();
        if (exception instanceof BooleanQuery.TooManyClauses) {
            throw (BooleanQuery.TooManyClauses)exception;
        }
    }

    private Collection<ArtifactInfo> postProcessClasses(Collection<ArtifactInfo> collection, String string) {
        int n = 40;
        boolean bl = string.contains("/");
        if (bl) {
            return collection;
        }
        String string2 = ".*/" + string + "$.*";
        Pattern pattern = Pattern.compile(string2, n);
        Iterator<ArtifactInfo> iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArtifactInfo artifactInfo = iterator.next();
            Matcher matcher = pattern.matcher(artifactInfo.classNames);
            if (matcher.matches()) continue;
            iterator.remove();
        }
        return collection;
    }

    private List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> collection) {
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo artifactInfo : collection) {
            if ("javadoc".equals(artifactInfo.classifier) || "sources".equals(artifactInfo.classifier)) continue;
            NBVersionInfo nBVersionInfo = new NBVersionInfo(artifactInfo.repository, artifactInfo.groupId, artifactInfo.artifactId, artifactInfo.version, artifactInfo.packaging, artifactInfo.packaging, artifactInfo.name, artifactInfo.description, artifactInfo.classifier);
            nBVersionInfo.setJavadocExists(artifactInfo.javadocExists == ArtifactAvailablility.PRESENT);
            nBVersionInfo.setSourcesExists(artifactInfo.sourcesExists == ArtifactAvailablility.PRESENT);
            nBVersionInfo.setSignatureExists(artifactInfo.signatureExists == ArtifactAvailablility.PRESENT);
            nBVersionInfo.setLastModified(artifactInfo.lastModified);
            nBVersionInfo.setSize(artifactInfo.size);
            arrayList.add(nBVersionInfo);
        }
        return arrayList;
    }

    private static class NbIndexCreator
    extends AbstractIndexCreator {
        public ArtifactRepository repository = EmbedderFactory.getOnlineEmbedder().getLocalRepository();

        private NbIndexCreator() {
        }

        public void updateDocument(ArtifactInfo artifactInfo, Document document) {
            ArtifactInfo artifactInfo2 = artifactInfo;
            if (artifactInfo2.classifier != null) {
                return;
            }
            try {
                MavenProject mavenProject = RepositoryUtil.readMavenProject(artifactInfo2.groupId, artifactInfo2.artifactId, artifactInfo2.version, this.repository);
                if (mavenProject != null) {
                    List list = mavenProject.getDependencies();
                    for (Dependency dependency : list) {
                        document.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_GROUP, dependency.getGroupId(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                        document.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_ARTIFACT, dependency.getArtifactId(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                        document.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_VERSION, dependency.getVersion(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                    }
                }
            }
            catch (InvalidArtifactRTException invalidArtifactRTException) {
                invalidArtifactRTException.printStackTrace();
            }
        }

        public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        }

        public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
            return false;
        }
    }
}

