/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class RemoteIndexTransferListener
implements TransferListener {
    private ProgressHandle handle;
    private RepositoryInfo info;
    private int lastunit;
    private boolean debug;
    private InputOutput io;
    private OutputWriter writer;

    public RemoteIndexTransferListener(RepositoryInfo repositoryInfo) {
        this.info = repositoryInfo;
        if (this.debug) {
            this.io = IOProvider.getDefault().getIO(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + repositoryInfo.getName(), true);
            this.writer = this.io.getOut();
        }
    }

    public void transferInitiated(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
        long l = transferEvent.getResource().getContentLength();
        this.handle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(RemoteIndexTransferListener.class, (String)"LBL_Transfer_TAG") + this.info.getName()));
        this.handle.start((int)l / 1024);
        if (this.debug) {
            this.writer.println("File Size :" + (int)l / 1024);
        }
    }

    public void transferProgress(TransferEvent transferEvent, byte[] byArray, int n) {
        int n2 = n / 1024;
        if (this.handle != null) {
            this.handle.progress(this.lastunit += n2);
        }
        if (this.debug) {
            this.writer.println("Units completed :" + this.lastunit);
        }
    }

    public void transferCompleted(TransferEvent transferEvent) {
        if (this.handle != null) {
            this.handle.finish();
        }
        if (this.debug) {
            this.writer.println("Completed");
        }
    }

    public void transferError(TransferEvent transferEvent) {
        if (this.debug) {
            this.writer.println("Finish with Errors");
        }
    }

    public void debug(String string) {
        if (this.debug) {
            this.writer.println(string);
        }
    }
}

