/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBModel;
import org.netbeans.modules.db.dataview.meta.DBPrimaryKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBMetaDataFactory {
    public static final int DB2 = 0;
    public static final int ORACLE = 1;
    public static final int SQLSERVER = 2;
    public static final int JDBC = 3;
    public static final int PostgreSQL = 4;
    public static final int MYSQL = 5;
    public static final int DERBY = 6;
    public static final int SYBASE = 7;
    public static final int AXION = 8;
    private Connection dbconn;
    private int dbType = -1;
    private DatabaseMetaData dbmeta;

    public DBMetaDataFactory(Connection connection) throws SQLException {
        assert (connection != null);
        this.dbconn = connection;
        this.dbmeta = connection.getMetaData();
        this.dbType = this.getDBType();
    }

    public boolean supportsLimit() {
        switch (this.dbType) {
            case 4: 
            case 5: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getDBType() throws SQLException {
        if (this.dbType != -1) {
            return this.dbType;
        }
        if (this.dbmeta.getURL() != null) {
            return DBMetaDataFactory.getDBTypeFromURL(this.dbmeta.getURL());
        }
        return 3;
    }

    private static int getDBTypeFromURL(String string) {
        int n = -1;
        n = (string = string.toLowerCase()).indexOf("sybase") > -1 ? 7 : (string.indexOf("sqlserver") > -1 ? 2 : (string.indexOf("db2") > -1 ? 0 : (string.indexOf("orac") > -1 ? 1 : (string.indexOf("axion") > -1 ? 8 : (string.indexOf("derby") > -1 ? 6 : (string.indexOf("postgre") > -1 ? 4 : (string.indexOf("mysql") > -1 ? 5 : 3)))))));
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBPrimaryKey getPrimaryKeys(String string, String string2, String string3) {
        ResultSet resultSet = null;
        try {
            resultSet = this.dbmeta.getPrimaryKeys(this.setToNullIfEmpty(string), this.setToNullIfEmpty(string2), string3);
            DBPrimaryKey dBPrimaryKey = new DBPrimaryKey(resultSet);
            DataViewUtils.closeResources(resultSet);
            return dBPrimaryKey;
        }
        catch (SQLException sQLException) {
            DBPrimaryKey dBPrimaryKey = null;
            return dBPrimaryKey;
        }
        finally {
            DataViewUtils.closeResources(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DBForeignKey> getForeignKeys(DBTable dBTable) {
        Map<String, DBForeignKey> map = Collections.emptyMap();
        ResultSet resultSet = null;
        try {
            resultSet = this.dbmeta.getImportedKeys(this.setToNullIfEmpty(dBTable.getCatalog()), this.setToNullIfEmpty(dBTable.getSchema()), dBTable.getName());
            map = DBForeignKey.createForeignKeyColumnMap(dBTable, resultSet);
            DataViewUtils.closeResources(resultSet);
        }
        catch (SQLException sQLException) {
            Map<String, DBForeignKey> map2 = null;
            return map2;
        }
        finally {
            DataViewUtils.closeResources(resultSet);
        }
        return map;
    }

    public synchronized Collection<DBTable> generateDBTables(ResultSet resultSet, String string, boolean bl) throws SQLException {
        Object object;
        LinkedHashMap<String, DBTable> linkedHashMap = new LinkedHashMap<String, DBTable>();
        String string2 = "UNKNOWN";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            DBTable dBTable;
            object = resultSetMetaData.getTableName(i);
            if (object == null) {
                object = string2;
            }
            String object2 = resultSetMetaData.getSchemaName(i);
            Object object3 = resultSetMetaData.getCatalogName(i);
            String string3 = (String)object3 + object2 + (String)object;
            if (string3.equals("")) {
                string3 = string2;
            }
            if ((dBTable = (DBTable)linkedHashMap.get(string3)) == null) {
                dBTable = new DBTable((String)object, object2, (String)object3);
                linkedHashMap.put(string3, dBTable);
            }
            int n = resultSetMetaData.getColumnType(i);
            String string4 = resultSetMetaData.getColumnTypeName(i);
            if (n == 1111 && this.dbType == 1) {
                if (string4.startsWith("TIMESTAMP")) {
                    n = 93;
                } else if (string4.startsWith("FLOAT")) {
                    n = 6;
                } else if (string4.startsWith("REAL")) {
                    n = 7;
                } else if (string4.startsWith("BLOB")) {
                    n = 2004;
                } else if (string4.startsWith("CLOB")) {
                    n = 2005;
                }
            }
            String string5 = resultSetMetaData.getColumnName(i);
            int n2 = i;
            int n3 = resultSetMetaData.getScale(i);
            int n4 = resultSetMetaData.getPrecision(i);
            boolean bl2 = resultSetMetaData.isNullable(i) == 1;
            String string6 = resultSetMetaData.getColumnLabel(i);
            int n5 = resultSetMetaData.getColumnDisplaySize(i);
            boolean bl3 = resultSetMetaData.isAutoIncrement(i);
            if (n == 91 && this.dbType == 1) {
                n = 93;
                n5 = 22;
            }
            if (n == -3 && this.dbType == 5 && string4.startsWith("BIT")) {
                n = -7;
            }
            if (n == -2 && this.dbType == 2 && n4 == 8) {
                bl3 = true;
            }
            DBColumn dBColumn = new DBColumn(dBTable, string5, n, string4, n3, n4, bl2, bl3);
            dBColumn.setOrdinalPosition(n2);
            dBColumn.setDisplayName(string6);
            dBColumn.setDisplaySize(n5);
            dBTable.addColumn(dBColumn);
            dBTable.setQuoter(SQLIdentifiers.createQuoter((DatabaseMetaData)this.dbmeta));
        }
        DBTable dBTable = (DBTable)linkedHashMap.get(string2);
        if (linkedHashMap.size() == 1 && dBTable != null && bl) {
            this.adjustTableMetadata(string, (DBTable)linkedHashMap.get(string2));
            for (DBColumn dBColumn : dBTable.getColumns().values()) {
                dBColumn.setEditable(!dBTable.getName().equals("") && !dBColumn.isGenerated());
            }
        }
        object = new DBModel();
        ((DBModel)object).setDBType(this.getDBType());
        for (Object object3 : linkedHashMap.values()) {
            if (DataViewUtils.isNullString(((DBTable)object3).getName())) continue;
            this.checkPrimaryKeys((DBTable)object3);
            this.checkForeignKeys((DBTable)object3);
            ((DBModel)object).addTable((DBTable)object3);
            this.populateDefaults((DBTable)object3);
        }
        return linkedHashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void populateDefaults(DBTable dBTable) {
        ResultSet resultSet = null;
        try {
            resultSet = this.dbmeta.getColumns(this.setToNullIfEmpty(dBTable.getCatalog()), this.setToNullIfEmpty(dBTable.getSchema()), dBTable.getName(), "%");
            while (resultSet.next()) {
                String string = resultSet.getString("COLUMN_DEF");
                DBColumn dBColumn = dBTable.getColumn(resultSet.getString("COLUMN_NAME"));
                if (dBColumn == null || string == null || string.trim().length() == 0) continue;
                dBColumn.setDefaultValue(string.trim());
            }
        }
        catch (SQLException sQLException) {
            DataViewUtils.closeResources(resultSet);
            catch (Throwable throwable) {
                DataViewUtils.closeResources(resultSet);
                throw throwable;
            }
        }
        DataViewUtils.closeResources(resultSet);
    }

    private void adjustTableMetadata(String string, DBTable dBTable) {
        String[] stringArray;
        String string2 = "";
        if (string.toUpperCase().contains("FROM")) {
            stringArray = string.toUpperCase().split("FROM");
            String string3 = string.substring(string.length() - stringArray[1].length());
            if (string3.toUpperCase().contains("WHERE")) {
                stringArray = string3.toUpperCase().split("WHERE");
                string3 = string3.substring(0, stringArray[0].length());
            }
            if (!string.toUpperCase().contains("JOIN")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken().trim();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = "";
                }
            }
        }
        if ((stringArray = string2.split("\\.")).length == 3) {
            dBTable.setCatalogName(this.unQuoteIfNeeded(stringArray[0]));
            dBTable.setSchemaName(this.unQuoteIfNeeded(stringArray[1]));
            dBTable.setName(this.unQuoteIfNeeded(stringArray[2]));
        } else if (stringArray.length == 2) {
            dBTable.setSchemaName(this.unQuoteIfNeeded(stringArray[0]));
            dBTable.setName(this.unQuoteIfNeeded(stringArray[1]));
        } else if (stringArray.length == 1) {
            dBTable.setName(this.unQuoteIfNeeded(stringArray[0]));
        }
    }

    private String unQuoteIfNeeded(String string) {
        String string2 = "\"";
        try {
            string2 = this.dbmeta.getIdentifierQuoteString().trim();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string.replaceAll(string2, "");
    }

    private void checkPrimaryKeys(DBTable dBTable) {
        DBPrimaryKey dBPrimaryKey = this.getPrimaryKeys(dBTable.getCatalog(), dBTable.getSchema(), dBTable.getName());
        if (dBPrimaryKey != null && dBPrimaryKey.getColumnCount() != 0) {
            dBTable.setPrimaryKey(dBPrimaryKey);
            List<DBColumn> list = dBTable.getColumnList();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DBColumn dBColumn = list.get(i);
                    if (!dBPrimaryKey.contains(dBColumn.getName())) continue;
                    dBColumn.setPrimaryKey(true);
                }
            }
        }
    }

    private void checkForeignKeys(DBTable dBTable) {
        Map<String, DBForeignKey> map = this.getForeignKeys(dBTable);
        if (map != null && map.size() != 0) {
            dBTable.setForeignKeyMap(map);
            HashSet<String> hashSet = new HashSet<String>();
            for (DBForeignKey list2 : map.values()) {
                if (list2 == null) continue;
                hashSet.addAll(list2.getColumnNames());
            }
            List<DBColumn> list = dBTable.getColumnList();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DBColumn dBColumn = list.get(i);
                    if (!hashSet.contains(dBColumn.getName())) continue;
                    dBColumn.setForeignKey(true);
                }
            }
        }
    }

    private String setToNullIfEmpty(String string) {
        if (string != null && string.equals("")) {
            string = null;
        }
        return string;
    }
}

